/*
 * Decompiled with CFR 0.152.
 */
package org.egov.bpa.application.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.bpa.application.entity.Application;
import org.egov.bpa.application.entity.ApplicationFeeDetail;
import org.egov.bpa.application.entity.BpaStatus;
import org.egov.infra.workflow.entity.StateAware;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGBPA_APPLICATION_FEE")
@SequenceGenerator(name="SEQ_EGBPA_APPLICATION_FEE", sequenceName="SEQ_EGBPA_APPLICATION_FEE", allocationSize=1)
public class ApplicationFee
extends StateAware {
    private static final long serialVersionUID = 3078684328383202788L;
    public static final String SEQ_APPLICATIONFEE = "SEQ_EGBPA_APPLICATION_FEE";
    @Id
    @GeneratedValue(generator="SEQ_EGBPA_APPLICATION_FEE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    private Date feeDate;
    @Length(min=1, max=1024)
    private String feeRemarks;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private BpaStatus status;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Application application;
    @Length(min=1, max=128)
    private String challanNumber;
    @OneToMany(mappedBy="applicationFee", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ApplicationFeeDetail> applicationFeeDetail = new ArrayList<ApplicationFeeDetail>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getFeeDate() {
        return this.feeDate;
    }

    public void setFeeDate(Date feeDate) {
        this.feeDate = feeDate;
    }

    public String getFeeRemarks() {
        return this.feeRemarks;
    }

    public void setFeeRemarks(String feeRemarks) {
        this.feeRemarks = feeRemarks;
    }

    public BpaStatus getStatus() {
        return this.status;
    }

    public void setStatus(BpaStatus status) {
        this.status = status;
    }

    public String getChallanNumber() {
        return this.challanNumber;
    }

    public void setChallanNumber(String challanNumber) {
        this.challanNumber = challanNumber;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public String getStateDetails() {
        return null;
    }

    public List<ApplicationFeeDetail> getApplicationFeeDetail() {
        return this.applicationFeeDetail;
    }

    public void setApplicationFeeDetail(List<ApplicationFeeDetail> applicationFeeDetail) {
        this.applicationFeeDetail = applicationFeeDetail;
    }
}

