/*
 * Decompiled with CFR 0.152.
 */
package org.egov.bpa.application.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.bpa.application.entity.ApplicationDocument;
import org.egov.bpa.application.entity.ApplicationFee;
import org.egov.bpa.application.entity.ApplicationNocDocument;
import org.egov.bpa.application.entity.ApplicationStakeHolder;
import org.egov.bpa.application.entity.AutoDcrMap;
import org.egov.bpa.application.entity.BpaStatus;
import org.egov.bpa.application.entity.BuildingDetail;
import org.egov.bpa.application.entity.DocumentHistory;
import org.egov.bpa.application.entity.Inspection;
import org.egov.bpa.application.entity.LettertoParty;
import org.egov.bpa.application.entity.PermittedFloorDetail;
import org.egov.bpa.application.entity.ServiceType;
import org.egov.bpa.application.entity.SiteDetail;
import org.egov.bpa.application.entity.enums.Occupancy;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGBPA_APPLICATION")
@SequenceGenerator(name="SEQ_EGBPA_APPLICATION", sequenceName="SEQ_EGBPA_APPLICATION", allocationSize=1)
public class Application
extends AbstractAuditable {
    private static final long serialVersionUID = -361205348191992865L;
    public static final String SEQ_APPLICATION = "SEQ_EGBPA_APPLICATION";
    @Id
    @GeneratedValue(generator="SEQ_EGBPA_APPLICATION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="stakeHolder", nullable=false)
    private List<ApplicationStakeHolder> stakeHolder = new ArrayList<ApplicationStakeHolder>(0);
    @Length(min=1, max=128)
    private String buildingplanapprovalnumber;
    @Temporal(value=TemporalType.DATE)
    private Date buildingPlanApprovalDate;
    @NotNull
    @Length(min=1, max=128)
    private String applicationNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date applicationDate;
    @Temporal(value=TemporalType.DATE)
    private Date approvalDate;
    @Length(min=1, max=128)
    private String assessmentNumber;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private Source source;
    @NotNull
    @Length(min=1, max=128)
    private String applicantType;
    @NotNull
    @Length(min=1, max=128)
    private String applicantMode;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="serviceType")
    private ServiceType serviceType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="status")
    private BpaStatus status;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private User owner;
    @Length(min=1, max=128)
    private String planPermissionNumber;
    @Temporal(value=TemporalType.DATE)
    private Date planPermissionDate;
    @Length(min=1, max=128)
    private String oldApplicationNumber;
    @Length(min=1, max=128)
    private String tapalNumber;
    @Enumerated(value=EnumType.ORDINAL)
    private Occupancy occupancy;
    @Length(min=1, max=128)
    private String governmentType;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="demand")
    private EgDemand demand;
    @Length(min=1, max=128)
    private String tapanNumber;
    @Length(min=1, max=128)
    private String remarks;
    @Length(min=1, max=128)
    private String projectName;
    @Length(min=1, max=128)
    private String groupDevelopment;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="siteDetail")
    private SiteDetail siteDetail;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="buildingDetail")
    private BuildingDetail buildingDetail;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="documentHistory")
    private DocumentHistory documentHistory;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="permittedFloorDetail")
    private PermittedFloorDetail permittedFloorDetail;
    @OneToMany(mappedBy="application", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<AutoDcrMap> autoDcr = new ArrayList<AutoDcrMap>();
    @OneToMany(mappedBy="application", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<ApplicationDocument> applicationDocument = new ArrayList<ApplicationDocument>(0);
    @OneToMany(mappedBy="application", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<ApplicationNocDocument> applicationNOCDocument = new ArrayList<ApplicationNocDocument>(0);
    @OneToMany(mappedBy="application", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<Inspection> inspections = new ArrayList<Inspection>();
    @OneToMany(mappedBy="application", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<LettertoParty> lettertoParty = new ArrayList<LettertoParty>();
    @OneToMany(mappedBy="application", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<ApplicationFee> applicationFee = new ArrayList<ApplicationFee>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBuildingplanapprovalnumber() {
        return this.buildingplanapprovalnumber;
    }

    public void setBuildingplanapprovalnumber(String buildingplanapprovalnumber) {
        this.buildingplanapprovalnumber = buildingplanapprovalnumber;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public String getAssessmentNumber() {
        return this.assessmentNumber;
    }

    public void setAssessmentNumber(String assessmentNumber) {
        this.assessmentNumber = assessmentNumber;
    }

    public String getApplicantType() {
        return this.applicantType;
    }

    public void setApplicantType(String applicantType) {
        this.applicantType = applicantType;
    }

    public String getApplicantMode() {
        return this.applicantMode;
    }

    public void setApplicantMode(String applicantMode) {
        this.applicantMode = applicantMode;
    }

    public BpaStatus getStatus() {
        return this.status;
    }

    public void setStatus(BpaStatus status) {
        this.status = status;
    }

    public String getPlanPermissionNumber() {
        return this.planPermissionNumber;
    }

    public void setPlanPermissionNumber(String planPermissionNumber) {
        this.planPermissionNumber = planPermissionNumber;
    }

    public Date getPlanPermissionDate() {
        return this.planPermissionDate;
    }

    public void setPlanPermissionDate(Date planPermissionDate) {
        this.planPermissionDate = planPermissionDate;
    }

    public String getOldApplicationNumber() {
        return this.oldApplicationNumber;
    }

    public void setOldApplicationNumber(String oldApplicationNumber) {
        this.oldApplicationNumber = oldApplicationNumber;
    }

    public String getTapalNumber() {
        return this.tapalNumber;
    }

    public void setTapalNumber(String tapalNumber) {
        this.tapalNumber = tapalNumber;
    }

    public Occupancy getOccupancy() {
        return this.occupancy;
    }

    public void setOccupancy(Occupancy occupancy) {
        this.occupancy = occupancy;
    }

    public String getGovernmentType() {
        return this.governmentType;
    }

    public void setGovernmentType(String governmentType) {
        this.governmentType = governmentType;
    }

    public EgDemand getDemand() {
        return this.demand;
    }

    public void setDemand(EgDemand demand) {
        this.demand = demand;
    }

    public String getTapanNumber() {
        return this.tapanNumber;
    }

    public void setTapanNumber(String tapanNumber) {
        this.tapanNumber = tapanNumber;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getGroupDevelopment() {
        return this.groupDevelopment;
    }

    public void setGroupDevelopment(String groupDevelopment) {
        this.groupDevelopment = groupDevelopment;
    }

    public List<AutoDcrMap> getAutoDcr() {
        return this.autoDcr;
    }

    public void setAutoDcr(List<AutoDcrMap> autoDcr) {
        this.autoDcr = autoDcr;
    }

    public List<Inspection> getInspections() {
        return this.inspections;
    }

    public void setInspections(List<Inspection> inspections) {
        this.inspections = inspections;
    }

    public BuildingDetail getBuildingDetail() {
        return this.buildingDetail;
    }

    public void setBuildingDetail(BuildingDetail buildingDetail) {
        this.buildingDetail = buildingDetail;
    }

    public DocumentHistory getDocumentHistory() {
        return this.documentHistory;
    }

    public void setDocumentHistory(DocumentHistory documentHistory) {
        this.documentHistory = documentHistory;
    }

    public PermittedFloorDetail getPermittedFloorDetail() {
        return this.permittedFloorDetail;
    }

    public void setPermittedFloorDetail(PermittedFloorDetail permittedFloorDetail) {
        this.permittedFloorDetail = permittedFloorDetail;
    }

    public List<LettertoParty> getLettertoParty() {
        return this.lettertoParty;
    }

    public void setLettertoParty(List<LettertoParty> lettertoParty) {
        this.lettertoParty = lettertoParty;
    }

    public List<ApplicationFee> getApplicationFee() {
        return this.applicationFee;
    }

    public void setApplicationFee(List<ApplicationFee> applicationFee) {
        this.applicationFee = applicationFee;
    }

    public List<ApplicationStakeHolder> getStakeHolder() {
        return this.stakeHolder;
    }

    public void setStakeHolder(List<ApplicationStakeHolder> stakeHolder) {
        this.stakeHolder = stakeHolder;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public SiteDetail getSiteDetail() {
        return this.siteDetail;
    }

    public void setSiteDetail(SiteDetail siteDetail) {
        this.siteDetail = siteDetail;
    }

    public List<ApplicationDocument> getApplicationDocument() {
        return this.applicationDocument;
    }

    public void setApplicationDocument(List<ApplicationDocument> applicationDocument) {
        this.applicationDocument = applicationDocument;
    }

    public List<ApplicationNocDocument> getApplicationNOCDocument() {
        return this.applicationNOCDocument;
    }

    public void setApplicationNOCDocument(List<ApplicationNocDocument> applicationNOCDocument) {
        this.applicationNOCDocument = applicationNOCDocument;
    }

    public Date getBuildingPlanApprovalDate() {
        return this.buildingPlanApprovalDate;
    }

    public void setBuildingPlanApprovalDate(Date buildingPlanApprovalDate) {
        this.buildingPlanApprovalDate = buildingPlanApprovalDate;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }
}

