/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.egov.assets.autonumber.AssetCategoryCodeGenerator;
import org.egov.assets.model.AssetCategory;
import org.egov.assets.model.CategoryPropertyType;
import org.egov.assets.service.AssetCategoryService;
import org.egov.assets.service.CategoryPropertyTypeService;
import org.egov.assets.web.adaptor.AssetCategoryJsonAdaptor;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.service.UOMService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/assetcategory"})
public class AssetCategoryController {
    private static final String ASSETCATEGORY_NEW = "assetcategory-new";
    private static final String ASSETCATEGORY_RESULT = "assetcategory-result";
    private static final String ASSETCATEGORY_EDIT = "assetcategory-edit";
    private static final String ASSETCATEGORY_VIEW = "assetcategory-view";
    private static final String ASSETCATEGORY_SEARCH = "assetcategory-search";
    private static final String ASSETCATEGORY_PROPERTIES = "assetcategory_properties";
    @Autowired
    private AssetCategoryService assetCategoryService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsService;
    @Autowired
    private UOMService uomService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private CategoryPropertyTypeService categoryPropertyTypeService;

    private void prepareNewForm(Model model) {
        model.addAttribute("assetTypes", Arrays.asList(AssetCategory.AssetType.values()));
        model.addAttribute("assetCategorys", (Object)this.assetCategoryService.findAll());
        model.addAttribute("depreciationMethods", Arrays.asList(AssetCategory.DepreciationMethod.values()));
        AppConfigValues accountCodePurposeId = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "ASSET_ACCOUNT_CODE_PURPOSEID").get(0);
        model.addAttribute("accountCodes", (Object)this.chartOfAccountsService.getAccountCodeByPurpose(Integer.valueOf(accountCodePurposeId.getValue())));
        AppConfigValues accountDepPurposeId = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "ACCUMULATED_DEPRECIATION_PURPOSEID").get(0);
        model.addAttribute("accountDeps", (Object)this.chartOfAccountsService.getAccountCodeByPurpose(Integer.valueOf(accountDepPurposeId.getValue())));
        AppConfigValues accountDepExpPurposeId = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "DEPRECIATION_EXPENSE_ACCOUNT_PURPOSEID").get(0);
        model.addAttribute("accountDepExps", (Object)this.chartOfAccountsService.getAccountCodeByPurpose(Integer.valueOf(accountDepExpPurposeId.getValue())));
        AppConfigValues accountRevResPurposeId = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "REVALUATION_RESERVE_ACCOUNT_PURPOSEID").get(0);
        model.addAttribute("accountRevRess", (Object)this.chartOfAccountsService.getAccountCodeByPurpose(Integer.valueOf(accountRevResPurposeId.getValue())));
        model.addAttribute("uOMs", (Object)this.uomService.findAllOrderByCategory());
        AppConfigValues assetCategoryCreationCode = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "Asset_category_code_creation_mode").get(0);
        model.addAttribute("codeGenerationMode", (Object)assetCategoryCreationCode.getValue());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("assetCategory", (Object)new AssetCategory());
        return ASSETCATEGORY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute AssetCategory assetCategory, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        AppConfigValues assetCategoryCreationCode = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "Asset_category_code_creation_mode").get(0);
        if (!assetCategoryCreationCode.getValue().equalsIgnoreCase("Auto") && (assetCategory.getCode() == null || assetCategory.getCode().isEmpty())) {
            errors.addError(new ObjectError("accountCodes", this.messageSource.getMessage("comment.not.null", null, null)));
        }
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ASSETCATEGORY_NEW;
        }
        if (assetCategoryCreationCode.getValue().equals("Auto")) {
            AssetCategoryCodeGenerator assetCategoryCodeGenerator = (AssetCategoryCodeGenerator)this.beanResolver.getAutoNumberServiceFor(AssetCategoryCodeGenerator.class);
            String assetCategoryNumber = assetCategoryCodeGenerator.getNextNumber(assetCategory);
            assetCategory.setCode(assetCategoryNumber);
        }
        this.assetCategoryService.create(assetCategory);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.assetcategory.success", null, null));
        return "redirect:/assetcategory/result/" + assetCategory.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        AssetCategory assetCategory = this.assetCategoryService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("assetCategory", (Object)assetCategory);
        return ASSETCATEGORY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute AssetCategory assetCategory, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ASSETCATEGORY_EDIT;
        }
        this.assetCategoryService.update(assetCategory);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.assetcategory.success", null, null));
        return "redirect:/assetcategory/result/" + assetCategory.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        AssetCategory assetCategory = this.assetCategoryService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("assetCategory", (Object)assetCategory);
        return ASSETCATEGORY_VIEW;
    }

    @RequestMapping(value={"/properties/{id}"}, method={RequestMethod.GET})
    public String properties(@PathVariable(value="id") Long id, Model model) {
        AssetCategory assetCategory = this.assetCategoryService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("assetCategory", (Object)assetCategory);
        return "assetcategory-properties";
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        AssetCategory assetCategory = this.assetCategoryService.findOne(id);
        model.addAttribute("assetCategory", (Object)assetCategory);
        return ASSETCATEGORY_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        AssetCategory assetCategory = new AssetCategory();
        this.prepareNewForm(model);
        model.addAttribute("assetCategory", (Object)assetCategory);
        return ASSETCATEGORY_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute AssetCategory assetCategory) {
        List searchResultList = this.assetCategoryService.search(assetCategory);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/getParentAccounts/{parentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getParentAccounts(@PathVariable(value="parentId") Long parentId) {
        AssetCategory assetCategory = this.assetCategoryService.findOne(parentId);
        String result = "assetAccountCode:" + (assetCategory.getAssetAccountCode() == null ? "" : assetCategory.getAssetAccountCode().getId()) + ",accDepAccountCode:" + (assetCategory.getAccDepAccountCode() == null ? "" : assetCategory.getAccDepAccountCode().getId()) + ",revAccountCode:" + (assetCategory.getRevAccountCode() == null ? "" : assetCategory.getRevAccountCode().getId()) + ",depExpAccountCode:" + (assetCategory.getDepExpAccountCode() == null ? "" : assetCategory.getDepExpAccountCode().getId()) + ",uom:" + (assetCategory.getUom() == null ? "" : Long.valueOf(assetCategory.getUom().getId()));
        return result;
    }

    @RequestMapping(value={"/masterdata"}, method={RequestMethod.GET})
    @ResponseBody
    public String fetchMasterData(@RequestParam(value="id") Long id, @RequestParam(value="value") String value) {
        CategoryPropertyType category = this.categoryPropertyTypeService.findOne(id);
        List resultList = this.categoryPropertyTypeService.getMasterData(category, value);
        return this.toMasterDataJson(resultList, category.getEnumValues());
    }

    @RequestMapping(value={"/categoryproperty/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public void deleteCategoryProperty(@RequestParam(value="categoryPropertyId") Long categoryPropertyId) {
        this.categoryPropertyTypeService.delete(categoryPropertyId);
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(AssetCategory.class, (Object)new AssetCategoryJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private String toMasterDataJson(List<?> resultList, String value) {
        JsonArray response = new JsonArray();
        try {
            Class<?> c = Class.forName(value);
            for (Object classObj : resultList) {
                JsonObject jsonObject = new JsonObject();
                Method idMethod = c.getMethod("getId", new Class[0]);
                Method nameMethod = c.getMethod("getName", new Class[0]);
                Long idValue = (Long)idMethod.invoke(classObj, new Object[0]);
                String nameValue = (String)nameMethod.invoke(classObj, new Object[0]);
                jsonObject.addProperty("id", (Number)idValue);
                jsonObject.addProperty("name", nameValue);
                response.add((JsonElement)jsonObject);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException | SecurityException exception) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return response.toString();
    }
}

