/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.web.actions.assetmaster;

import java.util.Arrays;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.egov.asset.model.Asset;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.model.AssetType;
import org.egov.asset.util.AssetCommonUtil;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AssetBaseSearchAction
extends SearchFormAction {
    private static final long serialVersionUID = 3403911393047059235L;
    protected Asset asset = new Asset();
    protected String assetType;
    protected Long zoneId;
    @Autowired
    private AssetCommonUtil assetCommonUtil;
    private static final Logger LOGGER = Logger.getLogger(AssetBaseSearchAction.class);

    public AssetBaseSearchAction() {
        this.addRelatedEntity("department", Department.class);
        this.addRelatedEntity("assetCategory", AssetCategory.class);
        this.addRelatedEntity("area", Boundary.class);
        this.addRelatedEntity("location", Boundary.class);
        this.addRelatedEntity("street", Boundary.class);
        this.addRelatedEntity("ward", Boundary.class);
        this.addRelatedEntity("zone", Boundary.class);
        this.addRelatedEntity("status", EgwStatus.class);
    }

    public abstract SearchQuery prepareQuery(String var1, String var2);

    public Object getModel() {
        return this.asset;
    }

    public void prepare() {
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"area", "location", "street", "ward", "zone", "status"});
        this.addDropdownData("assetTypeList", Arrays.asList(AssetType.values()));
        this.addDropdownData("areaList", Collections.EMPTY_LIST);
        this.addDropdownData("locationList", Collections.EMPTY_LIST);
        this.addDropdownData("wardList", Collections.EMPTY_LIST);
        this.addDropdownData("streetList", Collections.EMPTY_LIST);
        this.addDropdownData("zoneList", this.assetCommonUtil.getAllZoneOfHTypeAdmin());
    }

    protected void loadPreviousData() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Loading ajax data");
        }
        this.setAssetType(this.assetType);
        if (null != this.zoneId && this.zoneId != -1L) {
            this.addDropdownData("wardList", this.assetCommonUtil.populateWard(this.zoneId));
        }
        if (null != this.asset.getWard() && this.asset.getWard().getId() != -1L) {
            this.addDropdownData("streetList", this.assetCommonUtil.populateStreets(this.asset.getWard().getId()));
            this.addDropdownData("areaList", this.assetCommonUtil.populateArea(this.asset.getWard().getId()));
        }
        if (null != this.asset.getArea() && this.asset.getArea().getId() != -1L) {
            this.addDropdownData("locationList", this.assetCommonUtil.populateLocations(this.asset.getArea().getId()));
        }
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }
}

