/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.web.actions.assetmaster;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.asset.model.Asset;
import org.egov.asset.model.AssetActivities;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.model.AssetType;
import org.egov.asset.model.ModeOfAcquisition;
import org.egov.asset.service.AppService;
import org.egov.asset.service.AssetActivitiesService;
import org.egov.asset.service.AssetCategoryService;
import org.egov.asset.service.AssetService;
import org.egov.asset.util.AssetIdentifier;
import org.egov.asset.web.actions.assetmaster.AjaxAssetAction;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="asset-new.jsp"), @Result(name="search", location="asset-search.jsp"), @Result(name="edit", location="asset-edit.jsp"), @Result(name="searchplugin", location="asset-searchplugin.jsp"), @Result(name="create", location="asset-create.jsp"), @Result(name="plugin", location="asset-plugin.jsp")})
public class AssetAction
extends SearchFormAction {
    private static final long serialVersionUID = 4814346089005994541L;
    public static final String SEARCH = "search";
    public static final String SEARCH_PLUGIN = "searchplugin";
    public static final String CREATE_PLUGIN = "create";
    public static final String PLUGIN = "plugin";
    public static final String VIEW = "view";
    private static final Logger LOGGER = Logger.getLogger(AssetAction.class);
    private AssetService assetService;
    private AssetActivitiesService assetActivitiesService;
    private AppService appService;
    private Asset asset = new Asset();
    private List<Asset> assetList = null;
    private Long id;
    private static final String LOCATION_HIERARCHY_TYPE = "LOCATION";
    private static final String ADMIN_HIERARCHY_TYPE = "ADMINISTRATION";
    private static final String AREA_BOUNDARY_TYPE = "Area";
    private static final String LOACTION_BOUNDARY_TYPE = "Locality";
    private static final String WARD_BOUNDARY_TYPE = "Ward";
    private static final String Zone_BOUNDARY_TYPE = "Zone";
    private static final String Asset_SAVE_SUCCESS = "asset.save.success";
    private static final String WardList = "wardList";
    private static final String StatusList = "statusList";
    private String userMode;
    private boolean fDisabled;
    private boolean sDisabled;
    private String dataDisplayStyle;
    private Integer rowId;
    private Long parentId;
    private String assetType;
    private Long departmentId;
    private List<Integer> statusId;
    private List<String> assetStatus;
    private String code;
    private String description;
    private Long locationId;
    private Long zoneId;
    private Long areaId;
    private Long streetId;
    private Long street2Id;
    private Long wardId;
    private String selectType;
    private String isAutoGeneratedCode;
    private String category;
    private String searchBy;
    private String messageKey;
    private final List<Long> assetChildCategoryList = new LinkedList();
    Query query = null;
    private BigDecimal lengthValue;
    private BigDecimal widthValue;
    private BigDecimal areaValue;
    private Long parentCategoryId;
    private List<Long> subCategoryIds;
    private Boolean fromDiaryModule = Boolean.FALSE;
    private String actionType;
    private AssetCategoryService assetCategoryService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private HierarchyTypeService hierarchyTypeService;
    @Autowired
    private CrossHierarchyService crossHeirarchyService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    public AssetAction() {
        this.addRelatedEntity("department", Department.class);
        this.addRelatedEntity("assetCategory", AssetCategory.class);
        this.addRelatedEntity("area", Boundary.class);
        this.addRelatedEntity("location", Boundary.class);
        this.addRelatedEntity("street", Boundary.class);
        this.addRelatedEntity("street2", Boundary.class);
        this.addRelatedEntity("ward", Boundary.class);
        this.addRelatedEntity("zone", Boundary.class);
        this.addRelatedEntity("status", EgwStatus.class);
    }

    public void prepare() {
        List street2List;
        Boundary parentBoundary;
        BoundaryType childBoundaryType;
        List wardList;
        BoundaryType bType;
        this.isAutoGeneratedCode = this.appService.getUniqueAppConfigValue("IS_ASSET_CODE_AUTOGENERATED");
        if (this.id != null && this.id != -1L) {
            this.asset = (Asset)this.assetService.findById((Serializable)this.id, false);
            List activities = this.assetActivitiesService.getAssetActivitiesByAssetId(this.asset.getId());
            if (activities != null && !activities.isEmpty()) {
                this.asset.setGrossValue(((AssetActivities)activities.get(0)).getAdditionAmount());
            }
        }
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"area", "location", "street", "street2", "ward", "zone", "status"});
        this.addDropdownData("assetTypeList", Arrays.asList(AssetType.values()));
        this.addDropdownData("acquisitionModeList", Arrays.asList(ModeOfAcquisition.values()));
        HierarchyType hType = this.hierarchyTypeService.getHierarchyTypeByName(LOCATION_HIERARCHY_TYPE);
        List areaList = new ArrayList();
        if ((this.asset.getArea() != null || this.areaId != null) && (bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(AREA_BOUNDARY_TYPE, hType)) != null) {
            areaList = this.boundaryService.getAllBoundariesByBoundaryTypeId(bType.getId());
        }
        this.addDropdownData("areaList", areaList);
        this.addDropdownData("parentCatList", this.assetCategoryService.getAllParentAssetCategory());
        AjaxAssetAction ajaxAssetAction = new AjaxAssetAction();
        ajaxAssetAction.setPersistenceService(this.getPersistenceService());
        this.populateSubCategories(ajaxAssetAction);
        List locationList = new ArrayList();
        try {
            if (this.asset.getArea() != null) {
                locationList = this.boundaryService.getChildBoundariesByBoundaryId(this.asset.getArea().getId());
            }
            if (this.areaId != null) {
                locationList = this.boundaryService.getChildBoundariesByBoundaryId(this.areaId);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading location - location." + e.getMessage()));
        }
        this.addDropdownData("locationList", locationList);
        if (this.zoneId == null) {
            wardList = new ArrayList();
            this.addDropdownData(WardList, wardList);
        } else {
            wardList = null;
            try {
                wardList = this.boundaryService.getChildBoundariesByBoundaryId(this.zoneId);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while loading wards - wards." + e.getMessage()));
            }
            this.addDropdownData(WardList, wardList);
        }
        this.addDropdownData("wardsList", this.getAllWard());
        List streetList = new ArrayList();
        if (this.wardId != null) {
            childBoundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType("Street", hType);
            parentBoundary = this.boundaryService.getBoundaryById(this.wardId);
            streetList = this.crossHeirarchyService.getCrossHierarchyChildrens(parentBoundary, childBoundaryType);
        }
        if (this.asset.getWard() != null) {
            childBoundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType("Street", hType);
            parentBoundary = this.boundaryService.getBoundaryById(this.asset.getWard().getId());
            streetList = this.crossHeirarchyService.getCrossHierarchyChildrens(parentBoundary, childBoundaryType);
        }
        this.addDropdownData("streetList", streetList);
        if (this.locationId == null) {
            street2List = new ArrayList();
            this.addDropdownData("street2List", street2List);
        } else {
            street2List = null;
            try {
                street2List = this.boundaryService.getChildBoundariesByBoundaryId(this.locationId);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while loading wards - wards." + e.getMessage()));
            }
            this.addDropdownData("street2List", street2List);
        }
        this.addDropdownData(StatusList, this.egwStatusHibernateDAO.getStatusByModule("ASSET"));
        this.addDropdownData("zoneList", this.getAllZone());
        if (this.searchBy == null) {
            this.searchBy = "1";
        }
    }

    private void populateSubCategories(AjaxAssetAction ajaxAssetAction) {
        if (this.parentCategoryId != null && this.parentCategoryId != -1L) {
            ajaxAssetAction.setParentCatId(this.parentCategoryId);
            ajaxAssetAction.setAssetCategoryService(this.assetCategoryService);
            ajaxAssetAction.populateSubCategories();
            this.addDropdownData("subCategoriesList", ajaxAssetAction.getAssetSubCategoryList());
        } else {
            this.addDropdownData("subCategoriesList", Collections.emptyList());
        }
    }

    @Action(value="/assetmaster/asset-newform")
    public String newform() {
        this.userMode = "new";
        return this.showform();
    }

    @Action(value="/assetmaster/asset-showform")
    public String showform() {
        LOGGER.info((Object)("****User Mode: " + this.userMode));
        String result = null;
        if (this.userMode == null) {
            this.userMode = "new";
        }
        if ("new".equals(this.userMode)) {
            this.fDisabled = false;
            this.sDisabled = false;
            result = "new";
        } else if (VIEW.equals(this.userMode)) {
            if (this.id == null) {
                this.addActionError(this.getText("asset.category.id.null"));
                result = SEARCH;
            } else {
                this.fDisabled = true;
                this.sDisabled = true;
                this.setLocationDetails(this.asset);
                result = "new";
            }
        } else if ("edit".equals(this.userMode)) {
            if (this.id == null) {
                this.addActionError(this.getText("asset.id.null"));
                result = SEARCH;
            } else {
                this.fDisabled = false;
                this.sDisabled = false;
                this.setCategory(this.category);
                this.setLocationDetails(this.asset);
                result = "new";
            }
        }
        return result;
    }

    private void setLocationDetails(Asset asset) {
        if (asset.getArea() != null) {
            List locationList = new LinkedList();
            try {
                locationList = this.boundaryService.getActiveChildBoundariesByBoundaryId(asset.getArea().getId());
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while loading locations - locations." + e.getMessage()));
                this.addFieldError("location", "Unable to load location information");
                throw new ApplicationRuntimeException("Unable to load location information", (Throwable)e);
            }
            this.addDropdownData("locationList", locationList);
        }
        if (asset.getWard() != null) {
            AjaxAssetAction ajaxAssetAction = new AjaxAssetAction();
            ajaxAssetAction.setHeirarchyTypeService(this.hierarchyTypeService);
            ajaxAssetAction.setCrossHeirarchyService(this.crossHeirarchyService);
            ajaxAssetAction.setBoundaryService(this.boundaryService);
            ajaxAssetAction.setBoundaryTypeService(this.boundaryTypeService);
            ajaxAssetAction.setWardId(asset.getWard().getId());
            try {
                ajaxAssetAction.populateStreets();
                this.addDropdownData("streetList", ajaxAssetAction.getStreetList());
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while loading Streets." + e.getMessage()));
                this.addFieldError("streets", "Unable to load Streets Information");
                throw new ApplicationRuntimeException("Unable to load Streets information", (Throwable)e);
            }
        }
        if (asset.getWard() != null) {
            this.setZoneId(asset.getWard().getParent().getId());
            List wardList = null;
            try {
                wardList = this.boundaryService.getActiveChildBoundariesByBoundaryId(Long.valueOf(String.valueOf(this.zoneId)));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while loading wards - wards." + e.getMessage()));
            }
            this.addDropdownData(WardList, wardList);
        }
    }

    public List<Boundary> getAllLocation() {
        HierarchyType hType = null;
        hType = this.hierarchyTypeService.getHierarchyTypeByName(LOCATION_HIERARCHY_TYPE);
        List locationList = null;
        BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(LOACTION_BOUNDARY_TYPE, hType);
        locationList = this.boundaryService.getActiveBoundariesByBoundaryTypeId(bType.getId());
        return locationList;
    }

    public List<Boundary> getAllWard() {
        HierarchyType hType = null;
        hType = this.hierarchyTypeService.getHierarchyTypeByName(ADMIN_HIERARCHY_TYPE);
        List wardList = null;
        BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(WARD_BOUNDARY_TYPE, hType);
        wardList = this.boundaryService.getAllBoundariesByBoundaryTypeId(bType.getId());
        return wardList;
    }

    public List<Boundary> getAllZone() {
        HierarchyType hType = this.hierarchyTypeService.getHierarchyTypeByName(ADMIN_HIERARCHY_TYPE);
        List<Object> zoneList = new ArrayList<Boundary>();
        BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(Zone_BOUNDARY_TYPE, hType);
        if (this.actionType == null) {
            this.actionType = "";
        }
        if (bType != null) {
            if (this.actionType.equalsIgnoreCase("createAsset")) {
                zoneList = this.boundaryService.getActiveBoundariesByBoundaryTypeId(bType.getId());
            } else if (this.actionType == "" || this.actionType.equalsIgnoreCase("viewAsset") || this.actionType.equalsIgnoreCase("modifyAsset")) {
                zoneList = "edit".equalsIgnoreCase(this.userMode) ? this.boundaryService.getActiveBoundariesByBoundaryTypeId(bType.getId()) : this.boundaryService.getAllBoundariesByBoundaryTypeId(bType.getId());
            }
        }
        return zoneList;
    }

    @Action(value="/assetmaster/asset-edit")
    public String edit() {
        this.userMode = "edit";
        return SEARCH;
    }

    @Action(value="/assetmaster/asset-view")
    public String view() {
        this.userMode = VIEW;
        return SEARCH;
    }

    @Action(value="/assetmaster/asset-list")
    public String list() throws Exception {
        this.setAssetType(this.assetType);
        if (this.departmentId == null && this.locationId == null && this.assetType == null && (this.code == null || this.code != null && this.code.trim().equalsIgnoreCase("")) && (this.description == null || this.description != null && this.description.trim().equalsIgnoreCase("")) && (this.statusId == null || this.statusId != null && this.statusId.isEmpty()) && this.zoneId == -1L) {
            this.messageKey = "message.mandatory";
            this.addActionError(this.getText(this.messageKey, "At least one selection is required"));
            return SEARCH;
        }
        this.setPageSize(30);
        this.search();
        return SEARCH;
    }

    private List<Asset> searchAssets() throws Exception {
        HashMap queryAndParam = this.getQueryAndParam();
        List params = (List)queryAndParam.get("param");
        Object[] parameterObj = new Object[params.size()];
        for (int element = 0; element < params.size(); ++element) {
            parameterObj[element] = params.get(element);
        }
        return this.assetService.findAllBy(queryAndParam.get("query").toString(), parameterObj);
    }

    private void setupRequestData() {
        this.setStatusList(this.getStatusList(this.assetStatus));
    }

    private List<EgwStatus> getStatusList(List<String> statusDescList) {
        List lStatusList = null;
        if (statusDescList != null && !statusDescList.isEmpty()) {
            StringBuffer sql = new StringBuffer(100);
            sql.append("from EgwStatus st where st.moduletype='ASSET'  and UPPER(st.description) in (");
            int len = statusDescList.size();
            for (int i = 0; i < len; ++i) {
                sql.append("'" + statusDescList.get(i).trim().toUpperCase() + "'");
                if (i >= len - 1) continue;
                sql.append(',');
            }
            sql.append(") order by description");
            String query = sql.toString();
            lStatusList = this.persistenceService.findAllBy(query, new Object[0]);
        }
        return lStatusList;
    }

    private void setStatusList(List<EgwStatus> statusList) {
        if (statusList == null) {
            statusList = new LinkedList<EgwStatus>();
        }
        this.addDropdownData(StatusList, statusList);
    }

    @Action(value="/assetmaster/asset-showSearchPage")
    public String showSearchPage() {
        this.setupRequestData();
        return SEARCH_PLUGIN;
    }

    @Action(value="/assetmaster/asset-showSearchResult")
    public String showSearchResult() throws Exception {
        if (!this.assetStatus.isEmpty() && this.assetStatus.get(0) != null) {
            List<String> statusDescList = Arrays.asList(((String)this.assetStatus.get(0)).substring(1, ((String)this.assetStatus.get(0)).length() - 1).split(", "));
            this.setStatusList(this.getStatusList(statusDescList));
        }
        if (this.statusId != null && !this.statusId.isEmpty()) {
            this.assetList = this.searchAssets();
        } else {
            this.addFieldError("status", "Please select at least one status");
        }
        return SEARCH_PLUGIN;
    }

    @Action(value="/assetmaster/asset-showPlugin")
    public String showPlugin() {
        return PLUGIN;
    }

    @Action(value="/assetmaster/asset-showCreatePage")
    public String showCreatePage() {
        this.setupRequestData();
        return CREATE_PLUGIN;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/assetmaster/asset-create")
    public String create() {
        try {
            this.setDimensions();
            this.setStatusList(this.getStatusList(this.assetStatus));
            this.assetService.setAssetNumber(this.asset);
            this.assetService.persist((Object)this.asset);
            this.addActionMessage("'" + this.asset.getCode() + "' " + this.getText(Asset_SAVE_SUCCESS));
            this.id = this.asset.getId();
            this.fDisabled = true;
            this.sDisabled = true;
            this.setLocationDetails(this.asset);
            return CREATE_PLUGIN;
        }
        catch (ValidationException e) {
            this.clearMessages();
            this.prepare();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
    }

    private void setDimensions() {
        if (this.lengthValue != null) {
            this.asset.setLength(this.lengthValue);
        }
        if (this.widthValue != null) {
            this.asset.setWidth(this.widthValue);
        }
        if (this.areaValue != null) {
            this.asset.setTotalArea(this.areaValue);
        }
    }

    @Action(value="/assetmaster/asset-save")
    public String save() {
        try {
            this.setDimensions();
            if (this.asset.getDateOfCreation() != null) {
                this.assetService.setAssetNumber(this.asset);
            }
            this.assetService.persist((Object)this.asset);
            if ("new".equals(this.userMode) && this.asset.getStatus().getDescription().equalsIgnoreCase("Capitalized")) {
                AssetActivities activities = new AssetActivities();
                activities.setAsset(this.asset);
                activities.setActivityDate(this.asset.getDateOfCreation());
                activities.setIdentifier(AssetIdentifier.C);
                activities.setAdditionAmount(this.asset.getGrossValue());
                this.assetActivitiesService.persist((Object)activities);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getErrors());
        }
        this.addActionMessage("'" + this.asset.getCode() + "' " + this.getText(Asset_SAVE_SUCCESS));
        this.userMode = "edit";
        this.id = this.asset.getId();
        this.setLocationDetails(this.asset);
        return this.showform();
    }

    public String execute() {
        return this.view();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Object getModel() {
        return this.asset;
    }

    public void setModel(Asset asset) {
        this.asset = asset;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public void setAppService(AppService appService) {
        this.appService = appService;
    }

    public String getUserMode() {
        return this.userMode;
    }

    public void setUserMode(String userMode) {
        this.userMode = userMode;
    }

    public boolean isFDisabled() {
        return this.fDisabled;
    }

    public boolean isSDisabled() {
        return this.sDisabled;
    }

    public List<Asset> getAssetList() {
        return this.assetList;
    }

    public void setAssetList(List<Asset> assetList) {
        this.assetList = assetList;
    }

    public String getDataDisplayStyle() {
        return this.dataDisplayStyle;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long wardId) {
        this.locationId = wardId;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public List<Integer> getStatusId() {
        return this.statusId;
    }

    public void setStatusId(List<Integer> statusId) {
        this.statusId = statusId;
    }

    public void setAssetStatus(List<String> assetStatus) {
        this.assetStatus = assetStatus;
    }

    public Integer getRowId() {
        return this.rowId;
    }

    public void setRowId(Integer rowId) {
        this.rowId = rowId;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public List<Long> getAssetChildCategoryList() {
        return this.assetChildCategoryList;
    }

    public String getSelectType() {
        return this.selectType;
    }

    public void setSelectType(String selectType) {
        this.selectType = selectType;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getIsAutoGeneratedCode() {
        return this.isAutoGeneratedCode;
    }

    public void setIsAutoGeneratedCode(String isAutoGeneratedCode) {
        this.isAutoGeneratedCode = isAutoGeneratedCode;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        HashMap queryAndParam = this.getQueryAndParam();
        return new SearchQueryHQL(queryAndParam.get("query").toString(), "select count(*) " + queryAndParam.get("query"), (List)queryAndParam.get("param"));
    }

    private HashMap<String, Object> getQueryAndParam() {
        StringBuilder sql = new StringBuilder(265);
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.userMode != null && VIEW.equalsIgnoreCase(this.userMode)) {
            sql.append("from Asset asset where asset.code is not null ");
        } else {
            sql.append("from Asset asset where asset.code is not null and asset.status.code<>'CANCELLED' ");
        }
        if (this.assetType != null && !this.assetType.equalsIgnoreCase("-1")) {
            sql.append(" and asset.assetCategory.assetType = ?");
            parameters.add(AssetType.valueOf((String)this.assetType));
        }
        if (this.departmentId != null && this.departmentId != -1L) {
            sql.append(" and asset.department.id = ?");
            parameters.add(this.departmentId);
        }
        if (this.zoneId != null && this.zoneId != -1L) {
            sql.append(" and asset.ward.parent.id = ?");
            parameters.add(this.zoneId);
        }
        if (this.wardId != null && this.wardId != -1L) {
            sql.append(" and asset.ward.id = ?");
            parameters.add(this.wardId);
        }
        if (this.streetId != null && this.streetId != -1L) {
            sql.append(" and asset.street.id = ?");
            parameters.add(this.streetId);
        }
        if (this.areaId != null && this.areaId != -1L) {
            sql.append(" and asset.area.id = ?");
            parameters.add(this.areaId);
        }
        if (this.locationId != null && this.locationId != -1L) {
            sql.append(" and asset.location.id = ?");
            parameters.add(this.locationId);
        }
        if (this.street2Id != null && this.street2Id != -1L) {
            sql.append(" and asset.street.id = ?");
            parameters.add(this.street2Id);
        }
        if (this.code != null && !this.code.trim().equalsIgnoreCase("")) {
            sql.append(" and UPPER(asset.code) like ?");
            parameters.add("%" + this.code.toUpperCase() + "%");
        }
        if (this.description != null && !this.description.trim().equalsIgnoreCase("")) {
            sql.append(" and UPPER(asset.description) like ?");
            parameters.add("%" + this.description.toUpperCase() + "%");
        }
        if (this.statusId != null && !this.statusId.isEmpty()) {
            String statusList = "";
            for (Integer status : this.statusId) {
                statusList = statusList + status + ",";
            }
            sql.append(" and asset.status.id in (" + statusList.substring(0, statusList.length() - 1) + ")");
        }
        if (this.parentId != null && this.parentId != -1L && !this.parentId.equals("")) {
            sql.append(" and asset.assetCategory.id = ? ");
            parameters.add(this.parentId);
        }
        if (this.parentCategoryId != null && this.parentCategoryId != -1L && (this.subCategoryIds == null || this.subCategoryIds.size() == 1 && (Long)this.subCategoryIds.get(0) == -1L)) {
            sql.append(" and (asset.assetCategory.id = ? or asset.assetCategory.parent.id = ?) ");
            parameters.add(this.parentCategoryId);
            parameters.add(this.parentCategoryId);
        } else if (this.parentCategoryId != null && this.parentCategoryId != -1L && this.subCategoryIds != null && !this.subCategoryIds.isEmpty()) {
            String subCatList = "";
            for (Long subCat : this.subCategoryIds) {
                subCatList = subCatList + subCat + ",";
            }
            sql.append(" and asset.assetCategory.id in (" + subCatList.substring(0, subCatList.length() - 1) + ")");
        }
        HashMap<String, Object> queryAndParam = new HashMap<String, Object>();
        queryAndParam.put("query", sql);
        queryAndParam.put("param", parameters);
        return queryAndParam;
    }

    public Long getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public Long getStreetId() {
        return this.streetId;
    }

    public void setStreetId(Long streetId) {
        this.streetId = streetId;
    }

    public Long getStreet2Id() {
        return this.street2Id;
    }

    public void setStreet2Id(Long street2Id) {
        this.street2Id = street2Id;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String getSearchBy() {
        return this.searchBy;
    }

    public void setSearchBy(String searchBy) {
        this.searchBy = searchBy;
    }

    public void setAssetActivitiesService(AssetActivitiesService assetActivitiesService) {
        this.assetActivitiesService = assetActivitiesService;
    }

    public BigDecimal getLengthValue() {
        return this.lengthValue;
    }

    public BigDecimal getWidthValue() {
        return this.widthValue;
    }

    public BigDecimal getAreaValue() {
        return this.areaValue;
    }

    public void setLengthValue(BigDecimal lengthValue) {
        this.lengthValue = lengthValue;
    }

    public void setWidthValue(BigDecimal widthValue) {
        this.widthValue = widthValue;
    }

    public void setAreaValue(BigDecimal areaValue) {
        this.areaValue = areaValue;
    }

    public Long getParentCategoryId() {
        return this.parentCategoryId;
    }

    public void setParentCategoryId(Long parentCategoryId) {
        this.parentCategoryId = parentCategoryId;
    }

    public List<Long> getSubCategoryIds() {
        return this.subCategoryIds;
    }

    public void setSubCategoryIds(List<Long> subCategoryIds) {
        this.subCategoryIds = subCategoryIds;
    }

    public Boolean getFromDiaryModule() {
        return this.fromDiaryModule;
    }

    public void setFromDiaryModule(Boolean fromDiaryModule) {
        this.fromDiaryModule = fromDiaryModule;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setAssetCategoryService(AssetCategoryService assetCategoryService) {
        this.assetCategoryService = assetCategoryService;
    }

    public List<String> getAssetStatus() {
        return this.assetStatus;
    }
}

