/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.web.actions.assetcategory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.model.AssetType;
import org.egov.asset.model.DepreciationMetaData;
import org.egov.asset.model.DepreciationMethod;
import org.egov.asset.service.AppService;
import org.egov.asset.service.AssetCategoryService;
import org.egov.common.entity.UOM;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="new", location="assetCategory-new.jsp"), @Result(name="search", location="assetCategory-search.jsp"), @Result(name="edit", location="assetCategory-edit.jsp")})
public class AssetCategoryAction
extends BaseFormAction {
    private static final long serialVersionUID = -1510474404320433556L;
    public static final String SEARCH = "search";
    public static final String VIEW = "view";
    private static final Logger LOGGER = Logger.getLogger(AssetCategoryAction.class);
    private AssetCategoryService assetCategoryService;
    private AppService appService;
    private AssetCategory assetCategory = new AssetCategory();
    private List<AssetCategory> assetCategoryList = null;
    private List<DepreciationMetaData> depMetaDatas = new LinkedList();
    private Long id;
    private String assetType;
    private Long parentId;
    private static final String assetAccCodePURPOSEID = "ASSET_ACCOUNT_CODE_PURPOSEID";
    private static final String revResAccPURPOSEID = "REVALUATION_RESERVE_ACCOUNT_PURPOSEID";
    private static final String depExpAccPURPOSEID = "DEPRECIATION_EXPENSE_ACCOUNT_PURPOSEID";
    private static final String accDepPURPOSEID = "ACCUMULATED_DEPRECIATION_PURPOSEID";
    private String userMode;
    private boolean fDisabled;
    private boolean sDisabled;
    private String dataDisplayStyle;
    private String isAutoGeneratedCode;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public AssetCategoryAction() {
        this.addRelatedEntity("assetAccountCode", CChartOfAccounts.class);
        this.addRelatedEntity("accDepAccountCode", CChartOfAccounts.class);
        this.addRelatedEntity("revAccountCode", CChartOfAccounts.class);
        this.addRelatedEntity("depExpAccountCode", CChartOfAccounts.class);
        this.addRelatedEntity("financialYear", CFinancialYear.class);
        this.addRelatedEntity("department", Department.class);
        this.addRelatedEntity("uom", UOM.class);
    }

    public void prepare() {
        String module_asset = "Asset Management";
        this.isAutoGeneratedCode = this.appService.getUniqueAppConfigValue("IS_ASSET_CATEGORYCODE_AUTOGENERATED");
        if (this.id != null && this.id != -1L) {
            this.assetCategory = (AssetCategory)this.assetCategoryService.findById((Serializable)this.id, false);
        }
        super.prepare();
        String purposeId = "";
        this.setupDropdownDataExcluding(new String[]{"assetAccountCode", "accDepAccountCode", "revAccountCode", "depExpAccountCode"});
        this.addDropdownData("assetTypeList", Arrays.asList(AssetType.values()));
        this.addDropdownData("depreciationMethodList", Arrays.asList(DepreciationMethod.values()));
        purposeId = this.appService.getUniqueAppConfigValue("Asset Management", assetAccCodePURPOSEID);
        List assetAccounts = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(purposeId));
        this.addDropdownData("assetAccountCodeList", assetAccounts);
        purposeId = this.appService.getUniqueAppConfigValue("Asset Management", accDepPURPOSEID);
        List accumulatedDeps = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(purposeId));
        this.addDropdownData("accDepAccountCodeList", accumulatedDeps);
        purposeId = this.appService.getUniqueAppConfigValue("Asset Management", revResAccPURPOSEID);
        List revAccounts = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(purposeId));
        this.addDropdownData("revAccountCodeList", revAccounts);
        purposeId = this.appService.getUniqueAppConfigValue("Asset Management", depExpAccPURPOSEID);
        List depExpenseAccounts = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(purposeId));
        this.addDropdownData("depExpAccountCodeList", depExpenseAccounts);
    }

    @Action(value="/assetcategory/assetCategory-newform")
    public String newform() {
        this.userMode = "new";
        return this.showform();
    }

    @Action(value="/assetcategory/assetCategory-showform")
    public String showform() {
        String result = null;
        if (this.userMode == null) {
            this.userMode = "new";
        }
        if ("new".equals(this.userMode)) {
            this.fDisabled = false;
            this.sDisabled = false;
            result = "new";
        } else if (VIEW.equals(this.userMode)) {
            if (this.id == null) {
                this.addActionError(this.getText("asset.category.id.null"));
                result = SEARCH;
            } else {
                this.fDisabled = true;
                this.sDisabled = true;
                result = "new";
            }
        } else if ("edit".equals(this.userMode)) {
            if (this.id == null) {
                this.addActionError(this.getText("asset.category.id.null"));
                result = SEARCH;
            } else {
                this.fDisabled = false;
                this.sDisabled = true;
                result = "new";
            }
        }
        return result;
    }

    @Action(value="/assetcategory/assetCategory-edit")
    public String edit() {
        this.userMode = "edit";
        this.dataDisplayStyle = "none";
        return SEARCH;
    }

    @Action(value="/assetcategory/assetCategory-view")
    public String view() {
        this.userMode = VIEW;
        this.dataDisplayStyle = "none";
        return SEARCH;
    }

    @Action(value="/assetcategory/assetCategory-list")
    public String list() {
        if (this.assetType.equalsIgnoreCase("") && (this.id == null || this.id == -1L)) {
            this.assetCategoryList = this.assetCategoryService.findAll(new String[]{"name"});
        } else if (!(this.assetType.equalsIgnoreCase("") || this.id != null && this.id != -1L)) {
            this.assetCategoryList = this.assetCategoryService.getAllAssetCategoryByAssetType(this.assetType);
        } else if (this.id != null && this.id != -1L) {
            this.assetCategoryList = new ArrayList();
            this.assetCategoryList.add(this.assetCategoryService.findById((Serializable)this.id, false));
        }
        this.dataDisplayStyle = this.assetCategoryList == null || this.assetCategoryList.isEmpty() ? "noRecords" : "display";
        return SEARCH;
    }

    public String execute() {
        return this.list();
    }

    @ValidationErrorPage(value="edit")
    @Action(value="/assetcategory/assetCategory-save")
    public String save() throws NumberFormatException, ApplicationException {
        this.addDepMetaDatas();
        if (this.parentId != null && this.parentId != -1L) {
            this.assetCategory.setParent((AssetCategory)this.assetCategoryService.findById((Serializable)this.parentId, false));
        }
        this.assetCategoryService.setAssetCategoryNumber(this.assetCategory);
        try {
            this.assetCategory = (AssetCategory)this.assetCategoryService.persist((Object)this.assetCategory);
        }
        catch (ValidationException valEx) {
            LOGGER.error((Object)("Exception found while persisting asset category: " + valEx.getErrors()));
            throw new ValidationException(valEx.getErrors());
        }
        this.addActionMessage("'" + this.assetCategory.getCode() + "' " + this.getText("asset.category.save.success"));
        this.userMode = "edit";
        this.id = this.assetCategory.getId();
        return this.showform();
    }

    protected void addDepMetaDatas() {
        this.assetCategory.getDepreciationMetaDataList().clear();
        for (DepreciationMetaData lDepreciationMetaData : this.depMetaDatas) {
            if (!this.validDepMetaData(lDepreciationMetaData)) continue;
            lDepreciationMetaData.setFinancialYear(this.financialYearDAO.getFinancialYearById(lDepreciationMetaData.getFinancialYear().getId()));
            lDepreciationMetaData.setAssetCategory(this.assetCategory);
            this.assetCategory.addDepreciationMetaData(lDepreciationMetaData);
        }
    }

    protected boolean validDepMetaData(DepreciationMetaData tDepreciationMetaData) {
        return tDepreciationMetaData != null && tDepreciationMetaData.getFinancialYear() != null && tDepreciationMetaData.getFinancialYear().getId() != null && tDepreciationMetaData.getDepreciationRate() != null && tDepreciationMetaData.getDepreciationRate().floatValue() >= 0.0f;
    }

    public Map<Long, String> getParentMap() {
        HashMap<Long, String> parentMap = new HashMap<Long, String>();
        String query = "select id,name from EGASSET_ASSET_CATEGORY ";
        if (this.assetType != null && !this.assetType.equalsIgnoreCase("-1")) {
            query = query + "where ASSET_TYPE = '" + this.assetType + "'";
        }
        try {
            List categoryList = this.persistenceService.getSession().createSQLQuery(query).list();
            if (categoryList != null && !categoryList.isEmpty()) {
                for (Object[] assetCategoryObject : categoryList) {
                    parentMap.put(Long.valueOf(assetCategoryObject[0].toString()), assetCategoryObject[1].toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getParentMap() method:" + e.getMessage()));
        }
        return parentMap;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Object getModel() {
        return this.assetCategory;
    }

    public void setModel(AssetCategory assetCategory) {
        this.assetCategory = assetCategory;
    }

    public void setAssetCategoryService(AssetCategoryService assetCategoryService) {
        this.assetCategoryService = assetCategoryService;
    }

    public List<AssetCategory> getAssetCategoryList() {
        return this.assetCategoryList;
    }

    public void setAssetCategoryList(List<AssetCategory> assetCategoryList) {
        this.assetCategoryList = assetCategoryList;
    }

    public String getUserMode() {
        return this.userMode;
    }

    public void setUserMode(String userMode) {
        this.userMode = userMode;
    }

    public boolean isFDisabled() {
        return this.fDisabled;
    }

    public boolean isSDisabled() {
        return this.sDisabled;
    }

    public String getDataDisplayStyle() {
        return this.dataDisplayStyle;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public List<DepreciationMetaData> getDepMetaDatas() {
        return this.depMetaDatas;
    }

    public void setDepMetaDatas(List<DepreciationMetaData> depMetaDatas) {
        this.depMetaDatas = depMetaDatas;
    }

    public void setAppService(AppService appService) {
        this.appService = appService;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getIsAutoGeneratedCode() {
        return this.isAutoGeneratedCode;
    }

    public void setIsAutoGeneratedCode(String isAutoGeneratedCode) {
        this.isAutoGeneratedCode = isAutoGeneratedCode;
    }
}

