/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.web.actions.assetcategory;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.service.AssetCategoryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;

@ParentPackage(value="egov")
@Results(value={@Result(name="parentcategories", location="ajaxAssetCategory-parentcategories.jsp"), @Result(name="assetcatdetails", location="ajaxAssetCategory-assetcatdetails.jsp")})
public class AjaxAssetCategoryAction
extends BaseFormAction {
    private static final long serialVersionUID = -8703869606104325609L;
    private static final Logger LOGGER = Logger.getLogger(AjaxAssetCategoryAction.class);
    public static final String PARENT_CATEGORIES = "parentcategories";
    public static final String ASSET_CAT_DETAILS = "assetcatdetails";
    private String assetType;
    private Long parentCatId;
    private AssetCategory parentCategory;
    private List<AssetCategory> assetCategoryList;
    private AssetCategoryService assetCategoryService;

    public Object getModel() {
        return null;
    }

    public String execute() {
        return "success";
    }

    @Action(value="/assetcategory/ajaxAssetCategory-populateParentCategories")
    public String populateParentCategories() {
        try {
            this.assetCategoryList = this.assetType.equalsIgnoreCase("") || this.assetType.equalsIgnoreCase("-1") ? this.assetCategoryService.findAll() : this.assetCategoryService.getAllAssetCategoryByAssetType(this.assetType);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading assetCategoryList in populateParentCategories() method " + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return PARENT_CATEGORIES;
    }

    @Action(value="/assetcategory/ajaxAssetCategory-populateParentDetails")
    public String populateParentDetails() {
        this.parentCategory = (AssetCategory)this.assetCategoryService.findById((Serializable)this.parentCatId, false);
        return ASSET_CAT_DETAILS;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public void setParentCatId(Long parentCatId) {
        this.parentCatId = parentCatId;
    }

    public List<AssetCategory> getAssetCategoryList() {
        return this.assetCategoryList;
    }

    public AssetCategory getParentCategory() {
        return this.parentCategory;
    }

    public void setAssetCategoryService(AssetCategoryService assetCategoryService) {
        this.assetCategoryService = assetCategoryService;
    }
}

