/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.egov.assets.autonumber.AssetCodeGenerator;
import org.egov.assets.model.Asset;
import org.egov.assets.service.AssetCategoryService;
import org.egov.assets.service.AssetService;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egassets.web.adaptor.AssetJsonAdaptor;
import org.egov.eis.service.PersonalInformationService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/asset"})
public class AssetController {
    private static final String ASSET_NEW = "asset-new";
    private static final String ASSET_RESULT = "asset-result";
    private static final String ASSET_EDIT = "asset-edit";
    private static final String ASSET_VIEW = "asset-view";
    private static final String ASSET_SEARCH = "asset-search";
    private static final String LOCALITY = "Locality";
    private static final String LOCATION_HIERARCHY_TYPE = "LOCATION";
    private static final String ZONE = "Zone";
    private static final String BLOCK = "Block";
    private static final String REVENUE_HEIRARCHY_TYPE = "REVENUE";
    private static final String ELECTION_BOUNDARY_TYPE = "Ward";
    private static final String ELECTION_HIERARCHY_TYPE = "ADMINISTRATION";
    @Autowired
    private AssetService assetService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AssetCategoryService assetCategoryService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private EgwStatusHibernateDAO egwStatusService;
    @Autowired
    private PersonalInformationService personalInformationService;

    private void prepareNewForm(Model model) {
        model.addAttribute("assetCategorys", (Object)this.assetCategoryService.findAll());
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("locations", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(LOCALITY, LOCATION_HIERARCHY_TYPE));
        model.addAttribute("zones", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(ZONE, REVENUE_HEIRARCHY_TYPE));
        model.addAttribute("electionWards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(ELECTION_BOUNDARY_TYPE, ELECTION_HIERARCHY_TYPE));
        model.addAttribute("modeOfAcquisitions", (Object)Asset.ModeOfAcquisition.values());
        model.addAttribute("egwStatus", (Object)this.egwStatusService.getStatusByModule("ASSET"));
        AppConfigValues assetCodeCreation = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "Asset_category_code_creation_mode").get(0);
        model.addAttribute("codeGenerationMode", (Object)assetCodeCreation.getValue());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("asset", (Object)new Asset());
        return ASSET_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Asset asset, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        AppConfigValues assetCodeCreation = (AppConfigValues)this.appConfigValueService.getConfigValuesByModuleAndKey("Asset Management", "Asset_category_code_creation_mode").get(0);
        if (!assetCodeCreation.getValue().equalsIgnoreCase("Auto") && (asset.getCode() == null || asset.getCode().isEmpty())) {
            errors.addError(new ObjectError("assetCode", this.messageSource.getMessage("comment.not.null", null, null)));
        }
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ASSET_NEW;
        }
        if (assetCodeCreation.getValue().equals("Auto")) {
            AssetCodeGenerator assetCodeGenerator = (AssetCodeGenerator)this.beanResolver.getAutoNumberServiceFor(AssetCodeGenerator.class);
            String assetNumber = assetCodeGenerator.getNextNumber(asset);
            asset.setCode(assetNumber);
        }
        asset.setStatus(this.egwStatusService.findById(asset.getStatus().getId(), false));
        this.assetService.create(asset);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.asset.success", null, null));
        return "redirect:/asset/result/" + asset.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        Asset asset = this.assetService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("asset", (Object)asset);
        model.addAttribute("blockId", asset.getLocationDetails().getBlock() != null ? asset.getLocationDetails().getBlock().getId() : "");
        model.addAttribute("wardId", asset.getLocationDetails().getRevenueWard() != null ? asset.getLocationDetails().getRevenueWard().getId() : "");
        model.addAttribute("streetId", asset.getLocationDetails().getStreet() != null ? asset.getLocationDetails().getStreet().getId() : "");
        return ASSET_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Asset asset, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return ASSET_EDIT;
        }
        this.assetService.update(asset);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.asset.success", null, null));
        return "redirect:/asset/result/" + asset.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        Asset asset = this.assetService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("asset", (Object)asset);
        return ASSET_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        Asset asset = this.assetService.findOne(id);
        model.addAttribute("asset", (Object)asset);
        return ASSET_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Asset asset = new Asset();
        this.prepareNewForm(model);
        model.addAttribute("asset", (Object)asset);
        return ASSET_SEARCH;
    }

    @RequestMapping(value={"/resultsearch/{mode}"}, method={RequestMethod.GET})
    public String searchAsset(@PathVariable(value="mode") String mode, @RequestParam(value="rowId") int rowId, @RequestParam(value="assetStatus") String[] assetStatus, Model model) {
        Asset asset = new Asset();
        this.prepareNewForm(model);
        model.addAttribute("rowId", (Object)rowId);
        model.addAttribute("asset", (Object)asset);
        return ASSET_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Asset asset) {
        List searchResultList = this.assetService.search(asset);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/getBoundariesByLocation/{locationId}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getBoundariesByLocation(@PathVariable(value="locationId") Long locationId, Model model, @ModelAttribute Asset asset) {
        JSONObject boundaryResultList = this.fetchBoundariesByLocation(locationId);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)boundaryResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Asset.class, (Object)new AssetJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private JSONObject fetchBoundariesByLocation(Long locationId) {
        BoundaryType blockType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(BLOCK, REVENUE_HEIRARCHY_TYPE);
        List blocks = this.crossHierarchyService.getParentBoundaryByChildBoundaryAndParentBoundaryType(locationId, blockType.getId());
        List streets = this.boundaryService.getChildBoundariesByBoundaryId(locationId);
        ArrayList<JSONObject> wardJsonObjects = new ArrayList<JSONObject>();
        ArrayList<JSONObject> blockJsonObjects = new ArrayList<JSONObject>();
        ArrayList<Long> boundaries = new ArrayList<Long>();
        for (Object block : blocks) {
            Boundary ward = block.getParent();
            JSONObject jsonObject = new JSONObject();
            JSONObject wardJsonObject = new JSONObject();
            if (!boundaries.contains(ward.getId())) {
                wardJsonObject.put((Object)"wardId", (Object)ward.getId());
                wardJsonObject.put((Object)"wardName", (Object)ward.getName());
                wardJsonObjects.add(wardJsonObject);
            }
            jsonObject.put((Object)"blockId", (Object)block.getId());
            jsonObject.put((Object)"blockName", (Object)block.getName());
            jsonObject.put((Object)"wards", wardJsonObjects);
            blockJsonObjects.add(jsonObject);
            boundaries.add(ward.getId());
        }
        ArrayList<JSONObject> streetJsonObjects = new ArrayList<JSONObject>();
        for (Boundary street : streets) {
            JSONObject streetObject = new JSONObject();
            streetObject.put((Object)"streetId", (Object)street.getId());
            streetObject.put((Object)"streetName", (Object)street.getName());
            streetJsonObjects.add(streetObject);
        }
        HashMap<String, ArrayList<JSONObject>> map = new HashMap<String, ArrayList<JSONObject>>();
        map.put("blocks", blockJsonObjects);
        map.put("streets", streetJsonObjects);
        JSONObject boundaryJson = new JSONObject();
        boundaryJson.put((Object)"results", map);
        return boundaryJson;
    }
}

