/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.web.actions.assetmaster;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.service.AssetCategoryService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="locations", location="ajaxAsset-locations.jsp"), @Result(name="wards", location="ajaxAsset-wards.jsp"), @Result(name="areas", location="ajaxAsset-areas.jsp"), @Result(name="streets", location="ajaxAsset-streets.jsp"), @Result(name="streets2", location="ajaxAsset-streets2.jsp"), @Result(name="assetcatdetails", location="ajaxAsset-assetcatdetails.jsp"), @Result(name="parentcategories", location="ajaxAsset-parentcategories.jsp"), @Result(name="Area", location="ajaxAsset-Area.jsp"), @Result(name="subcategories", location="ajaxAsset-subcategories.jsp")})
public class AjaxAssetAction
extends BaseFormAction {
    private static final long serialVersionUID = 2501333661006168742L;
    private static final Logger LOGGER = Logger.getLogger(AjaxAssetAction.class);
    private String assetType;
    private Long areaId;
    private Long locationId;
    private Long categoryId;
    private Long zoneId;
    private Long wardId;
    private List<Boundary> locationList = new LinkedList();
    private List<Boundary> zoneList = new LinkedList();
    private List<Boundary> streetList = new LinkedList();
    private List<Boundary> street2List = new LinkedList();
    private List<Boundary> areaList = new LinkedList();
    private AssetCategory assetCategory;
    private List<AssetCategory> assetCategoryList;
    public static final String LOCATIONS = "locations";
    public static final String WARDS = "wards";
    public static final String AREAS = "areas";
    public static final String STREETS = "streets";
    public static final String STREETS2 = "streets2";
    public static final String ASSET_CAT_DETAILS = "assetcatdetails";
    public static final String PARENT_CATEGORIES = "parentcategories";
    private String hierarchyTypeName = "LOCATION";
    public static final String AREA_BOUNDARY_TYPE = "Area";
    private String value;
    private Integer departmentId;
    private static SimpleDateFormat FORMATTER = new SimpleDateFormat("dd-MMM-yyyy");
    private Long parentCatId;
    private List<AssetCategory> assetSubCategoryList;
    public static final String SUB_CATEGORIES = "subcategories";
    private AssetCategoryService assetCategoryService;
    @Autowired
    private HierarchyTypeService heirarchyTypeService;
    @Autowired
    private CrossHierarchyService crossHeirarchyService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    public Object getModel() {
        return null;
    }

    public String execute() {
        return "success";
    }

    @Action(value="/assetmaster/ajaxAsset-populateArea")
    public String populateArea() {
        Boundary boundary = this.boundaryService.getBoundaryById(this.wardId);
        if (this.wardId != -1L) {
            this.areaList.add(this.boundaryService.getBoundaryById(boundary.getParent().getId()));
        } else {
            this.areaList = Collections.EMPTY_LIST;
        }
        LOGGER.info((Object)("***********Ajax AreaList: " + this.areaList.toString()));
        return AREAS;
    }

    @Action(value="/assetmaster/ajaxAsset-populateAreaByLocation")
    public String populateAreaByLocation() {
        HierarchyType hType = null;
        try {
            hType = this.heirarchyTypeService.getHierarchyTypeByName(this.hierarchyTypeName);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading areas - areas." + e.getMessage()));
            this.addFieldError(AREAS, "Unable to load areas information");
            throw new ApplicationRuntimeException("Unable to load areas information", (Throwable)e);
        }
        BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(AREA_BOUNDARY_TYPE, hType);
        if (bType != null) {
            this.areaList = this.boundaryService.getAllBoundariesByBoundaryTypeId(bType.getId());
        }
        return AREAS;
    }

    @Action(value="/assetmaster/ajaxAsset-populateLocations")
    public String populateLocations() {
        try {
            if (this.areaId != -1L) {
                Boundary boundary = this.boundaryService.getBoundaryById(this.areaId);
                this.locationList.add(this.boundaryService.getBoundaryById(boundary.getParent().getId()));
            } else {
                this.locationList = Collections.EMPTY_LIST;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading locations - locations." + e.getMessage()));
            this.addFieldError("location", "Unable to load location information");
            throw new ApplicationRuntimeException("Unable to load location information", (Throwable)e);
        }
        LOGGER.info((Object)("***********Ajax locationList: " + this.locationList.toString()));
        return LOCATIONS;
    }

    @Action(value="/assetmaster/ajaxAsset-populateWard")
    public String populateWard() {
        try {
            this.zoneList = this.boundaryService.getChildBoundariesByBoundaryId(this.zoneId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading warda - wards." + e.getMessage()));
            this.addFieldError("location", "Unable to load ward information");
            throw new ApplicationRuntimeException("Unable to load ward information", (Throwable)e);
        }
        LOGGER.info((Object)("***********Ajax ward: " + this.locationList.toString()));
        return WARDS;
    }

    @Action(value="/assetmaster/ajaxAsset-populateStreets")
    public String populateStreets() throws Exception {
        HierarchyType hType = null;
        try {
            hType = this.heirarchyTypeService.getHierarchyTypeByName(this.hierarchyTypeName);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading Streets." + e.getMessage()));
            this.addFieldError(STREETS, "Unable to load Streets Information");
            throw new ApplicationRuntimeException("Unable to load Streets information", (Throwable)e);
        }
        BoundaryType childBoundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType("Street", hType);
        if (this.wardId != null && this.wardId != -1L) {
            Boundary parentBoundary = this.boundaryService.getBoundaryById(this.wardId);
            this.streetList = this.crossHeirarchyService.getCrossHierarchyChildrens(parentBoundary, childBoundaryType);
        } else {
            this.streetList = Collections.EMPTY_LIST;
        }
        return STREETS;
    }

    @Action(value="/assetmaster/ajaxAsset-populateStreetsByLocation")
    public String populateStreetsByLocation() throws Exception {
        if (this.locationId != -1L) {
            this.street2List = this.boundaryService.getChildBoundariesByBoundaryId(this.locationId);
        }
        return STREETS2;
    }

    @Action(value="/assetmaster/ajaxAsset-populateCategoryDetails")
    public String populateCategoryDetails() {
        this.assetCategory = (AssetCategory)this.assetCategoryService.findById((Serializable)this.categoryId, false);
        return ASSET_CAT_DETAILS;
    }

    @Action(value="/assetmaster/ajaxAsset-populateParentCategories")
    public String populateParentCategories() {
        this.assetCategoryList = this.assetType == null || this.assetType.equalsIgnoreCase("") || this.assetType.equalsIgnoreCase("-1") ? this.assetCategoryService.findAll() : this.assetCategoryService.getAllAssetCategoryByAssetType(this.assetType);
        return PARENT_CATEGORIES;
    }

    @Action(value="/assetmaster/ajaxAsset-populateParentAssetCategoryList")
    public String populateParentAssetCategoryList() {
        this.assetCategoryList = this.assetType == null || this.assetType.equalsIgnoreCase("-1") ? this.assetCategoryService.getAllParentAssetCategory() : this.assetCategoryService.getAllParentAssetCategoryByAssetType(this.assetType);
        return PARENT_CATEGORIES;
    }

    @Action(value="/assetmaster/ajaxAsset-populateSubCategories")
    public String populateSubCategories() {
        this.assetSubCategoryList = this.parentCatId != -1L && this.parentCatId != null ? this.assetCategoryService.getAllAssetCategoryByParent(this.parentCatId) : Collections.emptyList();
        return SUB_CATEGORIES;
    }

    @Action(value="/assetmaster/ajaxAsset-populateLocationsByArea")
    public String populateLocationsByArea() {
        try {
            this.locationList = this.areaId != -1L ? this.boundaryService.getChildBoundariesByBoundaryId(this.areaId) : Collections.EMPTY_LIST;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading locations - locations." + e.getMessage()));
            this.addFieldError("location", "Unable to load location information");
            throw new ApplicationRuntimeException("Unable to load location information", (Throwable)e);
        }
        LOGGER.info((Object)("***********Ajax locationList: " + this.locationList.toString()));
        return LOCATIONS;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public List<Boundary> getLocationList() {
        return this.locationList;
    }

    public List<Boundary> getStreetList() {
        return this.streetList;
    }

    public List<Boundary> getStreet2List() {
        return this.street2List;
    }

    public AssetCategory getAssetCategory() {
        return this.assetCategory;
    }

    public List<AssetCategory> getAssetCategoryList() {
        return this.assetCategoryList;
    }

    public List<Boundary> getZoneList() {
        return this.zoneList;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public void setHierarchyTypeName(String hierarchyTypeName) {
        this.hierarchyTypeName = hierarchyTypeName;
    }

    public List<Boundary> getAreaList() {
        return this.areaList;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public List<AssetCategory> getAssetSubCategoryList() {
        return this.assetSubCategoryList;
    }

    public void setAssetSubCategoryList(List<AssetCategory> assetSubCategoryList) {
        this.assetSubCategoryList = assetSubCategoryList;
    }

    public Long getParentCatId() {
        return this.parentCatId;
    }

    public void setParentCatId(Long parentCatId) {
        this.parentCatId = parentCatId;
    }

    public void setBoundaryService(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    public void setBoundaryTypeService(BoundaryTypeService boundaryTypeService) {
        this.boundaryTypeService = boundaryTypeService;
    }

    public void setAssetCategoryService(AssetCategoryService assetCategoryService) {
        this.assetCategoryService = assetCategoryService;
    }

    public void setHeirarchyTypeService(HierarchyTypeService heirarchyTypeService) {
        this.heirarchyTypeService = heirarchyTypeService;
    }

    public void setCrossHeirarchyService(CrossHierarchyService crossHeirarchyService) {
        this.crossHeirarchyService = crossHeirarchyService;
    }
}

