/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.assets.model.Asset;
import org.egov.assets.repository.AssetRepository;
import org.egov.assets.util.AssetCommonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AssetService {
    private final AssetRepository assetRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AssetCommonUtil assetCommonUtil;

    @Autowired
    public AssetService(AssetRepository assetRepository) {
        this.assetRepository = assetRepository;
    }

    @Transactional
    public Asset create(Asset asset) {
        if (asset.getCategoryProperties() != null) {
            String serialize = this.assetCommonUtil.serialize(asset.getCategoryProperties());
            asset.setProperties(serialize);
        }
        return (Asset)((Object)this.assetRepository.save((Object)asset));
    }

    @Transactional
    public Asset update(Asset asset) {
        if (asset.getCategoryProperties() != null) {
            String serialize = this.assetCommonUtil.serialize(asset.getCategoryProperties());
            asset.setProperties(serialize);
        }
        return (Asset)((Object)this.assetRepository.save((Object)asset));
    }

    public List<Asset> findAll() {
        return this.assetRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Asset findByName(String name) {
        return this.assetRepository.findByName(name);
    }

    public Asset findByCode(String code) {
        return this.assetRepository.findByCode(code);
    }

    public Asset findOne(Long id) {
        return (Asset)((Object)this.assetRepository.findOne(id));
    }

    public List<Asset> search(Asset asset) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Asset.class);
        Root assets = createQuery.from(Asset.class);
        createQuery.select((Selection)assets);
        Metamodel model = this.entityManager.getMetamodel();
        EntityType Asset_ = model.entity(Asset.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (asset.getName() != null) {
            String name = "%" + asset.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)assets.get("name")));
            predicates.add(cb.like(cb.lower((Expression)assets.get(Asset_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (asset.getCode() != null) {
            String code = "%" + asset.getCode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)assets.get("code")));
            predicates.add(cb.like(cb.lower((Expression)assets.get(Asset_.getDeclaredSingularAttribute("code", String.class))), code));
        }
        if (asset.getAssetCategory() != null) {
            predicates.add(cb.equal((Expression)assets.get("assetCategory"), (Object)asset.getAssetCategory()));
        }
        if (asset.getDepartment() != null) {
            predicates.add(cb.equal((Expression)assets.get("department"), (Object)asset.getDepartment()));
        }
        if (asset.getSearchStatus() != null) {
            Path status = assets.get("status");
            predicates.add(status.in(asset.getSearchStatus()));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }
}

