/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.assets.model.CategoryPropertyType;
import org.egov.assets.model.DepreciationMetaData;
import org.egov.common.entity.UOM;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGASSET_ASSET_CATEGORY")
@SequenceGenerator(name="seq_egasset_asset_category", sequenceName="seq_egasset_asset_category", allocationSize=1)
@Unique(fields={"code"}, id="id", tableName="EGASSET_ASSET_CATEGORY", columnName={"CODE"}, message="assetcat.code.isunique")
public class AssetCategory
extends AbstractAuditable {
    private static final long serialVersionUID = 4664412673598282808L;
    public static final String SEQ = "seq_egasset_asset_category";
    @Id
    @GeneratedValue(generator="seq_egasset_asset_category", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="asset_accountcode")
    @Required(message="Required")
    private CChartOfAccounts assetAccountCode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="accdep_accountcode")
    private CChartOfAccounts accDepAccountCode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="revaluation_accountcode")
    @Required(message="Required")
    private CChartOfAccounts revAccountCode;
    @Enumerated(value=EnumType.STRING)
    @Column(name="depreciation_Method")
    private DepreciationMethod depreciationMethod;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="depexp_accountcode")
    private CChartOfAccounts depExpAccountCode;
    @Length(max=50, message="assetcat.code.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="assetcat.code.alphaNumericwithspecialchar")
    private String code;
    @Required(message="Required")
    @Length(max=100, message="assetcat.name.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="assetcat.name.alphaNumericwithspecialchar")
    private String name;
    @Enumerated(value=EnumType.STRING)
    @Column(name="asset_type")
    @Required(message="Required")
    private AssetType assetType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="UOM_ID")
    @Required(message="Required")
    private UOM uom;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENTID")
    private AssetCategory parent;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL, CascadeType.PERSIST})
    @JoinColumn(name="DEPMD_AC_INDEX")
    private List<DepreciationMetaData> depreciationMetaDataList = new LinkedList<DepreciationMetaData>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="assetCategory", targetEntity=CategoryPropertyType.class)
    private List<CategoryPropertyType> categoryProperties = new LinkedList<CategoryPropertyType>();

    public CChartOfAccounts getAssetAccountCode() {
        return this.assetAccountCode;
    }

    public void setAssetAccountCode(CChartOfAccounts assetAccountCode) {
        this.assetAccountCode = assetAccountCode;
    }

    public CChartOfAccounts getAccDepAccountCode() {
        return this.accDepAccountCode;
    }

    public void setAccDepAccountCode(CChartOfAccounts accDepAccountCode) {
        this.accDepAccountCode = accDepAccountCode;
    }

    public CChartOfAccounts getRevAccountCode() {
        return this.revAccountCode;
    }

    public void setRevAccountCode(CChartOfAccounts revAccountCode) {
        this.revAccountCode = revAccountCode;
    }

    public DepreciationMethod getDepreciationMethod() {
        return this.depreciationMethod;
    }

    public void setDepreciationMethod(DepreciationMethod depreciationMethod) {
        this.depreciationMethod = depreciationMethod;
    }

    public CChartOfAccounts getDepExpAccountCode() {
        return this.depExpAccountCode;
    }

    public void setDepExpAccountCode(CChartOfAccounts depExpAccountCode) {
        this.depExpAccountCode = depExpAccountCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AssetType getAssetType() {
        return this.assetType;
    }

    public void setAssetType(AssetType assetType) {
        this.assetType = assetType;
    }

    public UOM getUom() {
        return this.uom;
    }

    public void setUom(UOM uom) {
        this.uom = uom;
    }

    public AssetCategory getParent() {
        return this.parent;
    }

    public void setParent(AssetCategory parent) {
        this.parent = parent;
    }

    public List<DepreciationMetaData> getDepreciationMetaDataList() {
        return this.depreciationMetaDataList;
    }

    public void setDepreciationMetaDataList(List<DepreciationMetaData> depreciationMetaDataList) {
        this.depreciationMetaDataList = depreciationMetaDataList;
    }

    public void addDepreciationMetaData(DepreciationMetaData depreciationMetaData) {
        this.depreciationMetaDataList.add(depreciationMetaData);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        StringBuilder objString = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        String NULL_STRING = "null";
        objString.append(((Object)((Object)this)).getClass().getName() + " Object {" + NEW_LINE);
        objString.append(" Id: " + this.id + NEW_LINE);
        objString.append(" Name: " + this.name + NEW_LINE);
        objString.append(" Code: " + this.code + NEW_LINE);
        objString.append(" Asset Type: " + (this.assetType == null ? "null" : this.assetType.toString()) + NEW_LINE);
        objString.append(" Parent: " + (this.parent == null ? "null" : this.parent.getId()) + NEW_LINE);
        objString.append(" UOM: " + (this.uom == null ? "null" : this.uom.getId()) + NEW_LINE);
        objString.append("}");
        return objString.toString();
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errorList = new ArrayList<ValidationError>();
        if (this.depreciationMetaDataList != null && !this.depreciationMetaDataList.isEmpty()) {
            for (DepreciationMetaData depMetaData : this.depreciationMetaDataList) {
                errorList.addAll(depMetaData.validate());
            }
        }
        return errorList;
    }

    public List<CategoryPropertyType> getCategoryProperties() {
        return this.categoryProperties;
    }

    public void setCategoryProperties(List<CategoryPropertyType> categoryProperties) {
        this.categoryProperties = categoryProperties;
    }

    public static enum DepreciationMethod {
        STRAIGHT_LINE_METHOD,
        WRITTENDOWN_VALUE_METHOD;

    }

    public static enum AssetType {
        LAND,
        MOVABLEASSET,
        IMMOVABLEASSET;

    }
}

