/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.assets.model.AssetCategory;
import org.egov.assets.model.CategoryPropertyType;
import org.egov.assets.repository.AssetCategoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AssetCategoryService {
    private final AssetCategoryRepository assetCategoryRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public AssetCategoryService(AssetCategoryRepository assetCategoryRepository) {
        this.assetCategoryRepository = assetCategoryRepository;
    }

    @Transactional
    public AssetCategory create(AssetCategory assetCategory) {
        assetCategory = this.removeEmptyCategoryproperties(assetCategory);
        return (AssetCategory)((Object)this.assetCategoryRepository.save((Object)assetCategory));
    }

    @Transactional
    public AssetCategory update(AssetCategory assetCategory) {
        assetCategory = this.removeEmptyCategoryproperties(assetCategory);
        return (AssetCategory)((Object)this.assetCategoryRepository.save((Object)assetCategory));
    }

    public List<AssetCategory> findAll() {
        return this.assetCategoryRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public AssetCategory findByName(String name) {
        return this.assetCategoryRepository.findByName(name);
    }

    public AssetCategory findByCode(String code) {
        return this.assetCategoryRepository.findByCode(code);
    }

    public AssetCategory findOne(Long id) {
        return (AssetCategory)((Object)this.assetCategoryRepository.findOne(id));
    }

    public List<AssetCategory> search(AssetCategory assetCategory) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(AssetCategory.class);
        Root assetCategories = createQuery.from(AssetCategory.class);
        createQuery.select((Selection)assetCategories);
        Metamodel model = this.entityManager.getMetamodel();
        EntityType AssetCategory_ = model.entity(AssetCategory.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (assetCategory.getName() != null) {
            String name = "%" + assetCategory.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)assetCategories.get("name")));
            predicates.add(cb.like(cb.lower((Expression)assetCategories.get(AssetCategory_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (assetCategory.getAssetType() != null) {
            predicates.add(cb.equal((Expression)assetCategories.get("assetType"), (Object)assetCategory.getAssetType()));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }

    private AssetCategory removeEmptyCategoryproperties(AssetCategory assetCategory) {
        Iterator<CategoryPropertyType> iterator = assetCategory.getCategoryProperties().iterator();
        while (iterator.hasNext()) {
            CategoryPropertyType categoryProperty = iterator.next();
            if (categoryProperty.getName() == null && categoryProperty.getDataType() == null && categoryProperty.getFormat() == null && categoryProperty.getEnumValues() == null && categoryProperty.getLocalText() == null) {
                iterator.remove();
                continue;
            }
            if (categoryProperty.getAssetCategory() != null) continue;
            categoryProperty.setAssetCategory(assetCategory);
        }
        return assetCategory;
    }
}

