/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.model;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Min;
import org.egov.asset.model.AssetCategory;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;

public class DepreciationMetaData
extends BaseModel {
    private static final long serialVersionUID = -4404379086769814828L;
    @Required(message="depmetadata.rate.null")
    @Min(value=0L, message="depmetadata.rate.not.negative")
    private Float depreciationRate;
    @Required(message="depmetadata.financialyear.null")
    private CFinancialYear financialYear;
    private AssetCategory assetCategory;

    public Float getDepreciationRate() {
        return this.depreciationRate;
    }

    public void setDepreciationRate(Float depreciationRate) {
        this.depreciationRate = depreciationRate;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public AssetCategory getAssetCategory() {
        return this.assetCategory;
    }

    public void setAssetCategory(AssetCategory assetCategory) {
        this.assetCategory = assetCategory;
    }

    public String toString() {
        StringBuilder objString = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        objString.append(((Object)((Object)this)).getClass().getName() + " Object {" + NEW_LINE);
        objString.append(" Id: " + this.id + NEW_LINE);
        objString.append(" Dep Rate: " + this.depreciationRate + NEW_LINE);
        objString.append(" Year: " + (this.financialYear == null ? "null" : this.financialYear.getId()) + NEW_LINE);
        objString.append(" Cat: " + (this.assetCategory == null ? "null" : this.assetCategory.getId()) + NEW_LINE);
        objString.append("}");
        return objString.toString();
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if ((double)this.depreciationRate.floatValue() <= 0.0) {
            validationErrors.add(new ValidationError("deprate", "depmetadata.rate.percentage_greater_than_0"));
        }
        if ((double)this.depreciationRate.floatValue() > 100.0) {
            validationErrors.add(new ValidationError("deprate", "depmetadata.rate.percentage_less_than_100"));
        }
        if (this.financialYear == null || this.financialYear.getId() == null) {
            validationErrors.add(new ValidationError("financialyear", "depmetadata.financialyear.required"));
        }
        return validationErrors;
    }
}

