/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.model.ModeOfAcquisition;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.pims.model.PersonalInformation;
import org.hibernate.validator.constraints.Length;

@Unique(fields={"code"}, id="id", tableName="EGASSET_ASSET", columnName={"CODE"}, message="asset.code.isunique")
public class Asset
extends BaseModel {
    private static final long serialVersionUID = 730236511745178022L;
    @Required(message="asset.code.null")
    @Length(max=50, message="asset.code.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="asset.code.alphaNumericwithspecialchar")
    private String code;
    @Required(message="asset.name.null")
    @Length(max=100, message="asset.name.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="asset.name.alphaNumericwithspecialchar")
    private String name;
    @Required(message="asset.category.null")
    private AssetCategory assetCategory;
    private Boundary area;
    private Boundary location;
    private Boundary street;
    private Boundary ward;
    private String assetDetails;
    @Required(message="asset.modeofacqui.null")
    private ModeOfAcquisition modeOfAcquisition;
    @Required(message="asset.status.null")
    private EgwStatus status;
    private String description;
    private Department department;
    private Date dateOfCreation;
    private String remarks;
    private PersonalInformation preparedBy;
    private BigDecimal grossValue;
    private BigDecimal accDepreciation;
    private BigDecimal length;
    private BigDecimal width;
    private BigDecimal totalArea;
    private String sourcePath;

    public Asset() {
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.dateOfCreation != null && !DateUtils.compareDates((Date)new Date(), (Date)this.dateOfCreation)) {
            validationErrors.add(new ValidationError("dateOfCreation", "asset.dateOfCreation.invalid"));
        }
        return validationErrors;
    }

    public Boundary getWard() {
        return this.ward;
    }

    public Asset(String code) {
        this.code = code;
    }

    public Asset(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public void setWard(Boundary ward) {
        this.ward = ward;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ModeOfAcquisition getModeOfAcquisition() {
        return this.modeOfAcquisition;
    }

    public void setModeOfAcquisition(ModeOfAcquisition modeOfAcquisition) {
        this.modeOfAcquisition = modeOfAcquisition;
    }

    public String getAssetDetails() {
        return this.assetDetails;
    }

    public void setAssetDetails(String assetDetails) {
        this.assetDetails = assetDetails;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public AssetCategory getAssetCategory() {
        return this.assetCategory;
    }

    public void setAssetCategory(AssetCategory assetCategory) {
        this.assetCategory = assetCategory;
    }

    public Boundary getArea() {
        return this.area;
    }

    public void setArea(Boundary area) {
        this.area = area;
    }

    public Boundary getLocation() {
        return this.location;
    }

    public void setLocation(Boundary location) {
        this.location = location;
    }

    public Boundary getStreet() {
        return this.street;
    }

    public void setStreet(Boundary street) {
        this.street = street;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public Date getDateOfCreation() {
        return this.dateOfCreation;
    }

    public void setDateOfCreation(Date dateOfCreation) {
        this.dateOfCreation = dateOfCreation;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public PersonalInformation getPreparedBy() {
        return this.preparedBy;
    }

    public void setPreparedBy(PersonalInformation preparedBy) {
        this.preparedBy = preparedBy;
    }

    public BigDecimal getGrossValue() {
        return this.grossValue;
    }

    public void setGrossValue(BigDecimal grossValue) {
        this.grossValue = grossValue;
    }

    public BigDecimal getAccDepreciation() {
        return this.accDepreciation;
    }

    public void setAccDepreciation(BigDecimal accDepreciation) {
        this.accDepreciation = accDepreciation;
    }

    public BigDecimal getLength() {
        return this.length;
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public BigDecimal getTotalArea() {
        return this.totalArea;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public void setTotalArea(BigDecimal totalArea) {
        this.totalArea = totalArea;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }
}

