/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetCommonUtil {
    private static final Logger LOGGER = Logger.getLogger(AssetCommonUtil.class);
    private static final String ADMIN_HIERARCHY_TYPE = "ADMINISTRATION";
    private static final String Zone_BOUNDARY_TYPE = "Zone";
    private static String hierarchyTypeName = "LOCATION";
    @Autowired
    private HierarchyTypeService heirarchyTypeService;
    @Autowired
    private CrossHierarchyService crossHeirarchyService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    public List<Boundary> getAllZoneOfHTypeAdmin() {
        HierarchyType hType = this.heirarchyTypeService.getHierarchyTypeByName(ADMIN_HIERARCHY_TYPE);
        List zoneList = null;
        BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(Zone_BOUNDARY_TYPE, hType);
        zoneList = this.boundaryService.getChildBoundariesByBoundaryId(bType.getId());
        return zoneList;
    }

    public List<Boundary> populateWard(Long zoneId) {
        LinkedList<Boundary> wardList = new LinkedList();
        try {
            wardList = this.boundaryService.getChildBoundariesByBoundaryId(zoneId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading warda - wards." + e.getMessage()));
            throw new ApplicationRuntimeException("Unable to load ward information", (Throwable)e);
        }
        return wardList;
    }

    public List<Boundary> populateArea(Long wardId) {
        HierarchyType hType = this.heirarchyTypeService.getHierarchyTypeByName(hierarchyTypeName);
        LinkedList<Boundary> areaList = new LinkedList<Boundary>();
        BoundaryType childBoundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType("Area", hType);
        Boundary parentBoundary = this.boundaryService.getBoundaryById(wardId);
        areaList = new LinkedList(this.crossHeirarchyService.getCrossHierarchyChildrens(parentBoundary, childBoundaryType));
        LOGGER.info((Object)("***********Ajax AreaList: " + ((Object)areaList).toString()));
        return areaList;
    }

    public List<Boundary> populateStreets(Long wardId) {
        HierarchyType hType = this.heirarchyTypeService.getHierarchyTypeByName(hierarchyTypeName);
        LinkedList<Boundary> streetList = new LinkedList<Boundary>();
        BoundaryType childBoundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType("Street", hType);
        Boundary parentBoundary = this.boundaryService.getBoundaryById(wardId);
        streetList = new LinkedList(this.crossHeirarchyService.getCrossHierarchyChildrens(parentBoundary, childBoundaryType));
        return streetList;
    }

    public List<Boundary> populateLocations(Long areaId) {
        List<Boundary> locationList = new LinkedList();
        try {
            locationList = this.boundaryService.getChildBoundariesByBoundaryId(areaId);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while loading locations - locations." + e.getMessage()));
            throw new ApplicationRuntimeException("Unable to load location information", (Throwable)e);
        }
        LOGGER.info((Object)("***********Ajax locationList: " + locationList.toString()));
        return locationList;
    }

    public static Date loadCurrentDate() {
        Date currDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return sdf.parse(sdf.format(currDate));
        }
        catch (ParseException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Exception while formatting voucher date", "Transaction failed")));
        }
    }

    public void setBoundaryService(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    public void setBoundaryTypeService(BoundaryTypeService boundaryTypeService) {
        this.boundaryTypeService = boundaryTypeService;
    }

    public String serialize(Object obj) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = "";
        try {
            jsonResponse = objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ApplicationRuntimeException("Exception while converting to json" + obj.getClass().getCanonicalName());
        }
        return jsonResponse;
    }
}

