/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import org.apache.commons.lang.RandomStringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;

public class AssetCategoryType {
    private String acquisitionMode;
    private String waterComponents;
    private String landSurveyNumber;
    private BigDecimal area;
    private String description;

    public static void main(String[] args) {
        String[] aMode = new String[]{"Purchase", "Tender", "Construction", "Donation", "Transfer from other department", "Acquired"};
        String[] wComp = new String[]{"Infrastructural", "Treatment", "Storage reservoir", "Pipeline"};
        AssetCategoryType ac = null;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter("/home/mani/jsonbsql.sql");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < 1000; ++i) {
            ac = new AssetCategoryType();
            ac.setAcquisitionMode(aMode[i % 6]);
            ac.setWaterComponents(wComp[i % 4]);
            ac.setLandSurveyNumber(RandomStringUtils.randomAlphanumeric((int)20).toUpperCase());
            ac.setArea(BigDecimal.valueOf(Math.random()));
            ac.setDescription("" + i);
            String jsonStr = ac.serialize(ac);
            writer.write("insert into Foo ( id,category_type) values(nextval('seq_foo'),'" + jsonStr + "');\n");
        }
    }

    public String serialize(AssetCategoryType obj) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = "";
        try {
            jsonResponse = objectMapper.writeValueAsString((Object)obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonResponse;
    }

    public String getAcquisitionMode() {
        return this.acquisitionMode;
    }

    public void setAcquisitionMode(String acquisitionMode) {
        this.acquisitionMode = acquisitionMode;
    }

    public String getWaterComponents() {
        return this.waterComponents;
    }

    public void setWaterComponents(String waterComponents) {
        this.waterComponents = waterComponents;
    }

    public String getLandSurveyNumber() {
        return this.landSurveyNumber;
    }

    public void setLandSurveyNumber(String landSurveyNumber) {
        this.landSurveyNumber = landSurveyNumber;
    }

    public BigDecimal getArea() {
        return this.area;
    }

    public void setArea(BigDecimal area) {
        this.area = area;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

