/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.model;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.egov.assets.model.AssetCategory;
import org.egov.assets.model.CategoryPropertyType;
import org.egov.assets.model.LocationDetails;
import org.egov.assets.model.bean.AssetCustomPropertyBean;
import org.egov.assets.persistence.StringJsonUserType;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.pims.model.PersonalInformation;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.validator.constraints.Length;

@TypeDefs(value={@TypeDef(name="StringJsonObject", typeClass=StringJsonUserType.class)})
@Entity
@Table(name="EGASSET_ASSET")
@SequenceGenerator(name="seq_egasset_asset", sequenceName="seq_egasset_asset", allocationSize=1)
@Unique(fields={"code"}, id="id", tableName="EGASSET_ASSET", columnName={"CODE"}, message="asset.code.isunique")
public class Asset
extends AbstractAuditable {
    private static final long serialVersionUID = 730236511745178022L;
    public static final String WORKFLOWTYPES_QRY = "ParentChildCategories";
    public static final String SEQ = "seq_egasset_asset";
    @Id
    @GeneratedValue(generator="seq_egasset_asset", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(max=50, message="asset.code.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="asset.code.alphaNumericwithspecialchar")
    private String code;
    @Required(message="asset.name.null")
    @Length(max=256, message="asset.name.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="asset.name.alphaNumericwithspecialchar")
    @NotNull
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ASSETCATEGORY_ID")
    @Required(message="asset.category.null")
    private AssetCategory assetCategory;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="DEPARTMENTID")
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STREET_ID")
    private Boundary street;
    @Column(name="asset_details")
    private String assetDetails;
    @Enumerated(value=EnumType.STRING)
    @Required(message="asset.modeofacqui.null")
    @NotNull
    private ModeOfAcquisition modeOfAcquisition;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUSID")
    @Required(message="asset.status.null")
    private EgwStatus status;
    @Length(max=256)
    private String description;
    @Column(name="date_of_creation")
    private Date dateOfCreation;
    @Length(max=1024)
    private String remarks;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PREPAREDBY")
    private PersonalInformation preparedBy;
    private BigDecimal grossValue;
    private BigDecimal accDepreciation;
    private BigDecimal length;
    private BigDecimal width;
    @Column(name="total_area")
    private BigDecimal totalArea;
    @Length(max=150)
    private String sourcePath;
    @Type(type="StringJsonObject")
    private String properties;
    @Transient
    private List<AssetCustomPropertyBean> categoryProperties;
    @Transient
    private List<CategoryPropertyType> categoryPropertyTypeList;
    @Transient
    private List<Long> searchStatus;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="locationDetails_Id", nullable=false)
    private LocationDetails locationDetails;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.dateOfCreation != null && !DateUtils.compareDates((Date)new Date(), (Date)this.dateOfCreation)) {
            validationErrors.add(new ValidationError("dateOfCreation", "asset.dateOfCreation.invalid"));
        }
        return validationErrors;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ModeOfAcquisition getModeOfAcquisition() {
        return this.modeOfAcquisition;
    }

    public void setModeOfAcquisition(ModeOfAcquisition modeOfAcquisition) {
        this.modeOfAcquisition = modeOfAcquisition;
    }

    public String getAssetDetails() {
        return this.assetDetails;
    }

    public void setAssetDetails(String assetDetails) {
        this.assetDetails = assetDetails;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public AssetCategory getAssetCategory() {
        return this.assetCategory;
    }

    public void setAssetCategory(AssetCategory assetCategory) {
        this.assetCategory = assetCategory;
    }

    public Boundary getStreet() {
        return this.street;
    }

    public void setStreet(Boundary street) {
        this.street = street;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public Date getDateOfCreation() {
        return this.dateOfCreation;
    }

    public void setDateOfCreation(Date dateOfCreation) {
        this.dateOfCreation = dateOfCreation;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public PersonalInformation getPreparedBy() {
        return this.preparedBy;
    }

    public void setPreparedBy(PersonalInformation preparedBy) {
        this.preparedBy = preparedBy;
    }

    public BigDecimal getGrossValue() {
        return this.grossValue;
    }

    public void setGrossValue(BigDecimal grossValue) {
        this.grossValue = grossValue;
    }

    public BigDecimal getAccDepreciation() {
        return this.accDepreciation;
    }

    public void setAccDepreciation(BigDecimal accDepreciation) {
        this.accDepreciation = accDepreciation;
    }

    public BigDecimal getLength() {
        return this.length;
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public BigDecimal getTotalArea() {
        return this.totalArea;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public void setTotalArea(BigDecimal totalArea) {
        this.totalArea = totalArea;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public List<CategoryPropertyType> getCategoryPropertyTypeList() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (this.properties != null) {
                List categoryList = (List)objectMapper.readValue(this.properties, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, CategoryPropertyType.class));
                return categoryList;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setCategoryPropertyTypeList(List<CategoryPropertyType> categoryPropertyTypeList) {
        this.categoryPropertyTypeList = categoryPropertyTypeList;
    }

    public List<AssetCustomPropertyBean> getCategoryProperties() {
        return this.categoryProperties;
    }

    public void setCategoryProperties(List<AssetCustomPropertyBean> categoryProperties) {
        this.categoryProperties = categoryProperties;
    }

    public LocationDetails getLocationDetails() {
        return this.locationDetails;
    }

    public void setLocationDetails(LocationDetails locationDetails) {
        this.locationDetails = locationDetails;
    }

    public List<Long> getSearchStatus() {
        return this.searchStatus;
    }

    public void setSearchStatus(List<Long> searchStatus) {
        this.searchStatus = searchStatus;
    }

    public static enum ModeOfAcquisition {
        ACQUIRED,
        CONSTRUCTION,
        PURCHASE,
        TENDER;

    }
}

