/*
 * Decompiled with CFR 0.152.
 */
package org.egov.assets.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.assets.model.CategoryPropertyType;
import org.egov.assets.repository.CategoryPropertyTypeRepository;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CategoryPropertyTypeService {
    private final CategoryPropertyTypeRepository categoryPropertyTypeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CategoryPropertyTypeService(CategoryPropertyTypeRepository categoryPropertyTypeRepository) {
        this.categoryPropertyTypeRepository = categoryPropertyTypeRepository;
    }

    @Transactional
    public CategoryPropertyType create(CategoryPropertyType categoryPropertyType) {
        return (CategoryPropertyType)((Object)this.categoryPropertyTypeRepository.save((Object)categoryPropertyType));
    }

    @Transactional
    public CategoryPropertyType update(CategoryPropertyType categoryPropertyType) {
        return (CategoryPropertyType)((Object)this.categoryPropertyTypeRepository.save((Object)categoryPropertyType));
    }

    public List<CategoryPropertyType> findAll() {
        return this.categoryPropertyTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CategoryPropertyType findByName(String name) {
        return this.categoryPropertyTypeRepository.findByName(name);
    }

    public CategoryPropertyType findOne(Long id) {
        return (CategoryPropertyType)((Object)this.categoryPropertyTypeRepository.findOne(id));
    }

    public List<CategoryPropertyType> search(CategoryPropertyType categoryPropertyType) {
        return this.categoryPropertyTypeRepository.findAll();
    }

    public void delete(Long id) {
        this.categoryPropertyTypeRepository.delete(id);
    }

    public List<?> getMasterData(CategoryPropertyType category, String queryText) {
        Session session = (Session)this.entityManager.unwrap(Session.class);
        Query createQuery = session.createQuery("from " + category.getEnumValues() + " where Lower(name) like '%" + queryText.toLowerCase() + "%'");
        createQuery.setMaxResults(20);
        return createQuery.list();
    }
}

