/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.asset.model.Asset;
import org.egov.asset.model.AssetNumberGenrator;
import org.egov.asset.service.AppService;
import org.egov.asset.service.AssetService;
import org.egov.asset.service.impl.BaseServiceImpl;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class AssetServiceImpl
extends BaseServiceImpl<Asset, Long>
implements AssetService {
    private static final Logger logger = Logger.getLogger(AssetServiceImpl.class);
    private AppService appService;
    private AssetNumberGenrator assetNumberGenrator;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public AssetServiceImpl(PersistenceService<Asset, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public void setAssetNumber(Asset entity) {
        String year = this.getFinancialYear(entity.getDateOfCreation());
        if (entity != null && (entity.getId() == null || entity.getCode() == null || "".equals(entity.getCode())) && this.isAssetCodeAutoGenerated()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"---Auto generating Asset code....");
            }
            entity.setCode(this.assetNumberGenrator.getAssetNumber(entity, year));
        }
    }

    private String getFinancialYear(Date date) {
        CFinancialYear financialYear = null;
        String finYear = "";
        SimpleDateFormat simpleDateformat = new SimpleDateFormat("yyyy");
        try {
            financialYear = this.financialYearDAO.getFinYearByDate(date);
        }
        catch (ApplicationRuntimeException ex) {
            logger.error((Object)ex.getMessage());
        }
        finYear = financialYear == null ? simpleDateformat.format(date) : financialYear.getFinYearRange();
        return finYear;
    }

    @Override
    public boolean isAssetCodeAutoGenerated() {
        String isAutoGenerated = this.appService.getUniqueAppConfigValue("IS_ASSET_CODE_AUTOGENERATED");
        return "yes".equalsIgnoreCase(isAutoGenerated);
    }

    @Override
    public Asset getAssetByCode(String code) {
        return (Asset)((Object)this.find(" from Asset where code = ?", code));
    }

    @Override
    public List<Asset> getAssetsByCategoryId(Long assetCategoryId) {
        return this.findAllBy(" from Asset where assetCategory.id = ? order by code", assetCategoryId);
    }

    public void setAppService(AppService appService) {
        this.appService = appService;
    }

    public void setAssetNumberGenrator(AssetNumberGenrator assetNumberGenrator) {
        this.assetNumberGenrator = assetNumberGenrator;
    }
}

