/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.service.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.model.AssetCategoryNumberGenrator;
import org.egov.asset.model.AssetType;
import org.egov.asset.service.AppService;
import org.egov.asset.service.AssetCategoryService;
import org.egov.asset.service.impl.BaseServiceImpl;
import org.egov.infstr.services.PersistenceService;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class AssetCategoryServiceImpl
extends BaseServiceImpl<AssetCategory, Long>
implements AssetCategoryService {
    private static final Logger logger = Logger.getLogger(AssetCategoryServiceImpl.class);
    private AppService appService;
    private AssetCategoryNumberGenrator assetCategoryNumberGenrator;

    public AssetCategoryServiceImpl(PersistenceService<AssetCategory, Long> persistenceService) {
        super(persistenceService);
    }

    @Override
    public void setAssetCategoryNumber(AssetCategory entity) {
        if (entity != null && (entity.getId() == null || entity.getCode() == null || "".equals(entity.getCode())) && this.isAssetCategoryCodeAutoGenerated()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"---Auto generating Asset Category code....");
            }
            entity.setCode(this.assetCategoryNumberGenrator.getAssetCategoryNumber(entity));
        }
    }

    @Override
    public boolean isAssetCategoryCodeAutoGenerated() {
        String isAutoGenerated = this.appService.getUniqueAppConfigValue("IS_ASSET_CATEGORYCODE_AUTOGENERATED");
        return "yes".equalsIgnoreCase(isAutoGenerated);
    }

    @Override
    public List<AssetCategory> getAllAssetCategoryByAssetType(String assetType) {
        return this.findAllBy(" from AssetCategory where assetType = ? order by name asc", new Object[]{AssetType.valueOf(assetType)});
    }

    @Override
    public List<AssetCategory> getAllParentAssetCategory() {
        return this.findAllBy(" from AssetCategory where parent is null order by name asc", new Object[0]);
    }

    @Override
    public List<AssetCategory> getAllParentAssetCategoryByAssetType(String assetType) {
        return this.findAllBy(" from AssetCategory where parent is null and assetType = ? order by name asc", new Object[]{AssetType.valueOf(assetType)});
    }

    @Override
    public List<AssetCategory> getAllAssetCategoryByParent(Long parentId) {
        return this.findAllBy(" from AssetCategory where parent.id=? order by name asc", parentId);
    }

    @Override
    public AssetCategory getAssetCategoryByCode(String code) {
        return (AssetCategory)((Object)this.find(" from AssetCategory where code=?", code));
    }

    public void setAppService(AppService appService) {
        this.appService = appService;
    }

    public void setAssetCategoryNumberGenrator(AssetCategoryNumberGenrator assetCategoryNumberGenrator) {
        this.assetCategoryNumberGenrator = assetCategoryNumberGenrator;
    }
}

