/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.displaytag.pagination.PaginatedList;
import org.egov.asset.model.Asset;
import org.egov.asset.model.AssetCategory;
import org.egov.asset.model.ModeOfAcquisition;
import org.egov.asset.service.AssetCategoryService;
import org.egov.asset.service.AssetService;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonAssetsService {
    private static final Logger LOGGER = Logger.getLogger(CommonAssetsService.class);
    protected AssetCategoryService assetCategoryService;
    protected AssetService assetService;
    protected PersistenceService genericService;
    public static final String ASSET_ID = "ASSET_ID";
    public static final String ASSET_CODE = "ASSET_CODE";
    public static final String ASSET_NAME = "ASSET_NAME";
    public static final String ASSET_CATEGORY_ID = "ASSET_CATEGORY_ID";
    public static final String ASSET_AREA_ID = "ASSET_AREA_ID";
    public static final String ASSET_LOCATION_ID = "ASSET_LOCATION_ID";
    public static final String ASSET_STREET_ID = "ASSET_STREET_ID";
    public static final String ASSET_WARD_ID = "ASSET_WARD_ID";
    public static final String ASSET_DETAILS = "ASSET_DETAILS";
    public static final String ASSET_MODE_OF_ACQUISITION = "ASSET_MODE_OF_ACQUISITION";
    public static final String ASSET_COMMISSIONING_DATE = "ASSET_COMMISSIONING_DATE";
    public static final String ASSET_STATUS_ID = "ASSET_STATUS_ID";
    public static final String ASSET_GROSS_VALUE = "ASSET_GROSS_VALUE";
    public static final String ASSET_ACCUMULATIVE_DEPRECIATION = "ASSET_ACCUMULATIVE_DEPRECIATION";
    public static final String ASSET_WRITTEN_DOWN_VALUE = "ASSET_WRITTEN_DOWN_VALUE";
    public static final String ASSET_DESCRIPTION = "ASSET_DESCRIPTION";
    public static final String ASSET_CATEGORY_CODE = "ASSET_CATEGORY_CODE";
    public static final String ASSET_CATEGORY_NAME = "ASSET_CATEGORY_NAME";
    public static final String ASSET_TYPE = "ASSET_TYPE";
    public static final String ASSET_DEPARTMENT_ID = "ASSET_DEPARTMENT_ID";
    public static final String ASSET_STATUS_ID_LIST = "ASSET_STATUS_ID_LIST";
    public static final String ASSET_TYPE_NAME = "ASSET_TYPE_NAME";
    public static final String ASSET_DEPARTMENT_CODE = "ASSET_DEPARTMENT_CODE";
    public static final String ASSET_WARD_NAME = "ASSET_WARD_NAME";
    public static final String ASSET_STATUS_LIST = "ASSET_STATUS_LIST";
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private BoundaryService boundaryService;

    public AssetCategory getAssetCategoryById(Long categoryId) {
        AssetCategory assetCategory = null;
        try {
            assetCategory = (AssetCategory)((Object)this.assetCategoryService.findById(categoryId, false));
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while getting AssetCategoryById.");
            throw new ApplicationRuntimeException("Hibernate Exception : getting AssetCategoryById." + he.getMessage(), (Throwable)he);
        }
        return assetCategory;
    }

    public List<AssetCategory> getAllAssetCategory() {
        List<AssetCategory> assetCategoryList = null;
        try {
            assetCategoryList = this.assetCategoryService.findAll("name");
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while getting AllAssetCategoryList.");
            throw new ApplicationRuntimeException("Hibernate Exception : getting AllAssetCategoryList." + he.getMessage(), (Throwable)he);
        }
        return assetCategoryList;
    }

    public Asset getAssetById(Long assetId) {
        Asset asset = null;
        try {
            asset = (Asset)((Object)this.assetService.findById(assetId, false));
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while getting AssetById.");
            throw new ApplicationRuntimeException("Hibernate Exception : getting AssetById." + he.getMessage(), (Throwable)he);
        }
        return asset;
    }

    public Asset getAssetByCode(String code) {
        Asset asset = null;
        try {
            asset = this.assetService.getAssetByCode(code);
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while getting AssetByCode.");
            throw new ApplicationRuntimeException("Hibernate Exception : getting AssetByCode." + he.getMessage(), (Throwable)he);
        }
        return asset;
    }

    public List<Asset> getAssetsByCategoryId(Long categoryId) {
        List<Asset> assetList = null;
        try {
            assetList = this.assetService.getAssetsByCategoryId(categoryId);
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while getting AssetsByCategoryId.");
            throw new ApplicationRuntimeException("Hibernate Exception : getting AssetsByCategoryId." + he.getMessage(), (Throwable)he);
        }
        return assetList;
    }

    public AssetCategory getAssetCategoryByCode(String code) {
        AssetCategory assetCategory = null;
        try {
            assetCategory = this.assetCategoryService.getAssetCategoryByCode(code);
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while getting AssetCategoryByCode.");
            throw new ApplicationRuntimeException("Hibernate Exception : getting AssetCategoryByCode." + he.getMessage(), (Throwable)he);
        }
        return assetCategory;
    }

    public List<Asset> getAllAssets() {
        List<Asset> assetList = null;
        try {
            assetList = this.assetService.findAll("code");
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while getting AllAssetList.");
            throw new ApplicationRuntimeException("Hibernate Exception : getting AllAssetList." + he.getMessage(), (Throwable)he);
        }
        return assetList;
    }

    public List<EgwStatus> getAllAssetStatus() {
        return this.egwStatusHibernateDAO.getStatusByModule("ASSET");
    }

    public Asset createOrUpdateAsset(Map<String, Object> parameters) {
        Asset asset = new Asset();
        if (parameters.get(ASSET_ID) != null) {
            asset = (Asset)((Object)this.assetService.findById((Long)parameters.get(ASSET_ID), false));
        }
        if (asset == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("asset.id.doesNotExist", "asset.id.doesNotExist")));
        }
        try {
            if (parameters.get(ASSET_CODE) == null && asset.getCode() == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("asset.code.mandatory", "asset.code.mandatory")));
            }
            if (parameters.get(ASSET_CODE) != null) {
                asset.setCode((String)parameters.get(ASSET_CODE));
            }
            if (parameters.get(ASSET_NAME) == null && asset.getName() == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("asset.name.mandatory", "asset.name.mandatory")));
            }
            if (parameters.get(ASSET_NAME) != null) {
                asset.setName((String)parameters.get(ASSET_NAME));
            }
            if (parameters.get(ASSET_CATEGORY_ID) == null && asset.getAssetCategory() == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("asset.category.mandatory", "asset.category.mandatory")));
            }
            if (parameters.get(ASSET_CATEGORY_ID) != null) {
                AssetCategory assetCategory = (AssetCategory)((Object)this.assetCategoryService.findById((Long)parameters.get(ASSET_CATEGORY_ID), false));
                if (assetCategory == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("asset.category.doesNotExist", "asset.category.doesNotExist")));
                }
                asset.setAssetCategory(assetCategory);
            }
            if (parameters.get(ASSET_STATUS_ID) == null && asset.getStatus() == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("asset.status.mandatory", "asset.status.mandatory")));
            }
            if (parameters.get(ASSET_STATUS_ID) != null) {
                EgwStatus status = this.egwStatusHibernateDAO.findById((Integer)parameters.get(ASSET_STATUS_ID), false);
                if (status == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("asset.status.doesNotExist", "asset.status.doesNotExist")));
                }
                asset.setStatus(status);
            }
            if (parameters.get(ASSET_DESCRIPTION) != null) {
                asset.setDescription((String)parameters.get(ASSET_DESCRIPTION));
            }
            if (parameters.get(ASSET_AREA_ID) != null) {
                Boundary area = this.boundaryService.getBoundaryById((Long)parameters.get(ASSET_AREA_ID));
                if (area == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("asset.area.doesNotExist", "asset.area.doesNotExist")));
                }
                asset.setArea(area);
            }
            if (parameters.get(ASSET_LOCATION_ID) != null) {
                Boundary location = this.boundaryService.getBoundaryById((Long)parameters.get(ASSET_LOCATION_ID));
                if (location == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("asset.location.doesNotExist", "asset.location.doesNotExist")));
                }
                asset.setLocation(location);
            }
            if (parameters.get(ASSET_STREET_ID) != null) {
                Boundary street = this.boundaryService.getBoundaryById((Long)parameters.get(ASSET_STREET_ID));
                if (street == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("asset.street.doesNotExist", "asset.street.doesNotExist")));
                }
                asset.setStreet(street);
            }
            if (parameters.get(ASSET_WARD_ID) != null) {
                Boundary ward = this.boundaryService.getBoundaryById((Long)parameters.get(ASSET_WARD_ID));
                if (ward == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("asset.ward.doesNotExist", "asset.ward.doesNotExist")));
                }
                asset.setWard(ward);
            }
            if (parameters.get(ASSET_MODE_OF_ACQUISITION) != null) {
                asset.setModeOfAcquisition(ModeOfAcquisition.valueOf((String)parameters.get(ASSET_MODE_OF_ACQUISITION)));
            }
            asset = this.assetService.persist(asset);
        }
        catch (HibernateException he) {
            LOGGER.error((Object)"Error while creating Asset through API.");
            throw new ApplicationRuntimeException("Hibernate Exception : in createAsset." + he.getMessage(), (Throwable)he);
        }
        return asset;
    }

    public List<Asset> searchAssets(Map<String, Object> parameters) {
        Map queryAndParam1 = this.getsearchAssetQuery(parameters);
        String query = (String)queryAndParam1.get("query");
        List params2 = (List)queryAndParam1.get("params");
        return this.assetService.findAllBy(query, params2.toArray());
    }

    public PaginatedList searchAssetPage(Map<String, Object> parameters, int pageNumber, int pageSize) {
        Map queryAndParams1 = this.getsearchAssetQuery(parameters);
        String query = (String)queryAndParams1.get("query");
        List params1 = (List)queryAndParams1.get("params");
        Page page = this.assetService.findPageBy(query, pageNumber, pageSize, params1.toArray());
        Long count = (Long)this.genericService.find("select count(*) " + query, params1.toArray());
        return new EgovPaginatedList(page, count.intValue());
    }

    public PaginatedList findAssetPage(Map<String, Object> parameters, int pageNumber, int pageSize) {
        Map queryAndParam = this.findAssetQuery(parameters);
        String query = (String)queryAndParam.get("query");
        List params = (List)queryAndParam.get("params");
        Page page = this.assetService.findPageBy(query, pageNumber, pageSize, params.toArray());
        Long count = (Long)this.genericService.find("select count(*) " + query, params.toArray());
        return new EgovPaginatedList(page, count.intValue());
    }

    private Map findAssetQuery(Map<String, Object> parameters) {
        HashMap<String, Object> queryAndParams = new HashMap<String, Object>();
        ArrayList<Object> paramsList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder(500);
        sql.append("from Asset asset where asset.code is not null ");
        if (parameters == null) {
            queryAndParams.put("query", sql.toString());
            queryAndParams.put("params", paramsList);
            return queryAndParams;
        }
        int counter = 0;
        if (!StringUtils.isEmpty((String)((String)parameters.get(ASSET_CODE)))) {
            sql.append(" and UPPER(asset.code) like '%'||?||'%'");
            paramsList.add(((String)parameters.get(ASSET_CODE)).toUpperCase());
            ++counter;
        }
        if (!StringUtils.isEmpty((String)((String)parameters.get(ASSET_TYPE_NAME)))) {
            sql.append(" and asset.assetCategory.assetType = ? ");
            paramsList.add(parameters.get(ASSET_TYPE_NAME));
            ++counter;
        }
        if (!StringUtils.isEmpty((String)((String)parameters.get(ASSET_CATEGORY_CODE)))) {
            AssetCategory assetCategory = this.assetCategoryService.getAssetCategoryByCode(((String)parameters.get(ASSET_CATEGORY_CODE)).toUpperCase());
            if (assetCategory == null) {
                throw new ValidationException("invalid.assetcategory.code", "Invalid Assetcategory Code", new String[0]);
            }
            sql.append(" and asset.assetCategory.id = ?");
            paramsList.add(assetCategory.getId());
            ++counter;
        }
        if (!StringUtils.isEmpty((String)((String)parameters.get(ASSET_DEPARTMENT_CODE)))) {
            Department dept = this.departmentService.getDepartmentByCode(((String)parameters.get(ASSET_DEPARTMENT_CODE)).toUpperCase());
            if (dept == null) {
                throw new ValidationException("invalid.department.code", "Invalid Department Code", new String[0]);
            }
            sql.append(" and asset.department.id = ?");
            paramsList.add(dept.getId());
            ++counter;
        }
        if (!StringUtils.isEmpty((String)((String)parameters.get(ASSET_WARD_NAME)))) {
            Boundary boundary = (Boundary)this.genericService.find(" from Boundary where upper(name)=? and boundaryType=(select id from BoundaryType where upper(name)=? and heirarchyType=(select id from HierarchyType where upper(name)=?))", new Object[]{((String)parameters.get(ASSET_WARD_NAME)).toUpperCase(), "WARD", "ADMINISTRATION"});
            if (boundary == null) {
                throw new ValidationException("invalid.ward.name", "Invalid Ward Name", new String[0]);
            }
            sql.append(" and asset.ward.id = ?");
            paramsList.add(boundary.getId());
            ++counter;
        }
        if (parameters.get(ASSET_DESCRIPTION) != null && !((String)parameters.get(ASSET_DESCRIPTION)).trim().equalsIgnoreCase("")) {
            sql.append(" and UPPER(asset.description) like '%'||?||'%'");
            paramsList.add(((String)parameters.get(ASSET_DESCRIPTION)).toUpperCase());
            ++counter;
        }
        if (parameters.get(ASSET_STATUS_LIST) != null) {
            sql.append(" and asset.status.id in (?").append(counter).append(")");
            ArrayList<Integer> statuses = new ArrayList<Integer>();
            for (String statusDesc : (String[])parameters.get(ASSET_STATUS_LIST)) {
                EgwStatus status = this.egwStatusHibernateDAO.getStatusByModuleAndCode("ASSET", statusDesc);
                if (status == null) {
                    throw new ValidationException("invalid.status.description", "Invalid Status Description", new String[0]);
                }
                statuses.add(status.getId());
            }
            paramsList.add(statuses);
        }
        queryAndParams.put("query", sql.toString());
        queryAndParams.put("params", paramsList);
        return queryAndParams;
    }

    public PaginatedList getAssetCategoryPage(int pageNumber, int pageSize) {
        Map queryAndParamsCat = this.getAssetCategorySearchQuery(null);
        String query = (String)queryAndParamsCat.get("query");
        List paramsCat = (List)queryAndParamsCat.get("params");
        Page page = this.assetCategoryService.findPageBy(query, pageNumber, pageSize, paramsCat.toArray());
        Long count = (Long)this.genericService.find("select count(*) " + query, paramsCat.toArray());
        return new EgovPaginatedList(page, count.intValue());
    }

    public List<AssetCategory> searchAssetCategory(Map<String, Object> parameters) {
        Map queryAndParamsCat = this.getAssetCategorySearchQuery(parameters);
        String query = (String)queryAndParamsCat.get("query");
        List paramsCat2 = (List)queryAndParamsCat.get("params");
        return this.assetCategoryService.findAllBy(query, paramsCat2.toArray());
    }

    public PaginatedList searchAssetCategoryPage(Map<String, Object> parameters, int pageNumber, int pageSize) {
        Map queryAndParamsCat = this.getAssetCategorySearchQuery(parameters);
        String query = (String)queryAndParamsCat.get("query");
        List paramsCat1 = (List)queryAndParamsCat.get("params");
        Page page = this.assetCategoryService.findPageBy(query, pageNumber, pageSize, paramsCat1.toArray());
        Long count = (Long)this.genericService.find("select count(*) " + query, paramsCat1.toArray());
        return new EgovPaginatedList(page, count.intValue());
    }

    private Map getsearchAssetQuery(Map<String, Object> parameters) {
        List statusIds;
        StringBuilder sql = new StringBuilder(260);
        HashMap<String, Object> queryAndParams1 = new HashMap<String, Object>();
        ArrayList<Object> paramsList1 = new ArrayList<Object>();
        sql.append("from Asset asset where asset.code is not null ");
        if (parameters == null) {
            queryAndParams1.put("query", sql.toString());
            queryAndParams1.put("params", paramsList1);
            return queryAndParams1;
        }
        int counter = 0;
        if (parameters.get(ASSET_CATEGORY_ID) != null) {
            sql.append(" and asset.assetCategory.id = ?");
            paramsList1.add(parameters.get(ASSET_CATEGORY_ID));
            ++counter;
        }
        if (parameters.get(ASSET_TYPE) != null) {
            sql.append(" and asset.assetCategory.assetType = ?");
            paramsList1.add(parameters.get(ASSET_TYPE));
            ++counter;
        }
        if (parameters.get(ASSET_DEPARTMENT_ID) != null) {
            sql.append(" and asset.assetCategory.department.id = ?");
            paramsList1.add(parameters.get(ASSET_DEPARTMENT_ID));
            ++counter;
        }
        if (parameters.get(ASSET_CODE) != null && !((String)parameters.get(ASSET_CODE)).trim().equalsIgnoreCase("")) {
            sql.append(" and UPPER(asset.code) like '%'||?||'%'");
            paramsList1.add(((String)parameters.get(ASSET_CODE)).toUpperCase());
            ++counter;
        }
        if (parameters.get(ASSET_DESCRIPTION) != null && !((String)parameters.get(ASSET_DESCRIPTION)).trim().equalsIgnoreCase("")) {
            sql.append(" and UPPER(asset.description) like '%'||?||'%'");
            paramsList1.add(((String)parameters.get(ASSET_DESCRIPTION)).toUpperCase());
            ++counter;
        }
        if (parameters.get(ASSET_WARD_ID) != null) {
            sql.append(" and asset.ward.id = ?");
            paramsList1.add(parameters.get(ASSET_WARD_ID));
            ++counter;
        }
        if (parameters.get(ASSET_STATUS_ID_LIST) != null && !(statusIds = (List)parameters.get(ASSET_STATUS_ID_LIST)).isEmpty()) {
            sql.append(" and asset.status.id in (?").append(counter).append(")");
            paramsList1.add(statusIds);
        }
        queryAndParams1.put("query", sql.toString());
        queryAndParams1.put("params", paramsList1);
        return queryAndParams1;
    }

    private Map getAssetCategorySearchQuery(Map<String, Object> parameters) {
        HashMap<String, Object> queryAndParamsCat = new HashMap<String, Object>();
        ArrayList<String> paramsListCat = new ArrayList<String>();
        StringBuffer sql = new StringBuffer(270);
        sql.append("from AssetCategory assetcategory where assetcategory.code is not null ");
        if (parameters == null) {
            queryAndParamsCat.put("query", sql.toString());
            queryAndParamsCat.put("params", paramsListCat);
            return queryAndParamsCat;
        }
        if (parameters.get(ASSET_CATEGORY_CODE) != null && !((String)parameters.get(ASSET_CATEGORY_CODE)).trim().equalsIgnoreCase("")) {
            sql.append(" and UPPER(assetcategory.code) like '%'||?||'%'");
            paramsListCat.add(((String)parameters.get(ASSET_CATEGORY_CODE)).toUpperCase());
        }
        if (parameters.get(ASSET_CATEGORY_NAME) != null && !((String)parameters.get(ASSET_CATEGORY_NAME)).trim().equalsIgnoreCase("")) {
            sql.append(" and UPPER(assetcategory.name) like '%'||?||'%'");
            paramsListCat.add(((String)parameters.get(ASSET_CATEGORY_NAME)).toUpperCase());
        }
        queryAndParamsCat.put("query", sql.toString());
        queryAndParamsCat.put("params", paramsListCat);
        return queryAndParamsCat;
    }

    public String getAllChilds(Long parentCatgId) {
        StringBuffer assetCatIdStr = new StringBuffer(100);
        List assetChildCategoryList = this.genericService.findAllByNamedQuery("ParentChildCategories", new Object[]{parentCatgId});
        int len = assetChildCategoryList.size();
        for (int i = 0; i < len; ++i) {
            assetCatIdStr.append(((Long)assetChildCategoryList.get(i)).toString());
            if (i >= len - 1) continue;
            assetCatIdStr.append(',');
        }
        return assetCatIdStr.toString();
    }

    public List<EgwStatus> getStatusListByDescs(String[] statusDesc) {
        List lStatusList = null;
        List<String> descriptions = Arrays.asList(statusDesc);
        StringBuffer sql = new StringBuffer(100);
        sql.append("from EgwStatus st where st.moduletype=?  and UPPER(st.description) in (?1) order by description");
        String query = sql.toString();
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add("ASSET");
        paramList.add(new ArrayList<String>(descriptions));
        lStatusList = this.genericService.findAllBy(query, paramList.toArray());
        return lStatusList;
    }

    public void setAssetCategoryService(AssetCategoryService assetCategoryService) {
        this.assetCategoryService = assetCategoryService;
    }

    public void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    public void setGenericService(PersistenceService genericService) {
        this.genericService = genericService;
    }
}

