/*
 * Decompiled with CFR 0.152.
 */
package org.egov.asset.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.validation.Valid;
import org.egov.asset.model.Asset;
import org.egov.asset.model.AssetType;
import org.egov.asset.model.DepreciationMetaData;
import org.egov.asset.model.DepreciationMethod;
import org.egov.common.entity.UOM;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.hibernate.validator.constraints.Length;

@Unique(fields={"code"}, id="id", tableName="EGASSET_ASSET_CATEGORY", columnName={"CODE"}, message="assetcat.code.isunique")
public class AssetCategory
extends BaseModel {
    private static final long serialVersionUID = 4664412673598282808L;
    @Required(message="assetcat.assetaccountcode.null")
    private CChartOfAccounts assetAccountCode;
    private Long maxLife;
    private CChartOfAccounts accDepAccountCode;
    @Required(message="assetcat.revaccountcode.null")
    private CChartOfAccounts revAccountCode;
    private DepreciationMethod depreciationMethod;
    private CChartOfAccounts depExpAccountCode;
    @Required(message="assetcat.code.null")
    @Length(max=50, message="assetcat.code.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="assetcat.code.alphaNumericwithspecialchar")
    private String code;
    @Required(message="assetcat.name.null")
    @Length(max=100, message="assetcat.name.length")
    @OptionalPattern(regex="[0-9a-zA-Z-&/: ]+", message="assetcat.name.alphaNumericwithspecialchar")
    private String name;
    private String catAttrTemplate;
    @Required(message="assetcat.assettype.null")
    private AssetType assetType;
    @Required(message="assetcat.uom.null")
    private UOM uom;
    private AssetCategory parent;
    @Valid
    private List<DepreciationMetaData> depreciationMetaDataList = new LinkedList<DepreciationMetaData>();
    private List<Asset> assets = new LinkedList<Asset>();

    public CChartOfAccounts getAssetAccountCode() {
        return this.assetAccountCode;
    }

    public void setAssetAccountCode(CChartOfAccounts assetAccountCode) {
        this.assetAccountCode = assetAccountCode;
    }

    public Long getMaxLife() {
        return this.maxLife;
    }

    public void setMaxLife(Long maxLife) {
        this.maxLife = maxLife;
    }

    public CChartOfAccounts getAccDepAccountCode() {
        return this.accDepAccountCode;
    }

    public void setAccDepAccountCode(CChartOfAccounts accDepAccountCode) {
        this.accDepAccountCode = accDepAccountCode;
    }

    public CChartOfAccounts getRevAccountCode() {
        return this.revAccountCode;
    }

    public void setRevAccountCode(CChartOfAccounts revAccountCode) {
        this.revAccountCode = revAccountCode;
    }

    public DepreciationMethod getDepreciationMethod() {
        return this.depreciationMethod;
    }

    public void setDepreciationMethod(DepreciationMethod depreciationMethod) {
        this.depreciationMethod = depreciationMethod;
    }

    public CChartOfAccounts getDepExpAccountCode() {
        return this.depExpAccountCode;
    }

    public void setDepExpAccountCode(CChartOfAccounts depExpAccountCode) {
        this.depExpAccountCode = depExpAccountCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCatAttrTemplate() {
        return this.catAttrTemplate;
    }

    public void setCatAttrTemplate(String catAttrTemplate) {
        this.catAttrTemplate = catAttrTemplate;
    }

    public AssetType getAssetType() {
        return this.assetType;
    }

    public void setAssetType(AssetType assetType) {
        this.assetType = assetType;
    }

    public UOM getUom() {
        return this.uom;
    }

    public void setUom(UOM uom) {
        this.uom = uom;
    }

    public AssetCategory getParent() {
        return this.parent;
    }

    public void setParent(AssetCategory parent) {
        this.parent = parent;
    }

    public List<DepreciationMetaData> getDepreciationMetaDataList() {
        return this.depreciationMetaDataList;
    }

    public void setDepreciationMetaDataList(List<DepreciationMetaData> depreciationMetaDataList) {
        this.depreciationMetaDataList = depreciationMetaDataList;
    }

    public void addDepreciationMetaData(DepreciationMetaData depreciationMetaData) {
        this.depreciationMetaDataList.add(depreciationMetaData);
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    public String toString() {
        StringBuilder objString = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        String NULL_STRING = "null";
        objString.append(((Object)((Object)this)).getClass().getName() + " Object {" + NEW_LINE);
        objString.append(" Id: " + this.id + NEW_LINE);
        objString.append(" Name: " + this.name + NEW_LINE);
        objString.append(" Code: " + this.code + NEW_LINE);
        objString.append(" Asset Type: " + (this.assetType == null ? "null" : this.assetType.toString()) + NEW_LINE);
        objString.append(" Parent: " + (this.parent == null ? "null" : this.parent.getId()) + NEW_LINE);
        objString.append(" UOM: " + (this.uom == null ? "null" : this.uom.getId()) + NEW_LINE);
        objString.append("}");
        return objString.toString();
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errorList = new ArrayList<ValidationError>();
        if (this.depreciationMetaDataList != null && !this.depreciationMetaDataList.isEmpty()) {
            for (DepreciationMetaData depMetaData : this.depreciationMetaDataList) {
                errorList.addAll(depMetaData.validate());
            }
        }
        return errorList;
    }
}

