/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.egov.api.adapter.DataAdapter;
import org.egov.api.adapter.ForwardDetailsAdapter;
import org.egov.api.adapter.UserAdapter;
import org.egov.api.controller.core.ApiController;
import org.egov.api.controller.core.ApiResponse;
import org.egov.api.model.ForwardDetails;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationConstant;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.service.WorkflowTypeService;
import org.egov.infstr.services.EISServeable;
import org.egov.infstr.services.PersistenceService;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.Priority;
import org.egov.pgr.service.PriorityService;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1.0"})
public class EmployeeController
extends ApiController {
    public static final String EGOV_API_ERROR = "EGOV-API ERROR ";
    private static final Logger LOGGER = Logger.getLogger(EmployeeController.class);
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    @Qualifier(value="entityQueryService")
    private PersistenceService entityQueryService;
    @Autowired
    private WorkflowTypeService workflowTypeService;
    @Autowired
    private PositionMasterService posMasterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EISServeable eisService;
    @Autowired
    private PriorityService priorityService;

    @RequestMapping(value={"/employee/inbox"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getWorkFlowTypesWithItemsCount() {
        ApiResponse res = ApiResponse.newInstance();
        try {
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)this.getWorkflowTypesWithCount(this.securityUtils.getCurrentUser().getId(), this.posMasterService.getPositionsForEmployee(this.securityUtils.getCurrentUser().getId(), new Date()).parallelStream().map(position -> position.getId()).collect(Collectors.toList())));
        }
        catch (Exception ex) {
            LOGGER.error((Object)EGOV_API_ERROR, (Throwable)ex);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/inbox/{workFlowType}/{resultsFrom}/{resultsTo}"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getInboxListByWorkFlowType(@PathVariable String workFlowType, @PathVariable int resultsFrom, @PathVariable int resultsTo, @RequestParam(value="priority", required=false) String priority) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)this.createInboxData(this.getWorkflowItemsByUserAndWFType(this.securityUtils.getCurrentUser().getId(), this.posMasterService.getPositionsForEmployee(this.securityUtils.getCurrentUser().getId(), new Date()).parallelStream().map(position -> position.getId()).collect(Collectors.toList()), workFlowType, resultsFrom, resultsTo, priority)));
        }
        catch (Exception ex) {
            LOGGER.error((Object)EGOV_API_ERROR, (Throwable)ex);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/logout"}, method={RequestMethod.POST})
    public ResponseEntity<String> logout(OAuth2Authentication authentication) {
        try {
            OAuth2AccessToken token = this.tokenStore.getAccessToken(authentication);
            if (token == null) {
                return ApiResponse.newInstance().error(this.getMessage("msg.logout.unknown"));
            }
            this.tokenStore.removeAccessToken(token);
            return ApiResponse.newInstance().success((Object)"", this.getMessage("msg.logout.success"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)EGOV_API_ERROR, (Throwable)ex);
            return ApiResponse.newInstance().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/forwardDetails"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getForwardDetails(@RequestParam(value="department", required=true) Integer departmentId, @RequestParam(value="designation", required=false) Integer designationId) {
        try {
            ForwardDetails forwardDetails = new ForwardDetails();
            if (departmentId != null && designationId != null) {
                HashSet users = new HashSet();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("departmentId", String.valueOf(departmentId));
                paramMap.put("designationId", String.valueOf(designationId));
                List empViewList = this.eisService.getEmployeeInfoList(paramMap);
                empViewList.stream().forEach(user -> user.getEmployee().getRoles().stream().forEach(role -> {
                    if (role.getName().matches("Redressal Officer|Grievance Officer|Grievance Routing Officer")) {
                        users.add(user);
                    }
                }));
                forwardDetails.setUsers(users);
            } else if (departmentId != null) {
                forwardDetails.setDesignations(this.eisService.getAllDesignationByDept(departmentId, new Date()));
            }
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ForwardDetailsAdapter()).success((Object)forwardDetails);
        }
        catch (Exception e) {
            LOGGER.error((Object)EGOV_API_ERROR, (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    private JsonArray createInboxData(List<StateAware> inboxStates) {
        JsonArray inboxItems = new JsonArray();
        inboxStates.stream().sorted(Comparator.comparing(stateAware -> stateAware.getState().getCreatedDate()));
        Collections.reverse(inboxStates);
        for (StateAware stateAware2 : inboxStates) {
            inboxItems.add((JsonElement)new JsonParser().parse(stateAware2.getStateInfoJson()).getAsJsonObject());
        }
        return inboxItems;
    }

    public List<StateAware> getWorkflowItemsByUserAndWFType(Long userId, List<Long> owners, String workFlowType, int resultsFrom, int resultsTo, String priority) throws HibernateException, ClassNotFoundException {
        Criterion criterion = Restrictions.not((Criterion)Restrictions.conjunction().add((Criterion)Restrictions.eq((String)"state.status", (Object)State.StateStatus.STARTED)).add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)userId)));
        criterion = this.addPriorityCondition(criterion, priority);
        return this.entityQueryService.getSession().createCriteria(Class.forName(this.workflowTypeService.getEnabledWorkflowTypeByType(workFlowType).getTypeFQN())).setFirstResult(resultsFrom).setMaxResults(resultsTo).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).add((Criterion)Restrictions.eq((String)"state.type", (Object)workFlowType)).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.ne((String)"state.status", (Object)State.StateStatus.ENDED)).add(criterion).addOrder(Order.desc((String)"state.createdDate")).list();
    }

    public Number getWorkflowItemsCountByWFType(Long userId, List<Long> owners, String workFlowType, String priority) throws HibernateException, ClassNotFoundException {
        Criterion criterion = Restrictions.not((Criterion)Restrictions.conjunction().add((Criterion)Restrictions.eq((String)"state.status", (Object)State.StateStatus.STARTED)).add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)userId)));
        criterion = this.addPriorityCondition(criterion, priority);
        return (Number)this.entityQueryService.getSession().createCriteria(Class.forName(this.workflowTypeService.getEnabledWorkflowTypeByType(workFlowType).getTypeFQN())).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).setProjection(Projections.rowCount()).add((Criterion)Restrictions.eq((String)"state.type", (Object)workFlowType)).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.ne((String)"state.status", (Object)State.StateStatus.ENDED)).add(criterion).uniqueResult();
    }

    public List<HashMap<String, Object>> getWorkflowTypesWithCount(Long userId, List<Long> ownerPostitions) throws HibernateException, ClassNotFoundException {
        ArrayList<HashMap<String, Object>> workFlowTypesWithItemsCount = new ArrayList<HashMap<String, Object>>();
        Query query = this.entityQueryService.getSession().createQuery("select type, count(type) from State  where ownerPosition.id in (:ownerPositions) and status != :statusEnded and createdBy.id != :userId group by type");
        query.setParameterList("ownerPositions", ownerPostitions);
        query.setParameter("statusEnded", (Object)State.StateStatus.ENDED);
        query.setParameter("userId", (Object)userId);
        List result = query.list();
        LinkedHashMap<String, Long> prioritiesListCount = new LinkedHashMap<String, Long>();
        for (Object[] rowObj : result) {
            String workFlowTypeStr = String.valueOf(rowObj[0]);
            Long wftitemscount = (Long)this.getWorkflowItemsCountByWFType(userId, ownerPostitions, workFlowTypeStr, "");
            if (wftitemscount <= 0L) continue;
            HashMap<String, Object> workFlowType = new HashMap<String, Object>();
            WorkflowTypes workFlowTypeObj = this.workflowTypeService.getEnabledWorkflowTypeByType(workFlowTypeStr);
            workFlowType.put("workflowtype", workFlowTypeStr);
            workFlowType.put("inboxlistcount", wftitemscount);
            workFlowType.put("workflowtypename", workFlowTypeObj.getDisplayName());
            workFlowType.put("workflowgroupYN", workFlowTypeObj.isGrouped() ? ApplicationConstant.Y : ApplicationConstant.N);
            if (workFlowTypeStr.equals(Complaint.class.getSimpleName())) {
                for (Priority priority : this.priorityService.getAllPriorities()) {
                    prioritiesListCount.put(priority.getCode(), (Long)this.getWorkflowItemsCountByWFType(userId, ownerPostitions, workFlowTypeStr, priority.getCode()));
                }
                workFlowType.put("prioritylistcount", prioritiesListCount);
            }
            workFlowTypesWithItemsCount.add(workFlowType);
        }
        return workFlowTypesWithItemsCount;
    }

    private Criterion addPriorityCondition(Criterion existingCondition, String priority) {
        if (StringUtils.isNotBlank((String)priority)) {
            return Restrictions.conjunction((Criterion[])new Criterion[]{existingCondition}).add((Criterion)Restrictions.eq((String)"priority.id", (Object)this.priorityService.getPriorityByCode(priority).getId()));
        }
        return existingCondition;
    }
}

