/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller;

import com.google.gson.JsonObject;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.egov.api.controller.core.ApiController;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1.0"})
public class BoundaryController
extends ApiController {
    private static final Logger LOGGER = Logger.getLogger(BoundaryController.class);
    @Autowired
    private BoundaryService boundaryService;

    @RequestMapping(value={"/boundary/{lat}/{lng}"}, method={RequestMethod.GET})
    public ResponseEntity<String> getBoundaryDetails(@PathVariable Double lat, @PathVariable Double lng) {
        try {
            Optional boundary = this.boundaryService.getBoundary(lat, lng);
            if (boundary.isPresent()) {
                JsonObject boundaryJSON = new JsonObject();
                boundaryJSON.addProperty("BoundaryNumber", (Number)((Boundary)boundary.get()).getBoundaryNum());
                boundaryJSON.addProperty("BoundaryName", ((Boundary)boundary.get()).getName());
                return this.getResponseHandler().success((Object)boundaryJSON);
            }
            return this.getResponseHandler().error("Boundary Not Found");
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }
}

