/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.oauth2.provider;

import java.util.LinkedHashMap;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.security.authentication.userdetail.CurrentUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;

public class CustomTokenEnhancer
extends TokenEnhancerChain {
    @Autowired
    private CityService cityService;

    public OAuth2AccessToken enhance(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        DefaultOAuth2AccessToken token = (DefaultOAuth2AccessToken)accessToken;
        CurrentUser currentUser = (CurrentUser)authentication.getUserAuthentication().getPrincipal();
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("Id", currentUser.getUserId());
        info.put("name", currentUser.getUser().getName());
        info.put("mobileNumber", currentUser.getUser().getMobileNumber());
        info.put("emailId", currentUser.getUser().getEmailId());
        info.put("userType", currentUser.getUser().getType());
        info.put("cityLat", this.cityService.cityDataForKey("citylat") == null ? Integer.valueOf(0) : this.cityService.cityDataForKey("citylat"));
        info.put("cityLng", this.cityService.cityDataForKey("citylng") == null ? Integer.valueOf(0) : this.cityService.cityDataForKey("citylng"));
        token.setAdditionalInformation(info);
        return super.enhance((OAuth2AccessToken)token, authentication);
    }
}

