/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.egov.api.adapter.ComplaintActionAdapter;
import org.egov.api.adapter.ComplaintAdapter;
import org.egov.api.adapter.ComplaintStatusAdapter;
import org.egov.api.adapter.ComplaintTypeAdapter;
import org.egov.api.adapter.DataAdapter;
import org.egov.api.controller.core.ApiController;
import org.egov.api.model.ComplaintAction;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintStatus;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.egov.pgr.entity.ReceivingMode;
import org.egov.pgr.entity.enums.CitizenFeedback;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.ComplaintStatusMappingService;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.service.ComplaintTypeCategoryService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.PriorityService;
import org.egov.pgr.service.ReceivingModeService;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1.0"})
public class ComplaintController
extends ApiController {
    private static final Logger LOGGER = Logger.getLogger(ComplaintController.class);
    private static final String SATISFACTORY = "SATISFACTORY";
    private static final String UNSATISFACTORY = "UNSATISFACTORY";
    @Autowired
    protected ComplaintStatusService complaintStatusService;
    @Autowired
    protected ComplaintService complaintService;
    @Autowired
    protected ComplaintTypeCategoryService complaintTypeCategoryService;
    @Autowired
    protected ComplaintTypeService complaintTypeService;
    @Autowired
    protected CrossHierarchyService crossHierarchyService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;
    @Autowired
    protected ComplaintStatusMappingService complaintStatusMappingService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ReceivingModeService receivingModeService;
    @Autowired
    private PriorityService priorityService;

    @RequestMapping(value={"/complaint/getComplaintCategories"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getAllComplaintCategories() {
        try {
            List complaintCategories = this.complaintTypeCategoryService.findAll();
            JsonArray jAryComplaintCategories = new JsonArray();
            for (ComplaintTypeCategory complaintTypeCategory : complaintCategories) {
                JsonObject jComplaintCategory = new JsonObject();
                jComplaintCategory.addProperty("categoryId", (Number)complaintTypeCategory.getId());
                jComplaintCategory.addProperty("categoryName", complaintTypeCategory.getName());
                jComplaintCategory.addProperty("localName", complaintTypeCategory.getLocalName());
                List complaintTypes = this.complaintTypeService.findActiveComplaintTypesByCategory(complaintTypeCategory.getId());
                JsonArray jAryComplaintTypes = new JsonArray();
                for (ComplaintType complaintType : complaintTypes) {
                    JsonObject jComplaintType = new JsonObject();
                    jComplaintType.addProperty("id", (Number)complaintType.getId());
                    jComplaintType.addProperty("name", complaintType.getName());
                    jComplaintType.addProperty("description", complaintType.getDescription());
                    jComplaintType.addProperty("localName", complaintType.getLocalName());
                    jAryComplaintTypes.add((JsonElement)jComplaintType);
                }
                jComplaintCategory.add("complaintTypes", (JsonElement)jAryComplaintTypes);
                jAryComplaintCategories.add((JsonElement)jComplaintCategory);
            }
            JsonObject jresp = new JsonObject();
            jresp.add("complaintCategories", (JsonElement)jAryComplaintCategories);
            return this.getResponseHandler().success((Object)jresp);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/getAllTypes"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getAllTypes() {
        try {
            List complaintTypes = this.complaintTypeService.findActiveComplaintTypes();
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ComplaintTypeAdapter()).success((Object)complaintTypes);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/getFrequentlyFiledTypes"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getFrequentTypes() {
        try {
            List complaintTypes = this.complaintTypeService.getFrequentlyFiledComplaints();
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ComplaintTypeAdapter()).success((Object)complaintTypes);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/create"}, method={RequestMethod.POST})
    public ResponseEntity<String> complaintCreate(@RequestParam(value="json_complaint", required=false) String complaintJSON, @RequestParam(value="files") MultipartFile[] files) {
        try {
            ReceivingMode receivingMode;
            JSONObject complaintRequest = (JSONObject)JSONValue.parse((String)complaintJSON);
            Complaint complaint = new Complaint();
            if (this.securityUtils.currentUserType().equals((Object)UserType.EMPLOYEE)) {
                if (complaintRequest.containsKey((Object)"complainantName") && complaintRequest.containsKey((Object)"complainantMobileNo")) {
                    if (StringUtils.isEmpty((String)complaintRequest.get((Object)"complainantName").toString()) || StringUtils.isEmpty((String)complaintRequest.get((Object)"complainantMobileNo").toString())) {
                        return this.getResponseHandler().error(this.getMessage("msg.complaint.reg.failed.user"));
                    }
                    complaint.getComplainant().setName(complaintRequest.get((Object)"complainantName").toString());
                    complaint.getComplainant().setMobile(complaintRequest.get((Object)"complainantMobileNo").toString());
                    if (complaintRequest.containsKey((Object)"complainantEmail")) {
                        String email = complaintRequest.get((Object)"complainantEmail").toString();
                        if (!email.matches("^[A-Za-z0-9+_.-]+@(.+)$")) {
                            return this.getResponseHandler().error(this.getMessage("msg.invalid.mail"));
                        }
                        complaint.getComplainant().setEmail(email);
                    }
                } else if (!(complaintRequest.containsKey((Object)"complainantName") || complaintRequest.containsKey((Object)"complainantMobileNo") || complaintRequest.containsKey((Object)"complainantEmail"))) {
                    User currentUser = this.securityUtils.getCurrentUser();
                    complaint.getComplainant().setName(currentUser.getName());
                    complaint.getComplainant().setMobile(currentUser.getMobileNumber());
                    if (!StringUtils.isEmpty((String)currentUser.getEmailId())) {
                        complaint.getComplainant().setEmail(currentUser.getEmailId());
                    }
                } else {
                    return this.getResponseHandler().error(this.getMessage("msg.complaint.reg.failed.user"));
                }
            }
            long complaintTypeId = (Long)complaintRequest.get((Object)"complaintTypeId");
            if (complaintRequest.get((Object)"locationId") != null && (Long)complaintRequest.get((Object)"locationId") > 0L) {
                long locationId = (Long)complaintRequest.get((Object)"locationId");
                CrossHierarchy crosshierarchy = this.crossHierarchyService.findById(Long.valueOf(locationId));
                complaint.setLocation(crosshierarchy.getParent());
                complaint.setChildLocation(crosshierarchy.getChild());
            }
            if (complaintRequest.get((Object)"lng") != null && (Double)complaintRequest.get((Object)"lng") > 0.0) {
                double lng = (Double)complaintRequest.get((Object)"lng");
                complaint.setLng(lng);
            }
            if (complaintRequest.get((Object)"lat") != null && (Double)complaintRequest.get((Object)"lat") > 0.0) {
                double lat = (Double)complaintRequest.get((Object)"lat");
                complaint.setLat(lat);
            }
            if (complaint.getLocation() == null && (complaint.getLat() == 0.0 || complaint.getLng() == 0.0)) {
                return this.getResponseHandler().error(this.getMessage("location.required"));
            }
            complaint.setDetails(complaintRequest.get((Object)"details").toString());
            complaint.setLandmarkDetails(complaintRequest.get((Object)"landmarkDetails").toString());
            if (complaintTypeId > 0L) {
                ComplaintType complaintType = this.complaintTypeService.findBy(Long.valueOf(complaintTypeId));
                complaint.setComplaintType(complaintType);
            }
            String receivingModeKey = "receivingMode";
            String[] highPriorityComplaintSource = new String[]{"VMC", "TLC", "DRONE"};
            String priorityCode = "NORMAL";
            if (complaintRequest.get((Object)receivingModeKey) != null && org.egov.infra.utils.StringUtils.isNotBlank((String)complaintRequest.get((Object)receivingModeKey).toString())) {
                String receivingModeVal = complaintRequest.get((Object)receivingModeKey).toString();
                receivingMode = this.receivingModeService.getReceivingModeByCode(receivingModeVal);
                if (Arrays.asList(highPriorityComplaintSource).contains(receivingModeVal)) {
                    priorityCode = "HIGH";
                }
            } else {
                receivingMode = this.receivingModeService.getReceivingModeByCode("MOBILE");
            }
            if (receivingMode == null) {
                return this.getResponseHandler().error(this.getMessage("msg.invalid.receiving.mode"));
            }
            complaint.setPriority(this.priorityService.getPriorityByCode(priorityCode));
            complaint.setReceivingMode(receivingMode);
            if (files.length > 0) {
                complaint.setSupportDocs(this.addToFileStore(files));
            }
            this.complaintService.createComplaint(complaint);
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ComplaintAdapter()).success((Object)complaint, this.getMessage("msg.complaint.reg.success"));
        }
        catch (ValidationException e) {
            return this.getResponseHandler().error(this.getMessage(e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    protected Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "PGR");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("err.input.stream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return null;
    }

    @RequestMapping(value={"/complaint/{complaintNo}/uploadSupportDocument"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadSupportDocs(@PathVariable String complaintNo, @RequestParam(value="files") MultipartFile file) {
        try {
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            FileStoreMapper uploadFile = this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "PGR");
            complaint.getSupportDocs().add(uploadFile);
            this.complaintService.update(complaint, null, null);
            return this.getResponseHandler().success((Object)"", this.getMessage("msg.complaint.update.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/{complaintNo}/detail"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getDetail(@PathVariable String complaintNo) {
        try {
            if (complaintNo == null) {
                return this.getResponseHandler().error("Invalid number");
            }
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            if (complaint == null) {
                return this.getResponseHandler().error("no complaint information");
            }
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ComplaintAdapter()).success((Object)complaint);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/{complaintNo}/status"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getStatus(@PathVariable String complaintNo) {
        try {
            if (complaintNo == null) {
                return this.getResponseHandler().error("Invalid number");
            }
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            if (complaint == null) {
                return this.getResponseHandler().error("no complaint information");
            }
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ComplaintStatusAdapter()).success((Object)complaint.getStateHistory());
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/latest/{page}/{pageSize}"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getLatest(@PathVariable(value="page") int page, @PathVariable(value="pageSize") int pageSize) {
        if (page < 1) {
            return this.getResponseHandler().error("Invalid Page Number");
        }
        try {
            Page pagelist = this.complaintService.getLatest(page, pageSize);
            boolean hasNextPage = pagelist.getTotalElements() > (long)(page * pageSize);
            return this.getResponseHandler().putStatusAttribute("hasNextPage", String.valueOf(hasNextPage)).setDataAdapter((DataAdapter)new ComplaintAdapter()).success((Object)pagelist.getContent());
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/getLocation"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getLocation(@RequestParam(value="locationName") String locationName) {
        try {
            if (locationName == null || locationName.isEmpty() || locationName.length() < 3) {
                return this.getResponseHandler().error(this.getMessage("location.search.invalid"));
            }
            List list = this.boundaryService.getBoundaryDataByNameLike(locationName);
            return this.getResponseHandler().success((Object)list);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/count"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getComplaintsTotalCount() {
        try {
            return this.getResponseHandler().success((Object)this.complaintService.getComplaintsTotalCount());
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/citizen/getMyComplaint/count"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getComplaintsCount() {
        try {
            return this.getResponseHandler().success((Object)this.complaintService.getMyComplaintsCount());
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/citizen/getMyComplaint/{page}/{pageSize}"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getMyComplaint(@PathVariable(value="page") int page, @PathVariable(value="pageSize") int pageSize, @RequestParam(value="complaintStatus", required=false) String complaintStatus) {
        if (page < 1) {
            return this.getResponseHandler().error("Invalid Page Number");
        }
        try {
            Page pagelist = null;
            boolean hasNextPage = false;
            if (StringUtils.isEmpty((String)complaintStatus) || complaintStatus.equals("ALL")) {
                pagelist = this.complaintService.getMyComplaint(page, pageSize);
                hasNextPage = pagelist.getTotalElements() > (long)(page * pageSize);
            } else if (complaintStatus.equals("PENDING")) {
                pagelist = this.complaintService.getMyPendingGrievances(page, pageSize);
                hasNextPage = pagelist.getTotalElements() > (long)(page * pageSize);
            } else if (complaintStatus.equals("COMPLETED")) {
                pagelist = this.complaintService.getMyCompletedGrievances(page, pageSize);
                hasNextPage = pagelist.getTotalElements() > (long)(page * pageSize);
            } else if (complaintStatus.equals("REJECTED")) {
                pagelist = this.complaintService.getMyRejectedGrievances(page, pageSize);
                boolean bl = hasNextPage = pagelist.getTotalElements() > (long)(page * pageSize);
            }
            if (pagelist != null) {
                return this.getResponseHandler().putStatusAttribute("hasNextPage", String.valueOf(hasNextPage)).setDataAdapter((DataAdapter)new ComplaintAdapter()).success((Object)pagelist.getContent());
            }
            return this.getResponseHandler().error("Invalid Complaint Status!");
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/nearby/{page}/{pageSize}"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getNearByComplaint(@PathVariable(value="page") int page, @RequestParam(value="lat") float lat, @RequestParam(value="lng") float lng, @RequestParam(value="distance") int distance, @PathVariable(value="pageSize") int pageSize) {
        if (page < 1) {
            return this.getResponseHandler().error("Invalid Page Number");
        }
        try {
            List list = this.complaintService.getNearByComplaint(page, lat, lng, distance, pageSize);
            boolean hasNextPage = false;
            if (list.size() > pageSize) {
                hasNextPage = true;
                list.remove(pageSize);
            }
            return this.getResponseHandler().putStatusAttribute("hasNextPage", String.valueOf(hasNextPage)).setDataAdapter((DataAdapter)new ComplaintAdapter()).success((Object)list);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/{complaintNo}/downloadSupportDocument"}, method={RequestMethod.GET})
    public void getComplaintDoc(@PathVariable String complaintNo, @RequestParam(value="fileNo", required=false) Long fileNo, @RequestParam(value="isThumbnail", required=false, defaultValue="false") boolean isThumbnail, HttpServletResponse response) throws IOException {
        try {
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            Set files = complaint.getSupportDocs();
            int i = 1;
            Iterator it = files.iterator();
            if (fileNo == null) {
                fileNo = files.size();
            }
            File downloadFile = null;
            while (it.hasNext()) {
                FileStoreMapper fm = (FileStoreMapper)it.next();
                if ((long)i == fileNo) {
                    downloadFile = this.fileStoreService.fetch(fm.getFileStoreId(), "PGR");
                    ByteArrayOutputStream thumbImg = new ByteArrayOutputStream();
                    long contentLength = downloadFile.length();
                    if (isThumbnail) {
                        BufferedImage img = Thumbnails.of((File[])new File[]{downloadFile}).size(200, 200).asBufferedImage();
                        ImageIO.write((RenderedImage)img, "jpg", thumbImg);
                        thumbImg.close();
                        contentLength = thumbImg.size();
                    }
                    response.setHeader("Content-Length", String.valueOf(contentLength));
                    response.setHeader("Content-Disposition", "attachment;filename=" + fm.getFileName());
                    response.setContentType(Files.probeContentType(downloadFile.toPath()));
                    ServletOutputStream out = response.getOutputStream();
                    IOUtils.write((byte[])(isThumbnail ? thumbImg.toByteArray() : FileUtils.readFileToByteArray((File)downloadFile)), (OutputStream)out);
                    IOUtils.closeQuietly((OutputStream)out);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            throw new IOException();
        }
    }

    @RequestMapping(value={"/complaint/downloadfile/{fileStoreId}"})
    public void download(@PathVariable String fileStoreId, HttpServletResponse response) throws IOException {
        this.fileStoreUtils.fetchFileAndWriteToStream(fileStoreId, "PGR", false, response);
    }

    @RequestMapping(value={"/complaint/{complaintNo}/updateStatus"}, method={RequestMethod.PUT}, produces={"text/plain"})
    public ResponseEntity<String> updateComplaintStatus(@PathVariable String complaintNo, @RequestBody JSONObject jsonData) {
        try {
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            ComplaintStatus cmpStatus = this.complaintStatusService.getByName(jsonData.get((Object)"action").toString());
            String citizenfeedback = jsonData.get((Object)"feedback").toString();
            if (complaint.getStatus().getName().equals("COMPLETED")) {
                if (UNSATISFACTORY.equals(citizenfeedback)) {
                    citizenfeedback = CitizenFeedback.TWO.name();
                } else if (SATISFACTORY.equals(citizenfeedback)) {
                    citizenfeedback = CitizenFeedback.FIVE.name();
                }
                complaint.setCitizenFeedback(CitizenFeedback.valueOf((String)citizenfeedback));
            }
            complaint.setStatus(cmpStatus);
            this.complaintService.update(complaint, Long.valueOf(0L), jsonData.get((Object)"comment").toString());
            return this.getResponseHandler().success((Object)"", this.getMessage("msg.complaint.status.update.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/complaint/{complaintNo}/complaintHistory"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getComplaintHistory(@PathVariable String complaintNo) {
        try {
            HashMap<String, List> container = new HashMap<String, List>();
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            List list = this.complaintService.getHistory(complaint);
            container.put("comments", list);
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ComplaintTypeAdapter()).success(container);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/complaint/{complaintNo}/complaintActions"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getComplaintActions(@PathVariable String complaintNo) {
        try {
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            ComplaintAction complaintActions = new ComplaintAction();
            complaintActions.setStatus(this.complaintStatusMappingService.getStatusByRoleAndCurrentStatus(this.securityUtils.getCurrentUser().getRoles(), complaint.getStatus()));
            complaintActions.setApprovalDepartments(this.departmentService.getAllDepartments());
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ComplaintActionAdapter()).success((Object)complaintActions);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/complaint/update/{complaintNo}"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ResponseEntity<String> updateComplaintFromEmployee(@PathVariable String complaintNo, @RequestParam(value="jsonParams", required=false) String complaintJsonStr, @RequestParam(value="files") MultipartFile[] files) {
        try {
            JsonObject complaintJson = new JsonParser().parse(complaintJsonStr).getAsJsonObject();
            Complaint complaint = this.complaintService.getComplaintByCRN(complaintNo);
            ComplaintStatus cmpStatus = this.complaintStatusService.getByName(complaintJson.get("action").getAsString());
            String keyApprovalPosition = "approvalposition";
            complaint.setStatus(cmpStatus);
            Long approvalPosition = 0L;
            if (complaintJson.has("approvalposition")) {
                approvalPosition = Long.valueOf(complaintJson.get("approvalposition").getAsString());
            }
            if (files.length > 0) {
                complaint.getSupportDocs().addAll(this.addToFileStore(files));
            }
            this.complaintService.update(complaint, approvalPosition, complaintJson.get("comment").getAsString());
            return this.getResponseHandler().success((Object)"", this.getMessage("msg.complaint.status.update.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }
}

