/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.egov.api.adapter.DataAdapter;
import org.egov.api.adapter.UserAdapter;
import org.egov.api.controller.core.ApiController;
import org.egov.api.controller.core.ApiResponse;
import org.egov.infra.admin.common.service.IdentityRecoveryService;
import org.egov.infra.admin.master.entity.Device;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.repository.DeviceRepository;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.portal.entity.Citizen;
import org.egov.portal.service.CitizenService;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1.0"})
public class CommonController
extends ApiController {
    private static final Logger LOGGER = Logger.getLogger(CommonController.class);
    @Autowired
    private CitizenService citizenService;
    @Autowired
    private DeviceRepository deviceRepository;
    @Autowired
    private IdentityRecoveryService identityRecoveryService;
    @Autowired
    private LocalValidatorFactoryBean validator;
    @Autowired
    private UserService userservice;
    @Autowired
    private SecurityUtils securityUtils;

    @RequestMapping(value={"/createCitizen"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<String> register(@RequestBody JSONObject citizen) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            User getUser;
            User user;
            Citizen citizenCreate = new Citizen();
            citizenCreate.setUsername(citizen.get((Object)"mobileNumber").toString());
            citizenCreate.setMobileNumber(citizen.get((Object)"mobileNumber").toString());
            citizenCreate.setName(citizen.get((Object)"name").toString());
            if (citizen.get((Object)"emailId") != null && !citizen.get((Object)"emailId").toString().trim().equals("")) {
                citizenCreate.setEmailId(citizen.get((Object)"emailId").toString());
            }
            citizenCreate.setPassword(citizen.get((Object)"password").toString());
            Device device = this.deviceRepository.findByDeviceUId(citizen.get((Object)"deviceId").toString());
            if (device == null) {
                device = new Device();
                device.setDeviceId(citizen.get((Object)"deviceId").toString());
                device.setType(citizen.get((Object)"deviceType").toString());
                device.setOSVersion(citizen.get((Object)"OSVersion").toString());
            }
            if ((user = this.userservice.getUserByUsername(citizenCreate.getMobileNumber())) != null) {
                return res.error(this.getMessage("user.register.duplicate.mobileno"));
            }
            if (citizenCreate.getEmailId() != null && !citizenCreate.getEmailId().isEmpty() && (getUser = this.userservice.getUserByEmailId(citizenCreate.getEmailId())) != null) {
                return res.error(this.getMessage("user.register.duplicate.email"));
            }
            if (citizen.get((Object)"activationCode") != null && this.citizenService.isValidOTP(citizen.get((Object)"activationCode").toString(), citizen.get((Object)"mobileNumber").toString())) {
                citizenCreate.setActive(true);
                citizenCreate.getDevices().add(device);
                this.citizenService.create(citizenCreate);
                return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)citizenCreate, this.getMessage("msg.citizen.reg.success"));
            }
            return res.error(this.getMessage("msg.pwd.otp.invalid"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/activateCitizen"}, method={RequestMethod.POST})
    public ResponseEntity<String> activate(@RequestParam(value="userName") String userName, @RequestParam(value="activationCode") String activationCode) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            Citizen citizen = this.citizenService.getCitizenByUserName(userName);
            if (citizen == null) {
                citizen = this.citizenService.getCitizenByEmailId(userName);
            }
            if (citizen == null) {
                return res.error(this.getMessage("citizen.not.found"));
            }
            if (activationCode == null) {
                return res.error(this.getMessage("citizen.valid.activationCode"));
            }
            if (citizen.isActive()) {
                return res.success((Object)"", this.getMessage("citizen.activated"));
            }
            if (citizen.getActivationCode().equals(activationCode)) {
                citizen.setActive(true);
                this.citizenService.update(citizen);
                return res.success((Object)"", this.getMessage("citizen.success.activated"));
            }
            return res.error(this.getMessage("citizen.valid.activationCode"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/recoverPassword"}, method={RequestMethod.POST})
    public ResponseEntity<String> passwordRecover(HttpServletRequest request) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            Citizen citizen;
            String identity = request.getParameter("identity");
            String redirectURL = request.getParameter("redirectURL");
            String token = request.getParameter("token");
            if (StringUtils.isEmpty((String)identity)) {
                return res.error(this.getMessage("msg.invalid.request"));
            }
            if (!StringUtils.isEmpty((String)token)) {
                String newPassword = request.getParameter("newPassword");
                String confirmPassword = request.getParameter("confirmPassword");
                if (StringUtils.isEmpty((String)newPassword)) {
                    return res.error(this.getMessage("msg.invalid.request"));
                }
                if (!newPassword.equals(confirmPassword)) {
                    return res.error(this.getMessage("msg.pwd.not.match"));
                }
                if (this.identityRecoveryService.validateAndResetPassword(token, newPassword)) {
                    return res.success((Object)"", this.getMessage("msg.pwd.reset.success"));
                }
                return res.error(this.getMessage("msg.pwd.otp.invalid"));
            }
            if (identity.matches("\\d+")) {
                if (!identity.matches("\\d{10}")) {
                    return res.error(this.getMessage("msg.invalid.mobileno"));
                }
            } else if (!identity.matches("^[A-Za-z0-9+_.-]+@(.+)$")) {
                return res.error(this.getMessage("msg.invalid.mail"));
            }
            if ((citizen = this.citizenService.getCitizenByUserName(identity)) == null) {
                return res.error(this.getMessage("user.not.found"));
            }
            if (this.identityRecoveryService.generateAndSendUserPasswordRecovery(identity, redirectURL + "/egi/login/password/reset?token=", true)) {
                return res.success((Object)"", "OTP for recovering password has been sent to your mobile" + (StringUtils.isEmpty((String)citizen.getEmailId()) ? "" : " and mail"));
            }
            return res.error("Password send failed");
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/sendOTP"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> sendOTP(HttpServletRequest request) {
        ApiResponse res = ApiResponse.newInstance();
        String mobileNo = request.getParameter("identity");
        try {
            if (!mobileNo.matches("\\d{10}")) {
                return res.error(this.getMessage("msg.invalid.mobileno"));
            }
            this.citizenService.sendOTPMessage(mobileNo);
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)this.getMessage("sendOTP.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/addDeviceLog"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> deviceLog(HttpServletRequest request) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            User currentUser = this.securityUtils.getCurrentUser();
            if (currentUser == null) {
                return res.error(this.getMessage("user.not.found"));
            }
            String deviceId = request.getParameter("deviceId");
            String deviceType = request.getParameter("deviceType");
            String deviceOS = request.getParameter("OSVersion");
            Device device = this.deviceRepository.findByDeviceUId(deviceId);
            if (device == null) {
                device = new Device();
                device.setDeviceId(deviceId);
            }
            device.setType(deviceType);
            device.setOSVersion(deviceOS);
            device.setLastModifiedDate(new Date());
            this.deviceRepository.save((Object)device);
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)this.getMessage("log.success"), this.getMessage("log.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }
}

