/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.egov.api.adapter.DataAdapter;
import org.egov.api.adapter.ForwardDetailsAdapter;
import org.egov.api.adapter.UserAdapter;
import org.egov.api.controller.core.ApiController;
import org.egov.api.controller.core.ApiResponse;
import org.egov.api.model.ComplaintSearchRequest;
import org.egov.api.model.ForwardDetails;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderService;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.egov.infstr.services.EISServeable;
import org.egov.infstr.services.PersistenceService;
import org.egov.pgr.service.ComplaintService;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.elasticsearch.search.sort.SortOrder;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1.0"})
public class EmployeeController
extends ApiController {
    private static final Logger LOGGER = Logger.getLogger(EmployeeController.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy hh:mm a");
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private PersistenceService<State, Long> statePersistenceService;
    @Autowired
    private PersistenceService<WorkflowTypes, Long> workflowTypePersistenceService;
    @Autowired
    private PositionMasterService posMasterService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    InboxRenderServiceDeligate<StateAware> inboxRenderServiceDelegate;
    @Autowired
    private ComplaintService complaintService;
    @Autowired
    private EISServeable eisService;

    @RequestMapping(value={"/employee/inbox"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getWorkFlowTypesWithItemsCount(HttpServletRequest request) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            ArrayList<Long> ownerpostitions = new ArrayList<Long>();
            ownerpostitions.add(this.posMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId()).getId());
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)this.getWorkflowTypesWithCount(this.securityUtils.getCurrentUser().getId(), ownerpostitions));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)ex);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/inbox/{workFlowType}/{resultsFrom}/{resultsTo}"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getInboxListByWorkFlowType(@PathVariable String workFlowType, @PathVariable int resultsFrom, @PathVariable int resultsTo) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            ArrayList<Long> ownerpostitions = new ArrayList<Long>();
            ownerpostitions.add(this.posMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId()).getId());
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)this.createInboxData(this.getWorkflowItemsByUserAndWFType(this.securityUtils.getCurrentUser().getId(), ownerpostitions, workFlowType, resultsFrom, resultsTo)));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)ex);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/inbox/search/{pageno}/{limit}"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ResponseEntity<String> searchEmployeeInbox(@PathVariable Integer pageno, @PathVariable Integer limit, @RequestBody ComplaintSearchRequest searchRequest) {
        try {
            Page page = Page.at((int)pageno);
            page.ofSize(limit.intValue());
            SearchResult searchResult = this.searchService.search(Arrays.asList(Index.PGR.toString()), Arrays.asList(IndexType.COMPLAINT.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), Sort.by().field("common.createdDate", SortOrder.DESC), page);
            String jsonString = searchResult.rawResponse();
            JSONObject respObj = (JSONObject)new JSONParser().parse(jsonString);
            JSONObject jObjHits = (JSONObject)respObj.get((Object)"hits");
            Long total = (Long)jObjHits.get((Object)"total");
            boolean hasNextPage = total > (long)(pageno * limit);
            ArrayList<Document> inboxItems = new ArrayList<Document>();
            for (Document document : searchResult.getDocuments()) {
                JSONObject jResourceObj = document.getResource();
                LinkedHashMap jSearchableObj = (LinkedHashMap)jResourceObj.get((Object)"searchable");
                LinkedHashMap jOwnerObj = (LinkedHashMap)jSearchableObj.get("owner");
                if ((long)((Integer)jOwnerObj.get("id")).intValue() != this.posMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId()).getId()) continue;
                inboxItems.add(document);
            }
            JsonArray result = (JsonArray)new Gson().toJsonTree(inboxItems, new /* Unavailable Anonymous Inner Class!! */.getType());
            JsonObject jsonResp = new JsonObject();
            jsonResp.add("searchItems", (JsonElement)result);
            jsonResp.addProperty("hasNextPage", Boolean.valueOf(hasNextPage));
            return this.getResponseHandler().success((Object)jsonResp);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/logout"}, method={RequestMethod.POST})
    public ResponseEntity<String> logout(HttpServletRequest request, OAuth2Authentication authentication) {
        try {
            OAuth2AccessToken token = this.tokenStore.getAccessToken(authentication);
            if (token == null) {
                return ApiResponse.newInstance().error(this.getMessage("msg.logout.unknown"));
            }
            this.tokenStore.removeAccessToken(token);
            return ApiResponse.newInstance().success((Object)"", this.getMessage("msg.logout.success"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)ex);
            return ApiResponse.newInstance().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/employee/forwardDetails"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getForwardDetails(@RequestParam(value="department", required=true) Integer departmentId, @RequestParam(value="designation", required=false) Integer designationId) {
        try {
            ForwardDetails forwardDetails = new ForwardDetails();
            if (departmentId != null && designationId != null) {
                HashSet users = new HashSet();
                this.eisService.getUsersByDeptAndDesig(departmentId, designationId, new Date()).stream().forEach(user -> user.getRoles().stream().forEach(role -> {
                    if (role.getName().matches("Redressal Officer|Grievance Officer|Grievance Routing Officer")) {
                        users.add(user);
                    }
                }));
                forwardDetails.setUsers(users);
            } else if (departmentId != null) {
                forwardDetails.setDesignations(this.eisService.getAllDesignationByDept(departmentId, new Date()));
            }
            return this.getResponseHandler().setDataAdapter((DataAdapter)new ForwardDetailsAdapter()).success((Object)forwardDetails);
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return this.getResponseHandler().error(this.getMessage("server.error"));
        }
    }

    private JsonArray createInboxData(List<StateAware> inboxStates) {
        JsonArray inboxItems = new JsonArray();
        inboxStates.sort(StateAware.byCreatedDate());
        for (StateAware stateAware : inboxStates) {
            inboxItems.add((JsonElement)new JsonParser().parse(stateAware.getStateInfoJson()).getAsJsonObject());
        }
        return inboxItems;
    }

    public List<StateAware> getWorkflowItemsByUserAndWFType(Long userId, List<Long> owners, String workFlowType, int resultsFrom, int resultsTo) throws HibernateException, ClassNotFoundException {
        return this.statePersistenceService.getSession().createCriteria(Class.forName(this.getWorkflowType(workFlowType).getTypeFQN())).setFirstResult(resultsFrom).setMaxResults(resultsTo).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).add((Criterion)Restrictions.eq((String)"state.type", (Object)workFlowType)).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.ne((String)"state.status", (Object)State.StateStatus.ENDED)).add(Restrictions.not((Criterion)Restrictions.conjunction().add((Criterion)Restrictions.eq((String)"state.status", (Object)State.StateStatus.STARTED)).add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)userId)))).addOrder(Order.desc((String)"state.createdDate")).list();
    }

    public Number getWorkflowItemsCountByWFType(Long userId, List<Long> owners, String workFlowType) throws HibernateException, ClassNotFoundException {
        return (Number)this.statePersistenceService.getSession().createCriteria(Class.forName(this.getWorkflowType(workFlowType).getTypeFQN())).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).setProjection(Projections.rowCount()).add((Criterion)Restrictions.eq((String)"state.type", (Object)workFlowType)).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.ne((String)"state.status", (Object)State.StateStatus.ENDED)).add(Restrictions.not((Criterion)Restrictions.conjunction().add((Criterion)Restrictions.eq((String)"state.status", (Object)State.StateStatus.STARTED)).add((Criterion)Restrictions.eq((String)"createdBy.id", (Object)userId)))).uniqueResult();
    }

    public List<HashMap<String, Object>> getWorkflowTypesWithCount(Long userId, List<Long> ownerPostitions) throws HibernateException, ClassNotFoundException {
        ArrayList<HashMap<String, Object>> workFlowTypesWithItemsCount = new ArrayList<HashMap<String, Object>>();
        Query query = this.workflowTypePersistenceService.getSession().createQuery("select type, count(type) from State  where ownerPosition.id in (:ownerPositions) and status != :statusEnded and createdBy.id != :userId group by type");
        query.setParameterList("ownerPositions", ownerPostitions);
        query.setParameter("statusEnded", (Object)State.StateStatus.ENDED);
        query.setParameter("userId", (Object)userId);
        List result = query.list();
        for (Object[] rowObj : result) {
            Long wftitemscount = (Long)this.getWorkflowItemsCountByWFType(userId, ownerPostitions, String.valueOf(rowObj[0]));
            if (wftitemscount <= 0L) continue;
            HashMap<String, Object> workFlowType = new HashMap<String, Object>();
            WorkflowTypes workFlowTypeObj = this.getWorkflowType(String.valueOf(rowObj[0]));
            workFlowType.put("workflowtype", rowObj[0]);
            workFlowType.put("inboxlistcount", wftitemscount);
            workFlowType.put("workflowtypename", workFlowTypeObj.getDisplayName());
            workFlowType.put("workflowgroupYN", workFlowTypeObj.getGroupYN());
            workFlowTypesWithItemsCount.add(workFlowType);
        }
        return workFlowTypesWithItemsCount;
    }

    @Transactional(readOnly=true)
    public WorkflowTypes getWorkflowType(String wfType) {
        WorkflowTypes workflowType = (WorkflowTypes)this.workflowTypePersistenceService.getSession().createCriteria(WorkflowTypes.class).add((Criterion)Restrictions.eq((String)"renderYN", (Object)InboxRenderService.RENDER_Y)).add((Criterion)Restrictions.eq((String)"type", (Object)wfType)).setReadOnly(true).uniqueResult();
        return workflowType;
    }
}

