/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.egov.api.adapter.DataAdapter;
import org.egov.api.adapter.UserAdapter;
import org.egov.api.controller.core.ApiController;
import org.egov.api.controller.core.ApiResponse;
import org.egov.infra.admin.common.service.IdentityRecoveryService;
import org.egov.infra.admin.master.entity.Device;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.repository.DeviceRepository;
import org.egov.infra.admin.master.service.UserService;
import org.egov.portal.entity.Citizen;
import org.egov.portal.service.CitizenService;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1.0"})
public class CommonController
extends ApiController {
    private static final Logger LOGGER = Logger.getLogger(CommonController.class);
    @Autowired
    private CitizenService citizenService;
    @Autowired
    private DeviceRepository deviceRepository;
    @Autowired
    private IdentityRecoveryService identityRecoveryService;
    @Autowired
    private LocalValidatorFactoryBean validator;
    @Autowired
    private UserService userservice;

    @RequestMapping(value={"/createCitizen"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<String> register(@RequestBody JSONObject citizen) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            User getUser;
            Citizen citizenCreate = new Citizen();
            citizenCreate.setUsername(citizen.get((Object)"mobileNumber").toString());
            citizenCreate.setMobileNumber(citizen.get((Object)"mobileNumber").toString());
            citizenCreate.setName(citizen.get((Object)"name").toString());
            citizenCreate.setEmailId(citizen.get((Object)"emailId").toString());
            citizenCreate.setPassword(citizen.get((Object)"password").toString());
            Device device = this.deviceRepository.findByDeviceUId(citizen.get((Object)"deviceId").toString());
            if (device == null) {
                device = new Device();
                device.setDeviceId(citizen.get((Object)"deviceId").toString());
                device.setType(citizen.get((Object)"deviceType").toString());
                device.setOSVersion(citizen.get((Object)"OSVersion").toString());
            }
            if ((getUser = this.userservice.getUserByMobileNumber(citizenCreate.getMobileNumber())) != null) {
                return res.error(this.getMessage("user.register.duplicate.mobileno"));
            }
            if (citizenCreate.getEmailId() != null && !citizenCreate.getEmailId().isEmpty() && (getUser = this.userservice.getUserByEmailId(citizenCreate.getEmailId())) != null) {
                return res.error(this.getMessage("user.register.duplicate.email"));
            }
            citizenCreate.getDevices().add(device);
            this.citizenService.create(citizenCreate);
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)citizenCreate, this.getMessage("msg.citizen.reg.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/activateCitizen"}, method={RequestMethod.POST})
    public ResponseEntity<String> activate(@RequestParam(value="userName") String userName, @RequestParam(value="activationCode") String activationCode) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            Citizen citizen = this.citizenService.getCitizenByUserName(userName);
            if (citizen == null) {
                citizen = this.citizenService.getCitizenByEmailId(userName);
            }
            if (citizen == null) {
                return res.error(this.getMessage("citizen.not.found"));
            }
            if (activationCode == null) {
                return res.error(this.getMessage("citizen.valid.activationCode"));
            }
            if (citizen.isActive()) {
                return res.success((Object)"", this.getMessage("citizen.activated"));
            }
            if (citizen.getActivationCode().equals(activationCode)) {
                citizen.setActive(true);
                this.citizenService.update(citizen);
                return res.success((Object)"", this.getMessage("citizen.success.activated"));
            }
            return res.error(this.getMessage("citizen.valid.activationCode"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/recoverPassword"}, method={RequestMethod.POST})
    public ResponseEntity<String> passwordRecover(HttpServletRequest request) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            String identity = request.getParameter("identity");
            String redirectURL = request.getParameter("redirectURL");
            if (identity == null || !identity.matches("\\d{10}")) {
                return res.error("Invalid mobile number");
            }
            Citizen citizen = this.citizenService.getCitizenByUserName(identity);
            if (citizen == null) {
                return res.error(this.getMessage("user.not.found"));
            }
            if (this.identityRecoveryService.generateAndSendUserPasswordRecovery(identity, redirectURL + "/egi/login/password/reset?token=")) {
                return res.success((Object)"", "Password has been sent to mail");
            }
            return res.error("Password send failed");
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/sendOTP"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> sendOTP(HttpServletRequest request) {
        ApiResponse res = ApiResponse.newInstance();
        String identity = request.getParameter("identity");
        String msg = "";
        Citizen citizen = null;
        try {
            if (identity.matches("\\d{10}")) {
                citizen = this.citizenService.getCitizenByUserName(identity);
            } else if (identity.contains("@") && identity.contains(".")) {
                citizen = this.citizenService.getCitizenByEmailId(identity);
            }
            if (citizen == null) {
                return res.error(this.getMessage("user.not.found"));
            }
            this.citizenService.sendActivationMessage(citizen);
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)citizen, this.getMessage("sendOTP.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return res.error(this.getMessage("server.error"));
        }
    }
}

