/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.egov.api.adapter.DataAdapter;
import org.egov.api.adapter.UserAdapter;
import org.egov.api.controller.core.ApiController;
import org.egov.api.controller.core.ApiResponse;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.portal.entity.Citizen;
import org.egov.portal.service.CitizenService;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1.0"})
public class CitizenController
extends ApiController {
    private static final Logger LOGGER = Logger.getLogger(CitizenController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private CitizenService citizenService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private TokenStore tokenStore;

    @RequestMapping(value={"/citizen/getProfile"}, method={RequestMethod.GET}, produces={"text/plain"})
    public ResponseEntity<String> getProfle(HttpServletRequest request) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            User user = this.userService.getUserByUsername(this.securityUtils.getCurrentUser().getUsername());
            if (user == null) {
                return res.error(this.getMessage("user.not.found"));
            }
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)user);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)ex);
            return res.error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/citizen/logout"}, method={RequestMethod.POST})
    public ResponseEntity<String> logout(HttpServletRequest request, OAuth2Authentication authentication) {
        try {
            OAuth2AccessToken token = this.tokenStore.getAccessToken(authentication);
            if (token == null) {
                return ApiResponse.newInstance().error(this.getMessage("msg.logout.unknown"));
            }
            this.tokenStore.removeAccessToken(token);
            return ApiResponse.newInstance().success((Object)"", this.getMessage("msg.logout.success"));
        }
        catch (Exception ex) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)ex);
            return ApiResponse.newInstance().error(this.getMessage("server.error"));
        }
    }

    @RequestMapping(value={"/citizen/updateProfile"}, method={RequestMethod.PUT}, consumes={"application/json"})
    public ResponseEntity<String> updateProfile(@RequestBody JSONObject citizen) {
        ApiResponse res = ApiResponse.newInstance();
        try {
            Citizen citizenUpdate = this.citizenService.getCitizenByUserName(citizen.get((Object)"userName").toString());
            citizenUpdate.setName(citizen.get((Object)"name").toString());
            citizenUpdate.setGender(Gender.valueOf((String)citizen.get((Object)"gender").toString()));
            citizenUpdate.setMobileNumber(citizen.get((Object)"mobileNumber").toString());
            citizenUpdate.setEmailId(citizen.get((Object)"emailId").toString());
            citizenUpdate.setAltContactNumber(citizen.get((Object)"altContactNumber").toString());
            DateTimeFormatter ft = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            Date dt = ft.parseDateTime(citizen.get((Object)"dob").toString()).toDate();
            citizenUpdate.setDob(dt);
            citizenUpdate.setPan(citizen.get((Object)"pan").toString());
            citizenUpdate.setAadhaarNumber(citizen.get((Object)"aadhaarNumber").toString());
            this.citizenService.update(citizenUpdate);
            return res.setDataAdapter((DataAdapter)new UserAdapter()).success((Object)citizen, this.getMessage("msg.citizen.update.success"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"EGOV-API ERROR ", (Throwable)e);
            return ApiResponse.newInstance().error(this.getMessage("server.error"));
        }
    }
}

