/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import org.egov.api.adapter.DataAdapter;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.pgr.entity.Complaint;

public class ComplaintAdapter
extends DataAdapter<Complaint> {
    public JsonElement serialize(Complaint complaint, Type type, JsonSerializationContext context) {
        JsonObject jo = new JsonObject();
        jo.addProperty("detail", complaint.getDetails());
        jo.addProperty("crn", complaint.getCrn());
        jo.addProperty("status", complaint.getStatus().getName());
        jo.addProperty("lastModifiedBy", complaint.getLastModifiedBy().getUsername());
        jo.addProperty("lastModifiedDate", complaint.getLastModifiedDate().toString());
        jo.addProperty("complainantName", complaint.getCreatedBy().getName());
        if (complaint.getLat() > 0.0 && complaint.getLng() > 0.0) {
            jo.addProperty("lat", (Number)complaint.getLat());
            jo.addProperty("lng", (Number)complaint.getLng());
        } else if (complaint.getLocation() != null) {
            if (complaint.getChildLocation().getLocalName() != null) {
                jo.addProperty("childLocationName", complaint.getChildLocation().getLocalName());
            }
            jo.addProperty("locationName", complaint.getLocation().getLocalName());
        }
        if (complaint.getComplaintType() != null) {
            jo.addProperty("complaintTypeId", (Number)complaint.getComplaintType().getId());
            jo.addProperty("complaintTypeName", complaint.getComplaintType().getName());
            jo.addProperty("complaintTypeImage", complaint.getComplaintType().getCode() + ".jpg");
        }
        if (complaint.getLandmarkDetails() != null) {
            jo.addProperty("landmarkDetails", complaint.getLandmarkDetails());
        }
        jo.addProperty("createdDate", complaint.getCreatedDate().toString());
        jo.addProperty("supportDocsSize", (Number)complaint.getSupportDocs().size());
        ArrayList supportDocs = new ArrayList();
        supportDocs.addAll(complaint.getSupportDocs());
        Collections.sort(supportDocs, new /* Unavailable Anonymous Inner Class!! */);
        JsonArray jsonArry = new JsonArray();
        for (FileStoreMapper file : supportDocs) {
            JsonObject fileobj = new JsonObject();
            fileobj.addProperty("fileId", file.getFileStoreId());
            fileobj.addProperty("fileContentType", file.getContentType());
            fileobj.addProperty("fileIndexId", file.getIndexId());
            jsonArry.add((JsonElement)fileobj);
        }
        jo.add("supportDocs", (JsonElement)jsonArry);
        return jo;
    }
}

