/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.oauth2.provider;

import java.util.ArrayList;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.security.authentication.SecureUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private UserService userService;

    public Authentication authenticate(Authentication authentication) {
        String userName = authentication.getName();
        String password = authentication.getCredentials().toString();
        User user = userName.contains("@") && userName.contains(".") ? this.userService.getUserByEmailId(userName) : this.userService.getUserByUsername(userName);
        if (user == null) {
            throw new OAuth2Exception("Invalid login credentials");
        }
        BCryptPasswordEncoder bcrypt = new BCryptPasswordEncoder();
        if (bcrypt.matches((CharSequence)password, user.getPassword())) {
            if (!user.isActive()) {
                throw new OAuth2Exception("Please activate your account");
            }
            ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
            grantedAuths.add(new SimpleGrantedAuthority("ROLE_" + user.getType()));
            return new UsernamePasswordAuthenticationToken((Object)new SecureUser(user), (Object)password, grantedAuths);
        }
        throw new OAuth2Exception("Invalid login credentials");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

