/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.model;

import java.util.ArrayList;
import java.util.Calendar;
import org.egov.search.domain.Filter;
import org.egov.search.domain.Filters;
import org.jboss.logging.Logger;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ComplaintSearchRequest {
    private String searchText;
    private String complaintNumber;
    private String complainantName;
    private String complaintStatus;
    private String complainantPhoneNumber;
    private String complainantEmail;
    private String receivingCenter;
    private String complaintType;
    private String complaintDateFrom;
    private String complaintDateTo;
    private String fromDate;
    private String toDate;
    private String complaintDepartment;
    private String location;
    private String currentUlb;
    DateTimeFormatter ft = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    DateTimeFormatter dtft = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    private static final Logger logger = Logger.getLogger(ComplaintSearchRequest.class);

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setComplaintNumber(String complaintNumber) {
        this.complaintNumber = complaintNumber;
    }

    public void setCurrentUlb(String currentUlb) {
        this.currentUlb = currentUlb;
    }

    public void setComplaintStatus(String complaintStatus) {
        this.complaintStatus = complaintStatus;
    }

    public void setComplainantName(String complainantName) {
        this.complainantName = complainantName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setComplainantPhoneNumber(String phoneNumber) {
        this.complainantPhoneNumber = phoneNumber;
    }

    public void setComplainantEmail(String email) {
        this.complainantEmail = email;
    }

    public void setReceivingCenter(String receivingCenter) {
        this.receivingCenter = receivingCenter;
    }

    public void setComplaintType(String complaintType) {
        this.complaintType = complaintType;
    }

    public void setFromDate(String fromDate) {
        if (null != fromDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range From start.. :" + this.ft.print((ReadableInstant)this.dtft.parseDateTime(fromDate))));
                }
                this.fromDate = this.ft.print((ReadableInstant)this.dtft.parseDateTime(fromDate));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setToDate(String toDate) {
        if (null != toDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range Till .. :" + this.ft.print((ReadableInstant)this.dtft.parseDateTime(toDate))));
                }
                this.toDate = this.ft.print((ReadableInstant)this.dtft.parseDateTime(toDate));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setComplaintDepartment(String complaintDepartment) {
        this.complaintDepartment = complaintDepartment;
    }

    public void setComplaintDate(String complaintDate) {
        if (null != complaintDate) {
            Calendar cal = Calendar.getInstance();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("String today date... " + this.ft.print(cal.getTimeInMillis())));
            }
            this.complaintDateTo = this.ft.print(cal.getTimeInMillis());
            if (complaintDate.equalsIgnoreCase("today")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"This is today selection");
                }
                this.complaintDateFrom = this.complaintDateTo;
            } else if (complaintDate.equalsIgnoreCase("all")) {
                this.complaintDateFrom = null;
                this.complaintDateTo = null;
            } else if (complaintDate.equalsIgnoreCase("lastsevendays")) {
                cal.add(5, -6);
                this.complaintDateFrom = this.ft.print(cal.getTimeInMillis());
            } else if (complaintDate.equalsIgnoreCase("lastthirtydays")) {
                cal.add(5, -29);
                this.complaintDateFrom = this.ft.print(cal.getTimeInMillis());
            } else if (complaintDate.equalsIgnoreCase("lastninetydays")) {
                cal.add(5, -89);
                this.complaintDateFrom = this.ft.print(cal.getTimeInMillis());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Else section in date range");
                }
                this.complaintDateFrom = null;
                this.complaintDateTo = null;
            }
        }
    }

    public Filters searchFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>();
        andFilters.add(Filter.termsStringFilter((String)"clauses.ulb", (String[])new String[]{this.currentUlb}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.crn", (String[])new String[]{this.complaintNumber}));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.name", (String)this.complainantName));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.mobile", (String)this.complainantPhoneNumber));
        andFilters.add(Filter.queryStringFilter((String)"common.citizen.email", (String)this.complainantEmail));
        andFilters.add(Filter.queryStringFilter((String)"clauses.status.name", (String)this.complaintStatus));
        andFilters.add(Filter.queryStringFilter((String)"clauses.receivingMode", (String)this.receivingCenter));
        andFilters.add(Filter.queryStringFilter((String)"searchable.complaintType.name", (String)this.complaintType));
        andFilters.add(Filter.rangeFilter((String)"common.createdDate", (String)this.complaintDateFrom, (String)this.complaintDateTo));
        andFilters.add(Filter.rangeFilter((String)"common.createdDate", (String)this.fromDate, (String)this.toDate));
        andFilters.add(Filter.queryStringFilter((String)"searchable.complaintType.department.name", (String)this.complaintDepartment));
        andFilters.add(Filter.queryStringFilter((String)"common.boundary.name", (String)this.location));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"finished filters");
        }
        return Filters.withAndFilters(andFilters);
    }

    public String searchQuery() {
        return this.searchText;
    }
}

