/*
 * Decompiled with CFR 0.152.
 */
package org.egov.api.controller.core;

import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.api.controller.core.ApiResponse;
import org.egov.infra.filestore.service.FileStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;

public abstract class ApiController {
    protected static final Logger Log = LoggerFactory.getLogger(ApiController.class);
    @PersistenceContext
    protected EntityManager entityManager;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private MessageSource messageSource;

    public String getMessage(String key) {
        return this.messageSource.getMessage(key, null, Locale.getDefault());
    }

    public ApiResponse getResponseHandler() {
        return ApiResponse.newInstance();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<String> apiExceptionHandler(HttpMessageNotReadableException ex) {
        return this.getResponseHandler().error(ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<String> apiExceptionHandler(MissingServletRequestParameterException ex) {
        return this.getResponseHandler().error(ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> apiExceptionHandler(Exception ex) {
        return this.getResponseHandler().error(ex.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<String> apiExceptionHandler(MethodArgumentNotValidException ex) {
        return this.getResponseHandler().error(ex.getMessage(), HttpStatus.BAD_REQUEST);
    }
}

