/*******************************************************************************
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 * 	1) All versions of this program, verbatim or modified must carry this
 * 	   Legal Notice.
 *
 * 	2) Any misrepresentation of the origin of the material is prohibited. It
 * 	   is required that all modified versions of this material be marked in
 * 	   reasonable ways as different from the original version.
 *
 * 	3) This license does not grant any rights to any user of the program
 * 	   with regards to rights under trademark law for use of the trade names
 * 	   or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 ******************************************************************************/
package org.egov.ap.wtms.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.persistence.ParameterMode;

import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.GenerateConnectionBillService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.repository.ApplicationDocumentsRepository;
import org.egov.wtms.masters.service.DocumentNamesService;
import org.egov.wtms.service.bill.WaterConnectionBillService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.hibernate.Query;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.result.ResultSetOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author roopa.h
 *
 */
@Service("waterConnectionBillService")
public class WaterConnectionBillServiceImpl implements WaterConnectionBillService {

    private static final Logger LOGGER = Logger.getLogger(WaterConnectionBillServiceImpl.class);

    private static final String SCHEDULE_II_OF_APM_ACT_1965 = "(Issued Under section 142 of AP Municipalities Act, 1965 and water supply Bye-laws)";

    private static final String CORPORATION_ACT_1955 = "(Issued Under section 341 to 371 of AP Municipal Corporations Act, 1994 (formerly GHMC Act, 1955) and water supply Bye-laws)";

    private static final String CDMA_AP_GOV_IN = ".cdma.ap.gov.in";

    @Autowired
    @Qualifier("persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private ReportService reportService;

    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private GenerateConnectionBillService generateConnectionBillService;

    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private InstallmentDao installmentDao;

    @Autowired
    private ModuleService moduleService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private DocumentNamesService documentNamesService;

    @Autowired
    private PropertyExtnUtils propertyExtnUtils;

    @Qualifier("entityQueryService")
    private @Autowired PersistenceService entityQueryService;

    @Autowired
    private ApplicationDocumentsRepository applicationDocumentsRepository;

    @Autowired
    private CityService cityService;

    @Autowired
    private FileStoreService fileStoreService;

    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    private Map<String, Object> prepareReportParams(final EgBill egBill, final CFinancialYear financialYear,
            final WaterConnectionDetails waterConnectionDetails, final WaterRatesDetails waterRatesDetails) {

        final Map<String, Object> reportParams = new HashMap<String, Object>();
        final City city = (City) persistenceService.find("from City");
        String sectionAct = "";
        final String cityGrade = city.getGrade();
        if (cityGrade != null && cityGrade != ""
                && cityGrade.equalsIgnoreCase(PropertyTaxConstants.CITY_GRADE_CORPORATION))
            sectionAct = CORPORATION_ACT_1955;
        else
            sectionAct = SCHEDULE_II_OF_APM_ACT_1965;

        String applicantName = "";
        AssessmentDetails assessmentDetails = null;
        if (waterConnectionDetails != null) {
            assessmentDetails = propertyExtnUtils.getAssessmentDetailsForFlag(
                    waterConnectionDetails.getConnection().getPropertyIdentifier(),
                    PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
            if (null != assessmentDetails && null != assessmentDetails.getOwnerNames()
                    && !assessmentDetails.getOwnerNames().isEmpty())
                for (final OwnerName names : assessmentDetails.getOwnerNames()) {
                    applicantName = names.getOwnerName();
                    break;
                }
            final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            EgBill billObj = null;
            Date secondStartDate = null;
            final CFinancialYear financialYear1 = financialYearDAO.getFinancialYearByDate(new Date());
            final String finYear[] = financialYear1.getFinYearRange().split("-");
            final String finYearsDesc = finYear[0];
            final String secondHalfStartDate = "01/10/".concat(finYearsDesc);

            try {
                secondStartDate = formatter.parse(secondHalfStartDate);
            } catch (final ParseException e) {
                LOGGER.error("error while formatting Strint into  Date", e);
            }
            BigDecimal arrarTotal = BigDecimal.ZERO;
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalnetPayable = BigDecimal.ZERO;
            final BigDecimal penalty1 = BigDecimal.ZERO;
            final BigDecimal penalty2 = BigDecimal.ZERO;
            BigDecimal totalAmount1 = BigDecimal.ZERO;
            BigDecimal totalAmount2 = BigDecimal.ZERO;
            BigDecimal installmentMonthlyCharge = BigDecimal.ZERO;
            BigDecimal installmentMonthlyChargeCurrent = BigDecimal.ZERO;
            BigDecimal demandcollected = BigDecimal.ZERO;

            try {
                secondStartDate = formatter.parse(secondHalfStartDate);
            } catch (final ParseException e) {
                e.printStackTrace();
            }
            final Installment installmentFirstHalf = installmentDao.getInsatllmentByModuleForGivenDate(
                    moduleService.getModuleByName(WaterTaxConstants.PROPERTY_MODULE_NAME),
                    financialYear.getStartingDate());
            final Installment installmentSecondHalf = installmentDao.getInsatllmentByModuleForGivenDate(
                    moduleService.getModuleByName(WaterTaxConstants.PROPERTY_MODULE_NAME), secondStartDate);
            if (egBill != null) {
                if (egBill.getEgBillType() != null && egBill.getEgBillType().getCode() != null
                        && egBill.getEgBillType().getCode().equals(WaterTaxConstants.BILLTYPE_MANUAL))
                    billObj = egBill;
                if (billObj != null && !billObj.getEgBillDetails().isEmpty())
                    for (final EgBillDetails billdet : billObj.getEgBillDetails())
                        if (billdet != null)
                            if (billdet.getDescription() != null && billdet.getDescription().contains("Water Charges")
                                    && billdet.getPurpose() != null && billdet.getPurpose().equals("OTHERS")) {
                                final String temp1[] = billdet.getDescription().split("Water Charges -");
                                if (billdet.getDescription().contains("#")) {
                                    final String instDesc[] = temp1[1].split("#");
                                    if (!instDesc[0].isEmpty()
                                            && instDesc[0].trim().equals(installmentFirstHalf.getDescription()))
                                        totalAmount1 = totalAmount1.add(billdet.getCrAmount());
                                    if (!instDesc[0].isEmpty()
                                            && instDesc[0].trim().equals(installmentSecondHalf.getDescription()))
                                        totalAmount2 = totalAmount2.add(billdet.getCrAmount());
                                    if (!instDesc[0].isEmpty() && !instDesc[0].trim()
                                            .equals(installmentSecondHalf.getDescription())
                                            && !instDesc[0].trim().equals(installmentFirstHalf.getDescription()))
                                        arrarTotal = arrarTotal.add(billdet.getCrAmount());
                                }
                            }

                final EgDemand currentDemand = egBill.getEgDemand();
                if (currentDemand != null)
                    for (final EgDemandDetails demdetails : currentDemand.getEgDemandDetails())
                        if (demdetails != null && demdetails.getEgDemandReason() != null)
                            if (demdetails.getEgDemandReason().getEgInstallmentMaster().equals(installmentFirstHalf))
                                demandcollected = demandcollected.add(demdetails.getAmtCollected());
                            else if (demdetails.getEgDemandReason().getEgInstallmentMaster()
                                    .equals(installmentSecondHalf))
                                demandcollected = demandcollected.add(demdetails.getAmtCollected());
            }

            if (waterConnectionDetails != null) {
                installmentMonthlyCharge = new BigDecimal(
                        waterRatesDetails != null && waterRatesDetails.getMonthlyRate() != null
                                ? waterRatesDetails.getMonthlyRate() : 0);
                if (waterRatesDetails != null)
                    LOGGER.debug("waterRatesDetails for connection is null + "
                            + waterConnectionDetails.getApplicationNumber());

                final BigDecimal secondinstallmentcharge = installmentMonthlyCharge.multiply(new BigDecimal(6))
                        .add(penalty2);

                /*
                 * if ((totalAmount1.compareTo(firstinstallmentcharge) < 0) || (totalAmount1.equals(BigDecimal.ZERO))) {
                 * totalAmount1 = firstinstallmentcharge; }
                 */
                if (totalAmount2.compareTo(secondinstallmentcharge) < 0 || totalAmount2.equals(BigDecimal.ZERO))
                    totalAmount2 = secondinstallmentcharge;
                if (totalAmount1.compareTo(BigDecimal.ZERO) > 0) {
                    installmentMonthlyCharge = totalAmount1.divide(BigDecimal.valueOf(6), BigDecimal.ROUND_HALF_UP);
                    installmentMonthlyChargeCurrent = totalAmount1.divide(BigDecimal.valueOf(6), BigDecimal.ROUND_HALF_UP);
                } else
                    installmentMonthlyCharge = totalAmount2.divide(BigDecimal.valueOf(6), BigDecimal.ROUND_HALF_UP);
                totalAmount = arrarTotal.add(totalAmount1).add(totalAmount2);
                if (demandcollected.equals(BigDecimal.ZERO))
                    totalnetPayable = totalAmount;
                else
                    totalnetPayable = totalAmount.subtract(demandcollected);
                if (totalAmount.compareTo(demandcollected) < 0)
                    totalnetPayable = BigDecimal.ZERO;
                reportParams.put("sectionAct", sectionAct);
                reportParams.put("cityName", city.getPreferences().getMunicipalityName());
                reportParams.put("cityUrl", cityService.findAll().get(0).getName().toLowerCase() + CDMA_AP_GOV_IN);
                reportParams.put("districtName", city.getDistrictName());
                reportParams.put("assessmentNumber", waterConnectionDetails.getConnection().getPropertyIdentifier());
                reportParams.put("locality",
                        assessmentDetails != null ? assessmentDetails.getBoundaryDetails().getLocalityName() : "");
                reportParams.put("revenueWard",
                        assessmentDetails != null ? assessmentDetails.getBoundaryDetails().getWardName() : "");
                reportParams.put("block",
                        assessmentDetails != null ? assessmentDetails.getBoundaryDetails().getBlockName() : "");
                reportParams.put("doorNo", assessmentDetails != null ? assessmentDetails.getHouseNo() : "");
                reportParams.put("consumerNo", waterConnectionDetails.getConnection().getConsumerCode());
                reportParams.put("oldConsumerNo", waterConnectionDetails.getConnection().getOldConsumerNumber());
                reportParams.put("consumerName", applicantName);
                reportParams.put("finyearDesc", financialYear1 != null && financialYear1.getFinYearRange() != null
                        ? financialYear1.getFinYearRange() : "");
                reportParams.put("arrarTotal", arrarTotal.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("installmentMonthlyCharge",
                        installmentMonthlyCharge.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("installmentMonthlyChargeCurrent",
                        installmentMonthlyChargeCurrent.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("totalAmount", totalAmount.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("demandBillNumber", billObj != null ? billObj.getBillNo() : "");
                reportParams.put("demandBillDate", billObj != null ? formatter.format(billObj.getCreateDate()) : "");
                reportParams.put("penalty1", penalty1.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("penalty2", penalty2.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("totalAmount1", totalAmount1.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("totalAmount2", totalAmount2.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("totalnetPayable", totalnetPayable.setScale(2, BigDecimal.ROUND_HALF_UP));
                reportParams.put("adjustamount", demandcollected.setScale(2, BigDecimal.ROUND_HALF_UP));

            }
        }
        return reportParams;
    }

    @Override
    @Transactional
    public void printDemandBill(final String consumerCode) {
        ReportRequest reportRequest = null;
        final WaterConnectionDetails waterConnectionDetails = waterConnectionDetailsService
                .findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        InputStream billPDF = null;
        ReportOutput reportOutput = new ReportOutput();
        List<EgBill> billTempList = new ArrayList<EgBill>();
        final CFinancialYear financialYear = financialYearDAO.getFinancialYearByDate(new Date());
        final Query querytemp = getBillForConsumerCode(consumerCode, financialYear.getStartingDate());
        billTempList = querytemp.list();
        final EgBill egBill = !billTempList.isEmpty() ? billTempList.get(0) : null;
        WaterRatesDetails waterRatesDetails = null;
        if (waterConnectionDetails != null)
            waterRatesDetails = connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails);
        if (egBill != null) {
            LOGGER.debug("Bill Object with id= " + egBill.getId() + " for consumercode " + consumerCode);
            final Map<String, Object> reportParams = prepareReportParams(egBill, financialYear, waterConnectionDetails,
                    waterRatesDetails);
            reportRequest = new ReportRequest("waterChargesDemandBill", egBill, reportParams);
            reportOutput = reportService.createReport(reportRequest);
            if (reportOutput != null && reportOutput.getReportOutputData() != null)
                billPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());

            if (waterConnectionDetails != null)
                saveApplicationDocWithFileStore(egBill, waterConnectionDetails, billPDF);

        }
    }

    private Query getBillForConsumerCode(final String consumercode, final Date finDate) {
        final StringBuilder queryStringtemp = new StringBuilder();

        queryStringtemp
                .append("select distinct bill From EgBill bill,EgBillType billtype,EgDemand demand,WaterConnection conn,"
                        + " WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem "
                        + " where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode "
                        + " and conn.id=connDet.connection and connDet.id=conndem.waterConnectionDetails "
                        + " and demand.id=conndem.demand and demand.id=bill.egDemand and bill.consumerId = :consumercode "
                        + " and bill.createDate >= :financialyearstartdate and bill.serviceCode='WT' "
                        + " and demand.isHistory='N' and bill.is_Cancelled='N' and connDet.connectionType='NON_METERED' "
                        + " and connDet.connectionStatus='ACTIVE' and connDet.status=status.id "
                        + " and status.moduletype = :moduletype and status.code = :statuscode ")
                .append(" and not exists (select ad from ApplicationDocuments ad where ad.documentNumber=bill.billNo)")
                .append(" order by bill.id desc ");
        final Query query = persistenceService.getSession().createQuery(queryStringtemp.toString())
                .setString("moduletype", WaterTaxConstants.MODULETYPE).setString("consumercode", consumercode)
                .setDate("financialyearstartdate", finDate)
                .setString("statuscode", WaterTaxConstants.APPLICATION_STATUS_SANCTIONED);
        LOGGER.debug("query to get Single Bill Object for Consumercode=" + query.toString());
        return query;
    }

    @Transactional
    public void saveApplicationDocWithFileStore(final EgBill egBill,
            final WaterConnectionDetails waterConnectionDetails, final InputStream fileStream) {
        final ApplicationDocuments appDocuments = new ApplicationDocuments();
        final Set<FileStoreMapper> filestoreSet = new HashSet<FileStoreMapper>();
        appDocuments.setDocumentNumber(egBill.getBillNo());
        appDocuments.setDocumentDate(egBill.getCreateDate());
        final DocumentNames docNmae = documentNamesService.findByApplicationTypeAndDocumentName(
                waterConnectionDetails.getApplicationType(), WaterTaxConstants.DOCUMENTNAMEFORBILL);
        if (docNmae != null) {
            appDocuments.setDocumentNames(docNmae);
            appDocuments.setCreatedDate(new Date());
            appDocuments.setWaterConnectionDetails(waterConnectionDetails);
            final String fileName = appDocuments.getDocumentNumber() + WaterTaxConstants.PDFEXTENTION;
            final FileStoreMapper fileStore = fileStoreService.store(fileStream, fileName,
                    WaterTaxConstants.APPLICATIONPDFNAME, WaterTaxConstants.FILESTORE_MODULECODE);
            filestoreSet.add(fileStore);
            appDocuments.setSupportDocs(filestoreSet);
            applicationDocumentsRepository.save(appDocuments);
        }
    }

    @Override
    @Transactional
    public void bulkBillGeneration(final Integer modulo, final Integer billsCount) {

        final Long jobStartTime = System.currentTimeMillis();
        final Query query = getQuery(modulo, billsCount);
        int noOfBillsGenerated = 0;
        final List<String> consumerNumberList = query.list();
        Long timeTaken = System.currentTimeMillis() - jobStartTime;
        for (final String consumerCode : consumerNumberList)
            try {

                printDemandBill(consumerCode);
                noOfBillsGenerated++;

            } catch (final Exception e) {
                LOGGER.error(" Error while generating  bill via BulkWaterConnBillGenerationJob Job " + modulo.toString()
                        + consumerCode, e);

            }

        timeTaken = jobStartTime - System.currentTimeMillis();
        LOGGER.debug("Exiting from executeJob" + modulo + "executeJob" + modulo + " - " + noOfBillsGenerated + "/"
                + consumerNumberList.size() + " Bill(s) generated in " + timeTaken / 1000 + " (secs)");

    }

    private Query getQuery(final Integer modulo, final Integer billsCount) {
        final StringBuilder queryString = new StringBuilder();
        queryString
                .append("select distinct bill.consumerId From EgBill bill,EgBillType billtype,EgDemand demand,WaterConnection conn,"
                        + " WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem"
                        + " where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode "
                        + " and conn.id=connDet.connection "
                        + " and connDet.id=conndem.waterConnectionDetails and demand.id=conndem.demand and demand.id=bill.egDemand "
                        + " and demand.isHistory='N' and bill.is_Cancelled='N' and connDet.connectionType='NON_METERED' "
                        + " and connDet.connectionStatus='ACTIVE' and connDet.status=status.id and status.moduletype = :moduletype "
                        + " and status.code = :statuscode")
                .append(" and not exists (select ad from ApplicationDocuments ad where ad.documentNumber=bill.billNo)")
                .append(" and MOD(conn.id, ").append(WaterTaxConstants.QUARTZ_BULKBILL_JOBS).append(") = :modulo ");
        final Query query = persistenceService.getSession().createQuery(queryString.toString())
                .setInteger("modulo", modulo).setString("moduletype", WaterTaxConstants.MODULETYPE)
                .setString("statuscode", WaterTaxConstants.APPLICATION_STATUS_SANCTIONED);
        query.setMaxResults(billsCount);
        LOGGER.debug("query to get All consumernumbers where Bill is generated" + query.toString());
        return query;
    }

    @Override
    @Transactional
    public void generateBillForConsumercode(final String consumerCode) {
        connectionDemandService.getInstallmentsForPreviousYear(new Date())
                .get(WaterTaxConstants.PREVIOUS_SECOND_HALF);
        final WaterConnectionDetails waterConnectionDetails = waterConnectionDetailsService
                .findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        final Installment currFirstHalf = propertyTaxUtil.getInstallmentsForCurrYear(new Date())
                .get(PropertyTaxConstants.CURRENTYEAR_FIRST_HALF);
        ProcedureCall procedureCall = null;
        final Installment currSecondHalf = propertyTaxUtil.getInstallmentsForCurrYear(new Date())
                .get(PropertyTaxConstants.CURRENTYEAR_SECOND_HALF);
        if (waterConnectionDetails != null && waterConnectionDetails.getLegacy()) {
            procedureCall = entityQueryService.getSession()
                    .createStoredProcedureCall("wtmsbill_latestBill_RegeDemand_ConsumerCode");
            procedureCall.registerParameter("consumerCode", String.class, ParameterMode.IN);
            procedureCall.getParameterRegistration("consumerCode").bindValue(consumerCode);
            procedureCall.registerParameter("currFirstHalf", int.class, ParameterMode.IN);
            procedureCall.getParameterRegistration("currFirstHalf").bindValue(currFirstHalf.getId());
            procedureCall.registerParameter("currSecondHalf", int.class, ParameterMode.IN);
            procedureCall.getParameterRegistration("currSecondHalf").bindValue(currSecondHalf.getId());
        }
        ProcedureOutputs procedureOutputs = null;
        ResultSetOutput output = null;
        if (procedureCall != null) {

            procedureOutputs = procedureCall.getOutputs();
            output = (ResultSetOutput) procedureOutputs.getCurrent();
            output.getSingleResult();
        }
        final EgBill egbill = getBillForDownloadPdfByConsumerCode(consumerCode);
        LOGGER.debug(
                "single hscnumber Bill Object = " + (egbill != null ? egbill.getBillNo() : null) + " for consumercode "
                        + consumerCode);
        InputStream billPDF = null;
        ReportRequest reportRequest = null;
        ReportOutput reportOutput = new ReportOutput();
        final CFinancialYear financialYear = financialYearDAO.getFinancialYearByDate(new Date());
        WaterRatesDetails waterRatesDetails = null;
        if (waterConnectionDetails != null)
            waterRatesDetails = connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails);
        if (egbill != null) {
            LOGGER.debug(
                    "single hscnumber Bill Object with id= " + egbill.getId() + " for consumercode " + consumerCode);
            final Map<String, Object> reportParams = prepareReportParams(egbill, financialYear, waterConnectionDetails,
                    waterRatesDetails);
            reportRequest = new ReportRequest("waterChargesDemandBill", egbill, reportParams);
            reportOutput = reportService.createReport(reportRequest);
            if (reportOutput != null && reportOutput.getReportOutputData() != null)
                billPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            if (waterConnectionDetails != null) {
                final List<Long> fileStoreIdList = generateConnectionBillService.getDocuments(consumerCode,
                        waterConnectionDetails.getApplicationType().getName());
                if (fileStoreIdList.isEmpty())
                    saveApplicationDocWithFileStore(egbill, waterConnectionDetails, billPDF);
            }

        }
    }

    public EgBill getBillForDownloadPdfByConsumerCode(final String consumerCode) {
        EgBill egBill = null;
        final String query = " select distinct bill From EgBill bill,EgBillType billtype,WaterConnection conn,WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem  , EgDemand demd "
                + "where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode and conn.id=connDet.connection and connDet.id=conndem.waterConnectionDetails "
                + " and demd.id=bill.egDemand and demd.id=conndem.demand and connDet.connectionType='NON_METERED' "
                + " and demd.isHistory = 'N' and  bill.is_Cancelled='N' and bill.serviceCode='WT' "
                + " and connDet.connectionStatus='ACTIVE' and connDet.status=status.id and status.moduletype='WATERTAXAPPLICATION' "
                + " and status.code='SANCTIONED' and conn.consumerCode =:consumerCode  order by bill.id desc";
        final Query hibquery = persistenceService.getSession().createQuery(query.toString())
                .setString("consumerCode", consumerCode);
        final List<EgBill> egBilltemp = hibquery.list();
        if (!egBilltemp.isEmpty())
            egBill = egBilltemp.get(0);
        LOGGER.debug(
                "query to get Bill for single consumernumber" + query.toString() + " for consumer No= " + consumerCode);
        return egBill;
    }

}