/*******************************************************************************
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 * 	1) All versions of this program, verbatim or modified must carry this
 * 	   Legal Notice.
 *
 * 	2) Any misrepresentation of the origin of the material is prohibited. It
 * 	   is required that all modified versions of this material be marked in
 * 	   reasonable ways as different from the original version.
 *
 * 	3) This license does not grant any rights to any user of the program
 * 	   with regards to rights under trademark law for use of the trade names
 * 	   or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 ******************************************************************************/
package org.egov.ap.ptis.model;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.egov.infra.persistence.entity.AbstractAuditable;

/**
 *
 * @author subhash
 *
 */
@Entity
@Table(name = DemandBillDetails.EG_DEMAND_BILL_DETAILS)
@SequenceGenerator(name = DemandBillDetails.SEQ_EG_DEMAND_BILL_DETAILS, sequenceName = DemandBillDetails.SEQ_EG_DEMAND_BILL_DETAILS)
public class DemandBillDetails extends AbstractAuditable  {

    protected static final String SEQ_EG_DEMAND_BILL_DETAILS = "seq_eg_demand_bill_details";

    protected static final String EG_DEMAND_BILL_DETAILS = "eg_demand_bill_details";

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(generator = SEQ_EG_DEMAND_BILL_DETAILS, strategy = GenerationType.SEQUENCE)
    private Long id;
    private Date paidBeforeDate;
    private BigDecimal arrearTax;
    private BigDecimal arrearPenalty;
    private BigDecimal currFirstHalfTax;
    private BigDecimal currSecondHalfTax;
    private BigDecimal currFirstHalfPenalty;
    private BigDecimal currSecondHalfPenalty;
    private BigDecimal totalAmount;
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.LAZY, targetEntity = DemandBill.class)
    @JoinColumn(name = "egdemandbillid")
    private DemandBill demandBill;
    @Column(name="WATER_TAX")
    private BigDecimal waterTax;
    @Column(name="SEWERAGE_TAX")
    private BigDecimal sewerageTax;

    @Override
    protected void setId(final Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return id;
    }

    public Date getPaidBeforeDate() {
        return paidBeforeDate;
    }

    public void setPaidBeforeDate(final Date paidBeforeDate) {
        this.paidBeforeDate = paidBeforeDate;
    }

    public BigDecimal getArrearTax() {
        return arrearTax;
    }

    public void setArrearTax(final BigDecimal arrearTax) {
        this.arrearTax = arrearTax;
    }

    public BigDecimal getArrearPenalty() {
        return arrearPenalty;
    }

    public void setArrearPenalty(final BigDecimal arrearPenalty) {
        this.arrearPenalty = arrearPenalty;
    }

    public BigDecimal getCurrFirstHalfTax() {
        return currFirstHalfTax;
    }

    public void setCurrFirstHalfTax(final BigDecimal currFirstHalfTax) {
        this.currFirstHalfTax = currFirstHalfTax;
    }

    public BigDecimal getCurrSecondHalfTax() {
        return currSecondHalfTax;
    }

    public void setCurrSecondHalfTax(final BigDecimal currSecondHalfTax) {
        this.currSecondHalfTax = currSecondHalfTax;
    }

    public BigDecimal getCurrFirstHalfPenalty() {
        return currFirstHalfPenalty;
    }

    public void setCurrFirstHalfPenalty(final BigDecimal currFirstHalfPenalty) {
        this.currFirstHalfPenalty = currFirstHalfPenalty;
    }

    public BigDecimal getCurrSecondHalfPenalty() {
        return currSecondHalfPenalty;
    }

    public void setCurrSecondHalfPenalty(final BigDecimal currSecondHalfPenalty) {
        this.currSecondHalfPenalty = currSecondHalfPenalty;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(final BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public DemandBill getDemandBill() {
        return demandBill;
    }

    public void setDemandBill(final DemandBill demandBill) {
        this.demandBill = demandBill;
    }

    public BigDecimal getWaterTax() {
        return waterTax;
    }

    public void setWaterTax(BigDecimal waterTax) {
        this.waterTax = waterTax;
    }

    public BigDecimal getSewerageTax() {
        return sewerageTax;
    }

    public void setSewerageTax(BigDecimal sewerageTax) {
        this.sewerageTax = sewerageTax;
    }

}
