/*******************************************************************************
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 * 	1) All versions of this program, verbatim or modified must carry this
 * 	   Legal Notice.
 *
 * 	2) Any misrepresentation of the origin of the material is prohibited. It
 * 	   is required that all modified versions of this material be marked in
 * 	   reasonable ways as different from the original version.
 *
 * 	3) This license does not grant any rights to any user of the program
 * 	   with regards to rights under trademark law for use of the trade names
 * 	   or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 ******************************************************************************/
package org.egov.ap.ptis.model;

import static org.egov.ptis.constants.PropertyTaxConstants.ARREARS;
import static org.egov.ptis.constants.PropertyTaxConstants.CURRENTYEAR_FIRST_HALF;
import static org.egov.ptis.constants.PropertyTaxConstants.CURRENTYEAR_SECOND_HALF;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.persistence.entity.AbstractAuditable;

/**
 *
 * @author subhash
 *
 */
@Entity
@Table(name = DemandBill.EG_DEMAND_BILL)
@SequenceGenerator(name = DemandBill.SEQ_EG_DEMAND_BILL, sequenceName = DemandBill.SEQ_EG_DEMAND_BILL)
@NamedQuery(name = "demandBillstatus", query = "select bndry.boundaryNum, count(bndry.boundaryNum) from DemandBill bill, Boundary bndry, PtNotice notice left join notice.basicProperty bp  where bp.propertyID.ward.id=bndry.id and bp.active = true and bill.isactive = true  "
        + " and :FromDate <= bill.createdDate and :ToDate >= bill.createdDate and bill.billnumber = notice.noticeNo and notice.noticeType = 'Bill' and notice.fileStore is not null group by bndry.boundaryNum order by bndry.boundaryNum ")
public class DemandBill extends AbstractAuditable {

    protected static final String EG_DEMAND_BILL = "eg_demand_bill";
    protected static final String SEQ_EG_DEMAND_BILL = "seq_eg_demand_bill";
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator = SEQ_EG_DEMAND_BILL, strategy = GenerationType.SEQUENCE)
    private Long id;
    @Column(name="assessmentno", nullable=false)
    private String assessmentNo;
    private String houseNo;
    private String ownerName;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=Boundary.class)
    @JoinColumn(name="locality")
    private Boundary locality;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=Boundary.class)
    @JoinColumn(name="revenueward")
    private Boundary revenueWard;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=Boundary.class)
    @JoinColumn(name="block")
    private Boundary block;
    private BigDecimal advance;
    @Column(name="arrear_interest")
    private BigDecimal arrearsPenalty;
    @OneToMany(mappedBy="demandBill", cascade=CascadeType.ALL, fetch=FetchType.LAZY)
    @OrderBy(value="paidBeforeDate ASC")
    private Set<DemandBillDetails> demandBillDetails;
    @OneToMany(mappedBy="demandBill", cascade=CascadeType.ALL, fetch=FetchType.LAZY)
    private Set<DemandInstDetails> demandInstDetails;
    @Column(name="billnumber", nullable=false)
    private String billnumber;
    private Boolean isactive;
    @Column(name="WT_CONSUMER_CODE")
    private String waterTaxAssessments;
    @Column(name="ST_CONSUMER_CODE")
    private String sewerageTaxAssessments;
    @Column(name="WT_ARREARS_INTEREST")
    private BigDecimal waterTaxArrearsInterest;
    @Column(name="ST_ARREARS_INTEREST")
    private BigDecimal sewerageTaxArrearsInterest;
    @Column(name="WT_ADVANCE")
    private BigDecimal waterTaxAdvance;
    @Column(name="ST_ADVANCE")
    private BigDecimal sewerageTaxAdvance;
    @Column(name="is_history")
    private Character isHistory;

    @Override
    protected void setId(final Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return id;
    }

    public String getAssessmentNo() {
        return assessmentNo;
    }

    public void setAssessmentNo(final String assessmentNo) {
        this.assessmentNo = assessmentNo;
    }

    public String getHouseNo() {
        return houseNo;
    }

    public void setHouseNo(final String houseNo) {
        this.houseNo = houseNo;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(final String ownerName) {
        this.ownerName = ownerName;
    }

    public Boundary getLocality() {
        return locality;
    }

    public void setLocality(final Boundary locality) {
        this.locality = locality;
    }

    public Boundary getRevenueWard() {
        return revenueWard;
    }

    public void setRevenueWard(final Boundary revenueWard) {
        this.revenueWard = revenueWard;
    }

    public Boundary getBlock() {
        return block;
    }

    public void setBlock(final Boundary block) {
        this.block = block;
    }

    public BigDecimal getAdvance() {
        return advance;
    }

    public void setAdvance(final BigDecimal advance) {
        this.advance = advance;
    }

    public BigDecimal getArrearsPenalty() {
        return arrearsPenalty;
    }

    public void setArrearsPenalty(final BigDecimal arrearsPenalty) {
        this.arrearsPenalty = arrearsPenalty;
    }

    public Set<DemandBillDetails> getDemandBillDetails() {
        return demandBillDetails;
    }

    public void setDemandBillDetails(final Set<DemandBillDetails> demandBillDetails) {
        this.demandBillDetails = demandBillDetails;
    }

    public Set<DemandInstDetails> getDemandInstDetails() {
        return demandInstDetails;
    }

    public void setDemandInstDetails(final Set<DemandInstDetails> demandInstDetails) {
        this.demandInstDetails = demandInstDetails;
    }

    public String getBillnumber() {
        return billnumber;
    }

    public void setBillnumber(String billnumber) {
        this.billnumber = billnumber;
    }

    public Boolean getIsactive() {
        return isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }
    
    public DemandInstDetails getFirstInstDetails() {
        DemandInstDetails instDemandDetail = new DemandInstDetails();
        for(DemandInstDetails demandInstDetail : this.getDemandInstDetails()) {
            if(demandInstDetail.getInstallment().equals(CURRENTYEAR_FIRST_HALF)) {
                instDemandDetail = demandInstDetail;
                break;
            }
        }
        return instDemandDetail;
    }
    
    public DemandInstDetails getSecondInstDetails() {
        DemandInstDetails instDemandDetail = new DemandInstDetails();
        for(DemandInstDetails demandInstDetail : this.getDemandInstDetails()) {
            if(demandInstDetail.getInstallment().equals(CURRENTYEAR_SECOND_HALF)) {
                instDemandDetail = demandInstDetail;
                break;
            }
        }
        return instDemandDetail;
    }
    
    public DemandInstDetails getArrearInstDetails() {
        DemandInstDetails instDemandDetail = new DemandInstDetails();
        for(DemandInstDetails demandInstDetail : this.getDemandInstDetails()) {
            if(demandInstDetail.getInstallment().equals(ARREARS)) {
                instDemandDetail = demandInstDetail;
                break;
            }
        }
        return instDemandDetail;
    }

    public Map<String, BigDecimal> getCollections(){
        Map<String, BigDecimal> collectionsMap = new HashMap<>();
        BigDecimal propertyTaxColl = BigDecimal.ZERO;
        BigDecimal waterColl = BigDecimal.ZERO;
        BigDecimal sewerageColl = BigDecimal.ZERO;
        for(DemandInstDetails demandInstDetail : this.getDemandInstDetails()) {
            propertyTaxColl = propertyTaxColl.add(demandInstDetail.getPropertyTaxColl());
            waterColl = waterColl.add(demandInstDetail.getWaterColl());
            sewerageColl = sewerageColl.add(demandInstDetail.getSewerageColl());
        }
        collectionsMap.put("propertyColl", propertyTaxColl);
        collectionsMap.put("waterColl", waterColl);
        collectionsMap.put("sewerageColl", sewerageColl);
        return collectionsMap;
    }
    
    public String getWaterTaxAssessments() {
        return waterTaxAssessments;
    }

    public void setWaterTaxAssessments(String waterTaxAssessments) {
        this.waterTaxAssessments = waterTaxAssessments;
    }

    public String getSewerageTaxAssessments() {
        return sewerageTaxAssessments;
    }

    public void setSewerageTaxAssessments(String sewerageTaxAssessments) {
        this.sewerageTaxAssessments = sewerageTaxAssessments;
    }

    public BigDecimal getWaterTaxArrearsInterest() {
        return waterTaxArrearsInterest;
    }

    public void setWaterTaxArrearsInterest(BigDecimal waterTaxArrearsInterest) {
        this.waterTaxArrearsInterest = waterTaxArrearsInterest;
    }

    public BigDecimal getSewerageTaxArrearsInterest() {
        return sewerageTaxArrearsInterest;
    }

    public void setSewerageTaxArrearsInterest(BigDecimal sewerageTaxArrearsInterest) {
        this.sewerageTaxArrearsInterest = sewerageTaxArrearsInterest;
    }

    public BigDecimal getWaterTaxAdvance() {
        return waterTaxAdvance;
    }

    public void setWaterTaxAdvance(BigDecimal waterTaxAdvance) {
        this.waterTaxAdvance = waterTaxAdvance;
    }

    public BigDecimal getSewerageTaxAdvance() {
        return sewerageTaxAdvance;
    }

    public void setSewerageTaxAdvance(BigDecimal sewerageTaxAdvance) {
        this.sewerageTaxAdvance = sewerageTaxAdvance;
    }

    public Character getIsHistory() {
        return isHistory;
    }

    public void setIsHistory(Character isHistory) {
        this.isHistory = isHistory;
    }

}
