package org.egov.ap.config;

import org.egov.ap.ptis.scheduler.MutationApplicationUpdateJob;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

import static org.quartz.CronTrigger.MISFIRE_INSTRUCTION_DO_NOTHING;

@Configuration
@Conditional(SchedulerConfigCondition.class)
public class APSchedulerConfiguration extends QuartzSchedulerConfiguration {

    @Bean
    public SchedulerFactoryBean apImplScheduler(DataSource dataSource) {
        SchedulerFactoryBean apImplScheduler = createScheduler(dataSource);
        apImplScheduler.setSchedulerName("ap-impl-scheduler");
        apImplScheduler.setAutoStartup(true);
        apImplScheduler.setOverwriteExistingJobs(true);
        apImplScheduler.setTriggers(mutationApplicationUpdateCronTrigger().getObject());
        return apImplScheduler;
    }

    @Bean("mutationApplicationUpdateJob")
    public MutationApplicationUpdateJob mutationApplicationUpdateJob() {
        return new MutationApplicationUpdateJob();
    }

    @Bean
    public JobDetailFactoryBean mutationApplicationUpdateJobDetail() {
        JobDetailFactoryBean mutationApplicationUpdateJobDetail = new JobDetailFactoryBean();
        mutationApplicationUpdateJobDetail.setGroup("AP_IMPL_JOB_GROUP");
        mutationApplicationUpdateJobDetail.setName("AP_IMPL_MUTATION_APP_UPDATE_JOB");
        mutationApplicationUpdateJobDetail.setDurability(true);
        mutationApplicationUpdateJobDetail.setJobClass(MutationApplicationUpdateJob.class);
        mutationApplicationUpdateJobDetail.setRequestsRecovery(false);
        Map<String, String> jobDetailMap = new HashMap<>();
        jobDetailMap.put("jobBeanName", "mutationApplicationUpdateJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "false");
        jobDetailMap.put("moduleName", "ap-impl");
        mutationApplicationUpdateJobDetail.setJobDataAsMap(jobDetailMap);
        return mutationApplicationUpdateJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean mutationApplicationUpdateCronTrigger() {
        CronTriggerFactoryBean mutationApplicationUpdate = new CronTriggerFactoryBean();
        mutationApplicationUpdate.setJobDetail(mutationApplicationUpdateJobDetail().getObject());
        mutationApplicationUpdate.setGroup("AP_IMPL_TRIGGER_GROUP");
        mutationApplicationUpdate.setName("AP_IMPL_MUTATION_APP_UPDATE_TRIGGER");
        mutationApplicationUpdate.setCronExpression("0 */30 * * * ?");
        mutationApplicationUpdate.setMisfireInstruction(MISFIRE_INSTRUCTION_DO_NOTHING);
        return mutationApplicationUpdate;
    }
}
