/*
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 *         1) All versions of this program, verbatim or modified must carry this
 *            Legal Notice.
 *
 *         2) Any misrepresentation of the origin of the material is prohibited. It
 *            is required that all modified versions of this material be marked in
 *            reasonable ways as different from the original version.
 *
 *         3) This license does not grant any rights to any user of the program
 *            with regards to rights under trademark law for use of the trade names
 *            or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.ap.collection.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ServiceModuleMapping;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.RestReceiptInfo;
import org.egov.collection.integration.services.PaymentInfoService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.commons.Installment;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import static org.egov.ptis.constants.PropertyTaxConstants.SERVICE_CODE_PROPERTYTAX;
import static org.egov.ptis.constants.PropertyTaxConstants.SERVICE_CODE_VACANTLANDTAX;
import static org.egov.ptis.constants.PropertyTaxConstants.SERVICE_CODE_MUTATION;
import static org.egov.ptis.constants.PropertyTaxConstants.DEMANDRSN_STR_ADVANCE;
import static org.egov.ptis.constants.PropertyTaxConstants.PAYMENT_TYPE_PARTIALLY;
import static org.egov.ptis.constants.PropertyTaxConstants.PAYMENT_TYPE_FULLY;
import static org.egov.ptis.constants.PropertyTaxConstants.PAYMENT_TYPE_ADVANCE;
import static org.egov.wtms.utils.constants.WaterTaxConstants.COLLECTION_STRING_SERVICE_CODE;

@Service("paymentInfoService")
public class PaymentInfoServiceImpl implements PaymentInfoService {

    @SuppressWarnings("rawtypes")
    @Autowired
    @Qualifier("persistenceService")
    private PersistenceService persistenceService;

    @SuppressWarnings("rawtypes")
    @Autowired
    private InstallmentHibDao installmentDao;

    @Autowired
    private ReceiptHeaderService receiptHeaderService;

    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;

    @Override
    public void setPaymentInfo(RestReceiptInfo restReceiptInfo, ReceiptHeader receiptHeader) {
        String[] paidFrom = null;
        String[] paidTo = null;
        Installment fromInstallment = null;
        Installment toInstallment = null;
        BigDecimal totalAmountToBePaid = BigDecimal.ZERO;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            if (receiptDetail.getCramountToBePaid() != null
                    && receiptDetail.getCramountToBePaid().compareTo(BigDecimal.ZERO) > 0
                    && !receiptDetail.getDescription().contains(DEMANDRSN_STR_ADVANCE))
                totalAmountToBePaid = totalAmountToBePaid.add(receiptDetail.getCramountToBePaid());
        }
        /*
         * Currently, Service Module Mapping is added only for PTIS
         */
        ServiceModuleMapping serviceModuleMapping = (ServiceModuleMapping) persistenceService.find(
                "from ServiceModuleMapping smm where smm.serviceDetails.code = ? ",
                receiptHeader.getService().getCode());
        if (serviceModuleMapping != null
                && serviceModuleMapping.getServiceDetails().getCode().equals(receiptHeader.getService().getCode())
                && totalAmountToBePaid.compareTo(BigDecimal.ZERO) > 0
                && !receiptHeader.getService().getCode().equals(COLLECTION_STRING_SERVICE_CODE)) {

            if (receiptHeader.getService().getCode().equals(SERVICE_CODE_PROPERTYTAX)
                    || receiptHeader.getService().getCode().equals(SERVICE_CODE_VACANTLANDTAX)) {
                List<ReceiptDetail> receiptDetailsList = new ArrayList<ReceiptDetail>(
                        receiptHeader.getReceiptDetails());
                Collections.sort(receiptDetailsList, new Comparator<ReceiptDetail>() {
                    @Override
                    public int compare(ReceiptDetail receiptDetail1, ReceiptDetail receiptDetail2) {
                        if (receiptDetail1.getOrdernumber() != null && receiptDetail2.getOrdernumber() != null)
                            return receiptDetail1.getOrdernumber().compareTo(receiptDetail2.getOrdernumber());
                        return 0;
                    }
                });

                for (ReceiptDetail receiptDetail : receiptDetailsList) {
                    if (receiptDetail.getCramount().compareTo(BigDecimal.ZERO) > 0
                            && !receiptDetail.getDescription().contains(DEMANDRSN_STR_ADVANCE)) {
                        if (paidFrom == null)
                            paidFrom = receiptDetail.getDescription().split("-", 2);
                        paidTo = receiptDetail.getDescription().split("-", 2);
                    }
                }

                if (paidFrom != null)
                    fromInstallment = installmentDao.getInsatllmentByModuleAndDescription(
                            serviceModuleMapping.getModule(), paidFrom[1].toString());
                if (paidTo != null)
                    toInstallment = installmentDao.getInsatllmentByModuleAndDescription(
                            serviceModuleMapping.getModule(), paidTo[1].toString());
                if (totalAmountToBePaid.compareTo(BigDecimal.ZERO) == 0) {
                    restReceiptInfo.setPaymentPeriod(StringUtils.EMPTY);
                    restReceiptInfo.setPaymentType(PAYMENT_TYPE_ADVANCE);
                } else
                    restReceiptInfo.setPaymentPeriod("Paid from "
                            .concat(DateUtils.getDefaultFormattedDate(fromInstallment.getFromDate())).concat(" To ")
                            .concat(DateUtils.getDefaultFormattedDate(toInstallment.getToDate())));
            } else if (receiptHeader.getService().getCode().equals(SERVICE_CODE_MUTATION)) {
                restReceiptInfo.setPaymentPeriod("Paid from "
                        .concat(DateUtils.getDefaultFormattedDate(receiptHeader.getReceiptdate())).concat(" To ")
                        .concat(DateUtils.getDefaultFormattedDate(receiptHeader.getReceiptdate())));
            } else {
                restReceiptInfo.setPaymentPeriod(StringUtils.EMPTY);
            }
        } else
            restReceiptInfo.setPaymentPeriod(receiptHeaderService.getAdditionalInfoForReceipt(
                    receiptHeader.getService().getCode(),
                    new BillReceiptInfoImpl(receiptHeader, chartOfAccountsHibernateDAO, persistenceService, null)));

        if (receiptHeader.getTotalAmount().compareTo(totalAmountToBePaid) > 0)
            restReceiptInfo.setPaymentType(PAYMENT_TYPE_ADVANCE);
        else if (totalAmountToBePaid.compareTo(receiptHeader.getTotalAmount()) > 0)
            restReceiptInfo.setPaymentType(PAYMENT_TYPE_PARTIALLY);
        else
            restReceiptInfo.setPaymentType(PAYMENT_TYPE_FULLY);

    }

}
