package org.egov.ap.aadhaar.webservice.client.impl;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.egov.infra.aadhaar.webservice.contract.AadhaarInfo;

@XmlRootElement(name = "getAadhaarInfoResponse", namespace = "http://srdhuidinfoservices/ecentric/com/xsd")
@XmlAccessorType(XmlAccessType.FIELD)
public class AadhaarInfoImpl extends AadhaarInfo {

    private static final long serialVersionUID = 6091570091083799419L;

    @XmlElement(name = "return")
    private Return returns;

    @Override
    public String getName() {
        return name = returns.name;
    }

    @Override
    public String getPhone() {
        return phone = returns.phoneNo.equals("101") ? "" : returns.phoneNo;
    }

    @Override
    public String getDob() {
        return dob = returns.dob;
    }

    @Override
    public String getGender() {
        return gender = returns.gender;
    }

    @Override
    public String getCareof() {
        return careof = returns.careof.equals("101") ? "" : returns.careof;
    }

    @Override
    public String getUid() {
        return uid = returns.uid.equals("101") ? "" : returns.uid;
    }

    @Override
    public String getEid() {
        return eid = returns.eid.equals("101") ? "" : returns.eid;
    }

    @XmlAccessorType(XmlAccessType.FIELD)
    public static class Return {
        @XmlElement
        private String buildingName;
        @XmlElement
        private String careof;
        @XmlElement
        private String district;
        @XmlElement
        private String district_name;
        @XmlElement
        private String dob;
        @XmlElement
        private String eid;
        @XmlElement
        private String gender;
        @XmlElement
        private String mandal;
        @XmlElement
        private String mandal_name;
        @XmlElement
        private String name;
        @XmlElement
        private String phoneNo;
        @XmlElement
        private String pincode;
        @XmlElement
        private String srdhwstxn;
        @XmlElement
        private String statecode;
        @XmlElement
        private String status;
        @XmlElement
        private String street;
        @XmlElement
        private String uid;
        @XmlElement
        private String village;
        @XmlElement
        private String village_name;
    }
}
