CREATE OR REPLACE FUNCTION vlt_migrateassessmtCity()
RETURNS bigint AS
$BODY$
DECLARE
asmstr vlt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN

	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from vlt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and c_prptype='V')
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'vlt_migrateassessmtCity : Started for assessment no (%)', v_assessmentno;
			v_temp  := vlt_migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'vlt_migrateassessmtCity : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
return v_migCount;
END;
$BODY$ LANGUAGE plpgsql;

-------------------------------------------------------end------------------------------------------------------------

----------------------------------------------------create vlt_migrateassessmtWard------------------------------------

CREATE OR REPLACE FUNCTION vlt_migrateassessmtWard(wardCode IN bigint)
RETURNS bigint AS
$BODY$
DECLARE
asmstr vlt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from vlt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and i_rwobjid=wardCode and c_prptype='V')
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'vlt_migrateassessmtWard : Started for assessment no (%)', v_assessmentno;
			v_temp  := vlt_migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'vlt_migrateassessmtWard : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
return v_migCount;
END;
$BODY$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------


---------------------------------------------------create vlt_migrateassessmtblock------------------------------------

CREATE OR REPLACE FUNCTION vlt_migrateassessmtblock(blockCode IN bigint)
RETURNS void AS
$BODY$
DECLARE
asmstr vlt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from vlt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and i_blckobjid=blockCode and c_prptype='V')
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'vlt_migrateassessmtblock : Started for assessment no (%)', v_assessmentno;
			v_temp  := vlt_migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'vlt_migrateassessmtblock : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------

---------------------------------------create vlt_migrateSingleAssess-------------------------------------------------

CREATE OR REPLACE FUNCTION vlt_migrateSingleAssess(assessmentNo IN integer, idsource IN bigint, currinst IN bigint, currinstdesc IN varchar(16), idModule IN bigint)
RETURNS bigint AS
$BODY$
DECLARE

v_idinstall bigint;
v_addressid bigint;
v_idpropid bigint;
v_idowner bigint;
v_idbasic bigint;
v_idprop bigint;
v_idpropdet bigint;
v_idmigcoll bigint;
v_idownerlk bigint;
v_iddmd bigint;
v_iddmdcalc bigint;
v_houseno varchar(400);
v_zone int;
v_ward int;
v_block int;
v_locality int;
v_eward int;
v_street int;
v_assmtdate date;
v_corraddr1 varchar(400); 
v_corraddr2 varchar(400);
v_isExempted character;
v_arv double precision;
v_totaltax double precision;
v_exemptionReason integer;
v_delflag character;
BEGIN
	begin
		--raise notice 'vlt_migrateSingleAssess : Started for assessment no (% % % % %)', assessmentNo, idsource, currinst, currinstdesc, idModule;
		select asmtmstr.vc_onrdoorno, asmtmstr.i_zoneobjid, asmtmstr.i_rwobjid, asmtmstr.i_blckobjid, asmtmstr.i_lctyobjid, asmtmstr.i_strtobjid, asmtmstr.i_ewobjid, asmtmstr.dt_taxassddt, asmtmstr.vc_onraddr1, asmtmstr.vc_onraddr2, asmtmstr.c_xptn, asmtmstr.i_xptnpcode, asmtmstr.d_arv, (coalesce(asmtmstr.d_fxdvlt,0)+coalesce(asmtmstr.d_fxded,0)+coalesce(asmtmstr.d_fxdlcs,0)), asmtmstr.c_delflag
		into v_houseno, v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag
		from vlt_asmt_mstr_tbl asmtmstr where asmtmstr.i_asmtno = assessmentNo and asmtmstr.c_prptype='V';
		--raise notice 'vlt_migrateSingleAssess v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag (% % % % % % % % % % % % % % % %)', v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag;
		select id into v_idinstall from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and v_assmtdate between start_date and end_date;
		--raise notice 'vlt_migrateSingleAssess : v_idinstall 1(%)', v_idinstall;
		if (v_idinstall is null) then
			select id into v_idinstall from eg_installment_master where start_date=(select min(inst.start_date) from vlt_arrear_tbl arr, eg_installment_master inst where inst.id_module=idModule and arr.i_asmtno=assessmentNo and arr.vc_dmndyear=inst.description) and id_module=idModule;
		end if;
		if (v_idinstall is null) then
			v_idinstall := currinst;
		end if;
		--raise notice 'vlt_migrateSingleAssess : v_idinstall 2(%)', v_idinstall;
		--raise notice 'vlt_migrateSingleAssess : got installment (%)', v_idinstall;
		v_addressid := createAddress(v_houseno, v_locality, v_ward);
		--raise notice 'vlt_migrateSingleAssess : address created (%)', v_addressid;
		v_idpropid := vlt_createPropertyid(v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate, assessmentNo);
		--raise notice 'vlt_migrateSingleAssess : propertyid created (%)', v_idpropid;
		v_idowner := vlt_createOwner(assessmentNo, v_corraddr1, v_corraddr2, v_addressid);
		--raise notice 'vlt_migrateSingleAssess : owner created (%)', v_idowner;
		v_idbasic := vlt_createBasicProp(assessmentNo, v_addressid, v_idpropid, v_eward, v_delflag);
		--raise notice 'vlt_migrateSingleAssess : Basicproperty created (%)', v_idbasic;
		v_idownerlk := linkOwner(v_idbasic, idsource, v_idowner);
		--raise notice 'vlt_migrateSingleAssess : Owner linked (%)', v_idownerlk;
		v_idprop := createProperty(v_assmtdate, idsource, v_idbasic, v_isExempted, v_exemptionReason, v_idinstall);
		--raise notice 'vlt_migrateSingleAssess : Property Created (%)', v_idprop;
		v_idpropdet := vlt_createPropertyDet(assessmentNo, v_idprop);
		--raise notice 'Property Details created (%)', v_idpropdet;
		v_iddmd := vlt_createDemand(assessmentNo, v_idprop, currinst, v_assmtdate, idModule, v_arv, currinstdesc);
		--raise notice 'vlt_migrateSingleAssess : Demand created';
		v_iddmdcalc := createDemandCalc(v_iddmd, v_totaltax, currinst, v_assmtdate, v_arv);
		--raise notice 'vlt_migrateSingleAssess : createDemandCalc created';
		v_idmigcoll := vlt_migrateCollection(assessmentNo, v_iddmd);
		--raise notice 'Collection created';
		update vlt_asmt_mstr_tbl set ismigrated='Y' where i_asmtno=assessmentNo;
		return v_idmigcoll;
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'vlt_migrateSingleAssess : % %', SQLERRM, SQLSTATE;
	update vlt_asmt_mstr_tbl set error = SQLSTATE || '-' || SQLERRM where i_asmtno=assessmentNo;
	END;
END;
$BODY$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------

---------------------------------------create vlt_createPropertyid----------------------------------------------------

create or replace FUNCTION vlt_createPropertyid(zone IN int, ward IN int, block IN int, locality IN int, street IN int, eleward IN int, assessmentdate IN date, assessmentNo IN integer)  
RETURNS numeric as $$
declare
	v_pidpk 	bigint;  
	v_isbndryloaded	bigint default 1;
BEGIN 
	--raise notice 'vlt_createPropertyid zone, ward, block, locality, street, eleward, assessmentdate (% % % % % % %)',zone, ward, block, locality, street, eleward, assessmentdate;
	select nextval('seq_egpt_propertyid') into v_pidpk;
	INSERT INTO egpt_propertyid(id, zone_num, ward_adm_id, adm1, adm2, adm3, created_date, modified_date, created_by, modified_by, elect_bndry, north_bounded, south_bounded, east_bounded, west_bounded)
    VALUES (v_pidpk, (select egovcode from eg_stg_zone where code=zone), (select egovcode from eg_stg_ward where code=ward), (select egovcode from eg_stg_block where code=block and wardcode=ward), (select egovcode from eg_stg_locality where code=locality), (select egovcode from eg_stg_street where code=street), assessmentdate, assessmentdate, 1, 1, (select egovcode from eg_stg_election where code=eleward), (select vc_nrth from vlt_asmt_mstr_tbl vlt where assessmentNo=vlt.i_asmtno ), (select vc_soth from vlt_asmt_mstr_tbl vlt where assessmentNo=vlt.i_asmtno ), (select vc_east from vlt_asmt_mstr_tbl vlt where assessmentNo=vlt.i_asmtno ), (select vc_west from vlt_asmt_mstr_tbl vlt where assessmentNo=vlt.i_asmtno ));
	--raise notice 'vlt_createPropertyid Propertyid created';
return v_pidpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'vlt_createPropertyid : % %', SQLERRM, SQLSTATE;
END; 
$$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------

---------------------------------------create vlt_createOwner---------------------------------------------------------

create or replace FUNCTION vlt_createOwner(assessmentNo IN integer, corraddr1 IN varchar(400), corraddr2 IN varchar(400), addressid IN bigint)  
RETURNS numeric as $$
declare
	v_userpk 	bigint;  
	v_addresspk	bigint;
BEGIN 
	--raise notice 'vlt_createOwner assessmentNo, corraddr1, corraddr2, addressid (% % % % %)', assessmentNo, corraddr1, corraddr2, addressid;
	select nextval('seq_eg_address') into v_addresspk;
	select nextval('seq_eg_user') into v_userpk;
	INSERT INTO eg_user(id, locale, username, password, mobilenumber, emailid, createddate, lastmodifieddate, createdby, lastmodifiedby, active, name, gender, type, guardian, guardianrelation)
    select v_userpk, 'en_IN', generateUsername(substring(vc_onrsurname from 1 for 8), substring(vc_onrname from 1 for 8)), 'NOT SET', vc_onrmobino, vc_onreid, dt_taxassddt, dt_taxassddt, 1, 1, TRUE, trim((coalesce(vc_onrsurname,'') ||' '|| coalesce(vc_onrname,''))), (CASE WHEN c_sex = 'F' THEN 0 ELSE 1 END), 'CITIZEN', vc_fthrsurname ||' '|| vc_fthrname, 'Father' from vlt_asmt_mstr_tbl where i_asmtno=assessmentNo;
	--raise notice 'vlt_createOwner Owner created';
IF (corraddr1 IS NOT NULL OR corraddr2 IS NOT NULL) AND (length(corraddr1)>0 OR length(corraddr2)>0) then
	--raise notice 'vlt_createOwner Corr Address available';
    INSERT INTO eg_address(type, streetroadline, arealocalitysector, pincode, id, userid)
    values ('CORRESPONDENCE', corraddr1, corraddr2, NULL, v_addresspk, v_userpk);
	insert into eg_correspondence_address (id) values (v_addresspk);
	--raise notice 'vlt_createOwner Owner address created with available corr address';
else
	--raise notice 'vlt_createOwner Corr Address NOT available';
	INSERT INTO eg_address(housenobldgapt, type, streetroadline, arealocalitysector, pincode, id, userid)
	select housenobldgapt, 'CORRESPONDENCE', streetroadline, arealocalitysector, pincode, v_addresspk, v_userpk from eg_address where id=addressid;
	insert into eg_correspondence_address (id) values (v_addresspk);
	--raise notice 'vlt_createOwner Owner address created with property address';
END IF;

return v_userpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'vlt_createOwner : % %', SQLERRM, SQLSTATE;
END;  
$$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------

---------------------------------------create vlt_createBasicProp-----------------------------------------------------

create or replace FUNCTION vlt_createBasicProp(assessmentNo IN integer, addressid bigint, id_propertyid bigint, eleWard IN integer, isactive IN character)  
RETURNS numeric as $$
declare
	v_basicpk 	bigint;
	v_ulbcode	character varying;
BEGIN 
	--raise notice 'vlt_createBasicProp assessmentNo, addressid, idBasicProp, id_propertyid, ward, isactive (% % % % % %)',assessmentNo, addressid, idBasicProp, id_propertyid, ward, isactive;
	select code into v_ulbcode from eg_city;
	select nextval('seq_egpt_basic_property') into v_basicpk;
INSERT INTO egpt_basic_property(id, createdby, propertyid, isactive, addressid, createddate, lastmodifieddate, id_propertyid, municiapl_no_old, id_adm_bndry, id_prop_create_reason, prop_occupancy_date, status, modifiedby, regd_doc_no, regd_doc_date, assessmentdate, source)
	select v_basicpk, 1, i_asmtno, (CASE WHEN isactive = 'N' THEN TRUE ELSE FALSE END), addressid, dt_taxassddt, dt_taxassddt, id_propertyid, vc_oldasmtno, (select egovcode from eg_stg_election where code=eleWard), (select id from EGPT_MUTATION_MASTER where type='CREATE' and code='NEW'), dt_taxassddt, (select id from egpt_status where code='ASSESSED'), 1, vc_rdocno, dt_rdocdt, dt_taxassddt, 'M' from vlt_asmt_mstr_tbl where i_asmtno=assessmentNo;
	--raise notice 'vlt_createBasicProp basicproperty created';
return v_basicpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'vlt_createBasicProp : % %', SQLERRM, SQLSTATE;
END; 
$$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------

-------------------------------------------create vlt_createPropertyDet-----------------------------------------------

create or replace FUNCTION vlt_createPropertyDet(assessmentNo IN integer, idproperty IN bigint)  
RETURNS numeric as $$
declare
	v_pdpk 	bigint;
BEGIN 
	--raise notice 'vlt_createPropertyDet assessmentNo, idproperty (% %)',assessmentNo, idproperty;
	select nextval('seq_egpt_property_detail') into v_pdpk;
	INSERT INTO egpt_property_detail(id, id_property, lift, toilets, watertap, structure, electricity, attachedbathroom, waterharvesting, cable, extentsite, extent_appurtenant_land, sital_area, property_type, id_propertytypemaster, id_mutation, updt_timestamp, pattanumber, survey_num, marketvalue, current_capitalvalue, category_type )
		select v_pdpk, idproperty, false, false, false, false, false, false, false, false, 0, 0, coalesce(d_totlnd, 0), 'VacantProperty', (select id from egpt_property_type_master where code='VAC_LAND'), (select id from EGPT_MUTATION_MASTER where type='CREATE' and code='NEW'), dt_taxassddt, vc_pattano, vc_srvyno, d_mrktareraval, d_crncptlval, vlt_setCategoryType(assessmentNo)  from vlt_asmt_mstr_tbl ptmstr where i_asmtno=assessmentNo;
	--raise notice 'vlt_createPropertyDet PropertyDetail Created';
return v_pdpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'vlt_createPropertyDet : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------

----------------------------------------create vlt_createDemand-------------------------------------------------------

create or replace FUNCTION vlt_createDemand(assessmentNo IN bigint, idProp IN bigint, currInst IN bigint, assessmentdate IN date, idModule IN bigint, arv double precision, currInstDesc varchar(16)) 
RETURNS numeric as $$
declare
	v_demandpk 	bigint; 
	v_dmddet 	bigint; 
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_proptax 	double precision;
	v_educess 	double precision;
	v_libcess 	double precision;
	v_unauthtax	double precision;
	v_totaltax	double precision;
	v_arreartax	double precision;
	v_curr1stinst   bigint;
	v_curr2ndinst   bigint;
	arrearDmds 	vlt_arrear_tbl%ROWTYPE;
	dmndRgtrFrstHlf vlt_dmndrgtr_tbl%ROWTYPE;
	v_currFrstHlfId bigint;
	v_currSecondHlfId bigint;
	dmndRgtrSecondHlf vlt_dmndrgtr_tbl%ROWTYPE;
BEGIN 
	--raise notice 'createDemand 1st half started for assessmentNo, idProp, currInst, assessmentdate, idModule (% % % % %)',assessmentNo, idProp, currInst, assessmentdate, idModule;
	

	select id into v_curr1stinst from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and '2017-04-01' between start_date and end_date;
	select nextval('seq_eg_demand') into v_demandpk;
	INSERT INTO eg_demand(id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected)
    VALUES (v_demandpk, v_curr1stinst, v_totaltax, 'N', assessmentdate, assessmentdate, 0);

	insert into egpt_ptdemand (id_demand, id_property) values (v_demandpk, idProp);

--Migrating current firsthalf demand
--raise notice 'vlt_createDemand 1st half started ';
	for dmndRgtrFrstHlf in (select * from vlt_dmndrgtr_tbl where c_delflag='N' and i_asmtno =assessmentNo and vc_dmndyear='2017-2018-1')
		loop 
			begin
				select id into v_currFrstHlfId from eg_installment_master where id_module=idModule and description=dmndRgtrFrstHlf.vc_dmndyear;
				v_temp := vlt_createInstDemandDetail(v_demandpk, v_currFrstHlfId, dmndRgtrFrstHlf.d_crnvlt, dmndRgtrFrstHlf.d_crned, dmndRgtrFrstHlf.d_crnlcs, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'vlt_createDemand, failed while adding current first half demand : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;

--Migrating current secondhalf demand

--raise notice 'vlt_createDemand 2nd half started ';

	for dmndRgtrSecondHlf in (select * from vlt_dmndrgtr_tbl where c_delflag='N' and i_asmtno =assessmentNo and vc_dmndyear='2017-2018-2')
		loop 
			begin
				select id into v_currSecondHlfId from eg_installment_master where id_module=idModule and description=dmndRgtrSecondHlf.vc_dmndyear;
				v_temp := vlt_createInstDemandDetail(v_demandpk, v_currSecondHlfId, dmndRgtrSecondHlf.d_crnvlt, dmndRgtrSecondHlf.d_crned, dmndRgtrSecondHlf.d_crnlcs, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'vlt_createDemand, failed while adding current first half demand : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;

--raise notice 'vlt_createDemand Arrears started ';

	begin
		select sum(coalesce(d_arrvlt, 0) + coalesce(d_arred, 0) + coalesce(d_arrlcs, 0)) into v_arreartax from vlt_arrear_tbl where c_delflag='N' and i_asmtno=assessmentNo;
		if(v_arreartax>0)then
		for arrearDmds in (select * from vlt_arrear_tbl where c_delflag='N' and i_asmtno =assessmentNo )
		loop 
			begin
				select id into v_idinst from eg_installment_master where id_module=idModule and description=arrearDmds.vc_dmndyear;
				v_temp := vlt_createInstDemandDetail(v_demandpk, v_idinst, arrearDmds.d_arrvlt, arrearDmds.d_arred, arrearDmds.d_arrlcs, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'vlt_createDemand, failed while adding arrears : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;
		end if;
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'vlt_createDemand, failed while checking arrears : % %', SQLERRM, SQLSTATE;
	END;
--raise notice 'createDemand completed ';
return v_demandpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'vlt_createDemand : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
-------------------------------------------------------end------------------------------------------------------------

-------------------------------------------create vlt_migrateCollection-----------------------------------------------

create or replace FUNCTION vlt_migrateCollection(assessmentNo IN bigint, idDemand IN bigint)
RETURNS bigint as $$
declare
v_mindate	date;
v_maxdate	date;
v_instfdate	timestamp without time zone;
v_insttdate	timestamp without time zone;
dds record;
v_currvlt	double precision;
v_currlcs	double precision;
v_currunauthplty double precision;
v_dmndrsn 	character varying;
v_advncamt	double precision;
v_moduleId	bigint;
v_asmtdate	date;
v_temp		integer;
v_dmddetpk 	bigint;
v_stime		timestamp without time zone;
v_etime		timestamp without time zone;
BEGIN 
	--select now() into v_stime;
	--raise notice 'migrateCollection assessmentNo, idDemand, time (% % %)',assessmentNo, idDemand, v_stime;

--Migrating 2016-2017-1 installment

--raise notice 'Migrating 2016-2017-1 installment ';

	v_advncamt := 0;
	select sum(d_crnvlt) total, sum(d_crnlcs) total, min(dt_paidfrmprddt), max(dt_paidtoprddt) into v_currvlt, v_currlcs, v_currunauthplty, v_mindate, v_maxdate from vlt_asmtrcvlt_tbl where i_asmtno=assessmentNo and C_ISRLSD <> 'X' AND C_DELFLAG = 'N' and dt_rcptdt>='2017-04-01' and dt_paidfrmprddt='2017-04-01' and dt_paidtoprddt='2017-09-30';
	--raise notice 'migrateCollection v_collection, v_mindate, v_maxdate (% % %)',v_collection, v_mindate, v_maxdate;
	if (v_mindate is not null) then
	select inst.start_date into v_instfdate from eg_installment_master inst where v_mindate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');

	select inst.end_date into v_insttdate from eg_installment_master inst where v_maxdate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');
	
	for dds in (SELECT dd.id ddid, dd.amount, dm.code dmcode FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst, eg_demand_reason_master dm where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id and dr.id_demand_reason_master=dm.id and inst.start_date>=v_instfdate and inst.end_date<=v_insttdate order by inst.start_date)
	loop 
		begin
			v_dmndrsn := dds.dmcode;
			--raise notice 'Demand Reason : %', v_dmndrsn;
			if v_currvlt>0 and (v_dmndrsn = 'VAC_LAND_TAX') then
				if(v_currvlt > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_currvlt - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currvlt where id=dds.ddid;
				end if;
			end if;
			if v_currlcs>0 and (v_dmndrsn = 'LIB_CESS') then
				if(v_currlcs > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currlcs - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currlcs where id=dds.ddid;
				end if;
			end if;
			--raise notice 'migrateCollection after adjust v_collection (%)',v_collection;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'vlt_migrateCollection, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	end if;

--raise notice 'Advance before 2nd half : %', v_advncamt;

--Migrating 2016-2017-2 installment
--raise notice 'Migrating 2016-2017-1 installment ';

select sum(d_crnvlt) total, sum(d_crnlcs) total, min(dt_paidfrmprddt), max(dt_paidtoprddt) into v_currvlt, v_currlcs, v_currunauthplty, v_mindate, v_maxdate from vlt_asmtrcvlt_tbl where i_asmtno=assessmentNo and C_ISRLSD <> 'X' AND C_DELFLAG = 'N' and dt_rcptdt>='2017-04-01' and dt_paidfrmprddt='2017-10-01' and dt_paidtoprddt='2018-03-31';
	--raise notice 'migrateCollection v_collection, v_mindate, v_maxdate (% % %)',v_collection, v_mindate, v_maxdate;
	if (v_mindate is not null) then
	select inst.start_date into v_instfdate from eg_installment_master inst where v_mindate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');

	select inst.end_date into v_insttdate from eg_installment_master inst where v_maxdate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');
	
	for dds in (SELECT dd.id ddid, dd.amount, dm.code dmcode, inst.id instid FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst, eg_demand_reason_master dm where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id and dr.id_demand_reason_master=dm.id and inst.start_date>=v_instfdate and inst.end_date<=v_insttdate order by inst.start_date)
	loop 
		begin
			v_dmndrsn := dds.dmcode;
			--raise notice 'Demand Reason : %', v_dmndrsn;
			if v_currvlt>0 and (v_dmndrsn = 'VAC_LAND_TAX') then
				if(v_currvlt > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currvlt - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currvlt where id=dds.ddid;
				end if;
			end if;
			if v_currlcs>0 and (v_dmndrsn = 'LIB_CESS') then
				if(v_currlcs > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currlcs - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currlcs where id=dds.ddid;
				end if;
			end if;
		--raise notice 'Advance after 1st half : %', v_advncamt;
		
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'vlt_migrateCollection, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	end if;
	if v_advncamt > 0 then
			select dt_taxassddt into v_asmtdate from vlt_asmt_mstr_tbl where i_asmtno=assessmentNo;
			select id into v_moduleId from eg_module where name='Property Tax';

			select nextval('seq_eg_demand_details') into v_dmddetpk;
	INSERT INTO eg_demand_details(id, id_demand, id_demand_reason, amount, modified_date, create_date, amt_collected)
	VALUES (v_dmddetpk, idDemand, getDemandReason(dds.instid, 'ADVANCE', v_moduleId ), 0, v_asmtdate, v_asmtdate, v_advncamt);
		end if;
	--select now() into v_etime;
	--raise notice 'migrateCollection completed at %', v_etime;
return 1;
EXCEPTION
WHEN OTHERS THEN
raise notice 'vlt_migrateCollection : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

----------------------------------------------create vlt_loadReceipts-------------------------------------------------

CREATE OR REPLACE FUNCTION vlt_loadReceipts()
RETURNS character varying AS
$BODY$
declare
	
	v_isreceiptsloaded	bigint default 1;
BEGIN
	begin
		insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
		select nextval('seq_egpt_property_receipts'), bp.id, i_bookno::character varying, trim(i_slno::character varying), dt_etrydt, dt_paidfrmprddt, dt_paidtoprddt, (coalesce(d_arrpt,0) + coalesce(d_arred,0) + coalesce(d_arrlcs,0) + coalesce(d_pltyonarr,0) + coalesce(d_crnvlt,0) + coalesce(d_crned,0) + coalesce(d_crnlcs,0) + coalesce(d_pltyoncrn,0) + coalesce(d_advamt,0)) from vlt_asmtrcvlt_tbl rcpt, egpt_basic_property bp where bp.propertyid=rcpt.i_asmtno::character varying and rcpt.c_delflag='N' and rcpt.C_ISRLSD <> 'X';
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'vlt_loadReceipts, loading VLT Receipts failed : % %', SQLERRM, SQLSTATE;
	v_isreceiptsloaded := 0;
	END;
RAISE NOTICE 'VLT Receipts loaded';
return v_isreceiptsloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
