--------------------------------------load assessment master----------------------------------------------------------

CREATE OR REPLACE FUNCTION loadAssessmentMaster()
  RETURNS character varying AS
$BODY$
declare
	v_strucpk 	bigint; 
	v_usagepk 	bigint;
	v_floortypepk 	bigint;
	v_rooftypepk 	bigint;
	v_woodtypepk 	bigint;
	v_walltypepk 	bigint;
	v_exemptionpk 	bigint;
	v_apartmentpk 	bigint;
	v_occupancypk 	bigint;
	v_titlereason	bigint;
	v_isassmasterloaded	bigint default 1;
	bldgclass egpt_stg_bldgclass_mater%ROWTYPE;
	usageMstr egpt_stg_usagemaster%ROWTYPE;
	floorType egpt_stg_floortype%ROWTYPE;
	roofType egpt_stg_rooftype%ROWTYPE;
	wallType egpt_stg_walltype%ROWTYPE;
	woodType egpt_stg_woodtype%ROWTYPE;
	exemption egpt_stg_exemption%ROWTYPE;
	apartment egpt_stg_apartment%ROWTYPE;
	occupancy egpt_stg_occupancy%ROWTYPE;
	titlereasons pt_doctype_mstr_tbl%ROWTYPE;
BEGIN 
begin
	--Building Classification
	for bldgclass in (select * from egpt_stg_bldgclass_mater where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_struc_cl') into v_strucpk;
				INSERT INTO egpt_struc_cl(id, constr_num, constr_type, constr_descr, lastmodifieddate, is_history, createdby, code, order_id, from_date, to_date, createddate, lastmodifiedby, id_installment)
				VALUES (v_strucpk, 1, bldgclass.name, bldgclass.name, now(), 'N', 1, upper(substr(replace(replace(replace(bldgclass.name,'.',''),' ',''),',',''),1,16)), v_strucpk, to_date('01/04/2004', 'dd/mm/yyyy'), to_date('01/04/2099', 'dd/mm/yyyy'), now(), 1, (select id from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and current_timestamp between start_date and end_date));
				update egpt_stg_bldgclass_mater set egovcode =v_strucpk where code=bldgclass.code;		   
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading building classification failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Building Classification loaded';

	--Property Usage
	for usageMstr in (select * from egpt_stg_usagemaster where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_property_usage_master') into v_usagepk;
			   	INSERT INTO egpt_property_usage_master(id, usg_name, lastmodifieddate, code, order_id, from_date, to_date, is_enabled, createdby, lastmodifiedby, createddate, isresidential)
		        VALUES (v_usagepk, usageMstr.name, now(),upper(substr(replace(replace(replace(usageMstr.name,'.',''),' ',''),',',''),1,16)), v_usagepk, to_date('01/04/2004', 'dd/mm/yyyy') ,to_date('01/04/2099', 'dd/mm/yyyy'), 1, 1, 1, now(), FALSE);
				update egpt_stg_usagemaster set egovcode =v_usagepk where code=usageMstr.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Usage Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	update egpt_property_usage_master set isresidential = TRUE where upper(usg_name) like 'RESI%';
	RAISE NOTICE 'Property Usage loaded';

	--Floor Type
	for floorType in (select * from egpt_stg_floortype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_floor_type') into v_floortypepk;
			   	INSERT INTO egpt_floor_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_floortypepk, floorType.name, upper(substr(replace(replace(replace(floorType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_floortype set egovcode =v_floortypepk where code=floorType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Floor Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Floor type loaded';

	--Roof Type
	for roofType in (select * from egpt_stg_rooftype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_roof_type') into v_rooftypepk;
			   	INSERT INTO egpt_roof_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_rooftypepk, roofType.name, upper(substr(replace(replace(replace(roofType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_rooftype set egovcode =v_rooftypepk where code=roofType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Roof Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Roof type loaded';

	--Wood Type
	for woodType in (select * from egpt_stg_woodtype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_wood_type') into v_woodtypepk;
			   	INSERT INTO egpt_wood_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_woodtypepk, woodType.name, upper(substr(replace(replace(replace(woodType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_woodtype set egovcode =v_woodtypepk where code=woodType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Wood Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Wood type loaded';

	--Wall Type
	for wallType in (select * from egpt_stg_walltype where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_wall_type') into v_walltypepk;
			   	INSERT INTO egpt_wall_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_walltypepk, wallType.name, upper(substr(replace(replace(replace(wallType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_walltype set egovcode =v_walltypepk where code=wallType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Wall Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Wall type loaded';

	--Exemption Master
	for exemption in (select * from egpt_stg_exemption where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_exemption_reason') into v_exemptionpk;
				INSERT INTO egpt_exemption_reason(id, name, code, createddate, lastmodifieddate, createdby, lastmodifiedby)
		        VALUES (v_exemptionpk, exemption.name, upper(substr(replace(replace(replace(exemption.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_exemption set egovcode =v_exemptionpk where code=exemption.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Exemption Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Exemption Master loaded';

	--Apartment Master
	for apartment in (select * from egpt_stg_apartment where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_apartment') into v_apartmentpk;
				INSERT INTO egpt_apartment(id, name, code, createddate, lastmodifieddate, createdby, lastmodifiedby)
		        VALUES (v_apartmentpk, apartment.name, upper(substr(replace(replace(replace(apartment.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_apartment set egovcode =v_apartmentpk where code=apartment.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Apartment Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Apartment Master loaded';

	--Occupancy Master
	for occupancy in (select * from egpt_stg_occupancy where delflag='N' order by code)
		loop 
			begin
				select nextval('seq_egpt_occupation_type_master') into v_occupancypk;
				INSERT INTO egpt_occupation_type_master(id, occupation, lastmodifieddate, occupation_local, code, createdby, lastmodifiedby, createddate)
				VALUES (v_occupancypk, occupancy.name, now(), occupancy.name, upper(substr(replace(replace(replace(occupancy.name,'.',''),' ',''),',',''),1,10)), 1, 1, now());
				update egpt_stg_occupancy set egovcode =v_occupancypk where code=occupancy.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Occuapancy Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Occuapancy Master loaded';

	--Reasons for title transfer
	for titlereasons in (select * from pt_doctype_mstr_tbl where c_delflag='N')
		loop 
			begin
				select nextval('SEQ_EGPT_MUTATION_MASTER') into v_titlereason;
				Insert into egpt_mutation_master (ID,MUTATION_NAME,MUTATION_DESC,TYPE,CODE,ORDER_ID)
				VALUES (v_titlereason, titlereasons.vc_doctypedesc, titlereasons.vc_doctypedesc, 'TRANSFER', upper(substr(replace(replace(replace(titlereasons.vc_doctypedesc,'.',''),' ',''),',',''),1,10)), v_occupancypk);

				update egpt_stg_occupancy set egovcode =v_titlereason where code=occupancy.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Reasons for title transfer failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Reasons for title transfer loaded';
EXCEPTION
WHEN OTHERS THEN
raise notice 'loadAssessmentMaster failed : % %', SQLERRM, SQLSTATE;
v_isassmasterloaded := 0;
END;
return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
----------------------------------------------------------------------------------------------------------------------

----------------------------------------------Create Demand-----------------------------------------------------------

create or replace FUNCTION createDemand(assessmentNo IN bigint, idProp IN bigint, currInst IN bigint, assessmentdate IN date, idModule IN bigint, arv double precision, currInstDesc varchar(16)) 
RETURNS numeric as $$
declare
	v_demandpk 	bigint; 
	v_dmddet 	bigint; 
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_proptax 	double precision;
	v_educess 	double precision;
	v_libcess 	double precision;
	v_unauthtax	double precision;
	v_totaltax	double precision;
	v_arreartax	double precision;
	v_curr1stinst   bigint;
	v_curr2ndinst   bigint;
	arrearDmds 	pt_arrear_tbl%ROWTYPE;
	dmndRgtrFrstHlf pt_dmndrgtr_tbl%ROWTYPE;
	v_currFrstHlfId bigint;
	v_currSecondHlfId bigint;
	dmndRgtrSecondHlf pt_dmndrgtr_tbl%ROWTYPE;
BEGIN 
	--raise notice 'createDemand assessmentNo, idProp, currInst, assessmentdate, idModule (% % % %)',assessmentNo, idProp, currInst, assessmentdate, idModule;
	

	select id into v_curr1stinst from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and '2017-04-01' between start_date and end_date;
	select nextval('seq_eg_demand') into v_demandpk;
	INSERT INTO eg_demand(id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected)
    VALUES (v_demandpk, v_curr1stinst, v_totaltax, 'N', assessmentdate, assessmentdate, 0);

	insert into egpt_ptdemand (id_demand, id_property) values (v_demandpk, idProp);

--Migrating current firsthalf demand
	for dmndRgtrFrstHlf in (select * from pt_dmndrgtr_tbl where c_delflag='N' and i_asmtno =assessmentNo and vc_dmndyear='2017-2018-1')
		loop 
			begin
				select id into v_currFrstHlfId from eg_installment_master where id_module=idModule and description=dmndRgtrFrstHlf.vc_dmndyear;
				v_temp := createInstDemandDetail(v_demandpk, v_currFrstHlfId, dmndRgtrFrstHlf.d_crnpt, dmndRgtrFrstHlf.d_crned, dmndRgtrFrstHlf.d_crnlcs, dmndRgtrFrstHlf.d_crnuauthcnstplty, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'createDemand, failed while adding current first half demand : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;

--Migrating current secondhalf demand
	for dmndRgtrSecondHlf in (select * from pt_dmndrgtr_tbl where c_delflag='N' and i_asmtno =assessmentNo and vc_dmndyear='2017-2018-2')
		loop 
			begin
				select id into v_currSecondHlfId from eg_installment_master where id_module=idModule and description=dmndRgtrSecondHlf.vc_dmndyear;
				v_temp := createInstDemandDetail(v_demandpk, v_currSecondHlfId, dmndRgtrSecondHlf.d_crnpt, dmndRgtrSecondHlf.d_crned, dmndRgtrSecondHlf.d_crnlcs, dmndRgtrSecondHlf.d_crnuauthcnstplty, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'createDemand, failed while adding current first half demand : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;
	begin
		select sum(coalesce(d_arrpt, 0) + coalesce(d_arred, 0) + coalesce(d_arrlcs, 0) + coalesce(d_arruauthcnstplty, 0)) into v_arreartax from pt_arrear_tbl where c_delflag='N' and i_asmtno=assessmentNo;
		if(v_arreartax>0)then
		for arrearDmds in (select * from pt_arrear_tbl where c_delflag='N' and i_asmtno =assessmentNo )
		loop 
			begin
				select id into v_idinst from eg_installment_master where id_module=idModule and description=arrearDmds.vc_dmndyear;
				v_temp := createInstDemandDetail(v_demandpk, v_idinst, arrearDmds.d_arrpt, arrearDmds.d_arred, arrearDmds.d_arrlcs, arrearDmds.d_arruauthcnstplty, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'createDemand, failed while adding arrears : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;
		end if;
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'createDemand, failed while checking arrears : % %', SQLERRM, SQLSTATE;
	END;
return v_demandpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createDemand : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
----------------------------------------------------------------------------------------------------------------------


--------------------------------------------------Add Floors----------------------------------------------------------


create or replace FUNCTION addFloors(assessmentNo IN integer, assessmentdate IN date, idPropDet IN bigint, idDmdCal IN bigint)  
RETURNS numeric as $$
declare
	v_FlrDetpk bigint;
	v_FlrDmdCalc bigint;
	v_occDate_str character varying(10);
	floors pt_asmt_dtls_tbl%ROWTYPE;
BEGIN 
	--raise notice 'addFloors assessmentNo, assessmentdate, idPropDet, idDmdCal (% % % %)',assessmentNo, assessmentdate, idPropDet, idDmdCal;
select case when extract (month from assessmentdate) between 4 and 9 then '01/04/' else '01/10/' end into v_occDate_str;
for floors in (select * from pt_asmt_dtls_tbl where c_delflag='N' and i_asmtno = assessmentNo order by i_flrno)
	loop 
		begin
			select nextval('seq_egpt_floor_detail') into v_FlrDetpk;
			--raise notice 'addFloors v_FlrDetpk (%)',v_FlrDetpk;
			INSERT INTO egpt_floor_detail(id, id_property_detail, floor_no, created_date, builtup_area, id_struc_cl, id_occpn_mstr, id_usg_mstr, modified_date, created_by, modified_by, id_depreciationmaster, occupancydate, builtup_length, builtup_breadth)
			values (v_FlrDetpk, idPropDet, floors.i_flrno, assessmentdate, floors.d_plntarea, (select egovcode from egpt_stg_bldgclass_mater where code=floors.i_clscode), (select egovcode from egpt_stg_occupancy where code=floors.i_ocpntypecode), (select egovcode from egpt_stg_usagemaster where code=floors.i_bldgusecode), assessmentdate, 1, 1, (select egovcode from egpt_stg_depreciation where code=floors.i_depcode), case when floors.i_bldgage is not null then to_date(v_occDate_str||cast(floors.i_bldgage as varchar),'dd/MM/yyyy') end, coalesce(floors.d_lnth, 0), coalesce(floors.d_wdth, 0));
			--raise notice 'Floor done';
			v_FlrDmdCalc := createFlrDmdCalc(idDmdCal, floors.i_asmtdtlsno, v_FlrDetpk, assessmentdate, assessmentNo);
			--raise notice 'Floor demand calc is done';
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'addFloors, adding floors failed : % %', SQLERRM, SQLSTATE;
		END;
END LOOP;
	return 1;
EXCEPTION
WHEN OTHERS THEN
--raise notice 'addFloors : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;
----------------------------------------------------------------------------------------------------------------------


--------------------------------------------migrate collection--------------------------------------------------------

create or replace FUNCTION migrateCollection(assessmentNo IN bigint, idDemand IN bigint)
RETURNS bigint as $$
declare
v_mindate	date;
v_maxdate	date;
v_instfdate	timestamp without time zone;
v_insttdate	timestamp without time zone;
dds record;
v_currpt	double precision;
v_currlcs	double precision;
v_currunauthplty double precision;
v_dmndrsn 	character varying;
v_advncamt	double precision;
v_moduleId	bigint;
v_asmtdate	date;
v_temp		integer;
v_dmddetpk 	bigint;
BEGIN 
	--raise notice 'migrateCollection assessmentNo, idDemand (% %)',assessmentNo, idDemand;

--Migrating 2016-2017-1 installment

	v_advncamt := 0;
	select sum(d_crnpt) total, sum(d_crnlcs) total, sum(d_crnuauthcnstplty) total, min(dt_paidfrmprddt), max(dt_paidtoprddt) into v_currpt, v_currlcs, v_currunauthplty, v_mindate, v_maxdate from pt_asmtrcpt_tbl where i_asmtno=assessmentNo and C_ISRLSD <> 'X' AND C_DELFLAG = 'N' and dt_rcptdt>='2017-04-01' and dt_paidfrmprddt='2017-04-01' and dt_paidtoprddt='2017-09-30';
	--raise notice 'migrateCollection v_collection, v_mindate, v_maxdate (% % %)',v_collection, v_mindate, v_maxdate;
	select inst.start_date into v_instfdate from eg_installment_master inst where v_mindate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');

	select inst.end_date into v_insttdate from eg_installment_master inst where v_maxdate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');
	
	for dds in (SELECT dd.id ddid, dd.amount, dm.code dmcode FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst, eg_demand_reason_master dm where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id and dr.id_demand_reason_master=dm.id and inst.start_date>=v_instfdate and inst.end_date<=v_insttdate order by inst.start_date)
	loop 
		begin
			v_dmndrsn := dds.dmcode;
			--raise notice 'Demand Reason : %', v_dmndrsn;
			if v_currpt>0 and (v_dmndrsn = 'GEN_TAX') then
				if(v_currpt > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_currpt - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currpt where id=dds.ddid;
				end if;
			end if;
			if v_currlcs>0 and (v_dmndrsn = 'LIB_CESS') then
				if(v_currlcs > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currlcs - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currlcs where id=dds.ddid;
				end if;
			end if;
			if v_currunauthplty>0 and (v_dmndrsn = 'UNAUTH_PENALTY') then
				if(v_currunauthplty > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currunauthplty - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currunauthplty where id=dds.ddid;
				end if;
			end if;
			--raise notice 'migrateCollection after adjust v_collection (%)',v_collection;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateCollection, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;

--raise notice 'Advance before 2nd half : %', v_advncamt;

--Migrating 2016-2017-2 installment

select sum(d_crnpt) total, sum(d_crnlcs) total, sum(d_crnuauthcnstplty) total, min(dt_paidfrmprddt), max(dt_paidtoprddt) into v_currpt, v_currlcs, v_currunauthplty, v_mindate, v_maxdate from pt_asmtrcpt_tbl where i_asmtno=assessmentNo and C_ISRLSD <> 'X' AND C_DELFLAG = 'N' and dt_rcptdt>='2017-04-01' and dt_paidfrmprddt='2017-10-01' and dt_paidtoprddt='2018-03-31';
	--raise notice 'migrateCollection v_collection, v_mindate, v_maxdate (% % %)',v_collection, v_mindate, v_maxdate;
	select inst.start_date into v_instfdate from eg_installment_master inst where v_mindate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');

	select inst.end_date into v_insttdate from eg_installment_master inst where v_maxdate between inst.start_date and inst.end_date and id_module = (select id from eg_module where name='Property Tax');
	
	for dds in (SELECT dd.id ddid, dd.amount, dm.code dmcode, inst.id instid FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst, eg_demand_reason_master dm where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id and dr.id_demand_reason_master=dm.id and inst.start_date>=v_instfdate and inst.end_date<=v_insttdate order by inst.start_date)
	loop 
		begin
			v_dmndrsn := dds.dmcode;
			--raise notice 'Demand Reason : %', v_dmndrsn;
			if v_currpt>0 and (v_dmndrsn = 'GEN_TAX') then
				if(v_currpt > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currpt - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currpt where id=dds.ddid;
				end if;
			end if;
			if v_currlcs>0 and (v_dmndrsn = 'LIB_CESS') then
				if(v_currlcs > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currlcs - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currlcs where id=dds.ddid;
				end if;
			end if;
			if v_currunauthplty>0 and (v_dmndrsn = 'UNAUTH_PENALTY') then
				if(v_currunauthplty > dds.amount) then
					update eg_demand_details set amt_collected=amount where id=dds.ddid;
					v_advncamt := v_advncamt + v_currunauthplty - dds.amount;
				else
					update eg_demand_details set amt_collected=v_currunauthplty where id=dds.ddid;
				end if;
			end if;
		--raise notice 'Advance after 1st half : %', v_advncamt;
		
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateCollection, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	if v_advncamt > 0 then
			select dt_taxassddt into v_asmtdate from pt_asmt_mstr_tbl where i_asmtno=assessmentNo;
			select id into v_moduleId from eg_module where name='Property Tax';

			select nextval('seq_eg_demand_details') into v_dmddetpk;
	INSERT INTO eg_demand_details(id, id_demand, id_demand_reason, amount, modified_date, create_date, amt_collected)
	VALUES (v_dmddetpk, idDemand, getDemandReason(dds.instid, 'ADVANCE', v_moduleId ), 0, v_asmtdate, v_asmtdate, v_advncamt);
		end if;
	--raise notice 'Collection Migrated';
return 1;
EXCEPTION
WHEN OTHERS THEN
raise notice 'migrateCollection : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

----------------------------------------------------------------------------------------------------------------------


------------------------------------------------migrate penalty-------------------------------------------------------

CREATE OR REPLACE FUNCTION migrateassessmentpenalty(assessmentno character varying, currinst bigint, idmodule bigint, iddemand bigint)
 RETURNS numeric
AS 
$BODY$
declare
        v_temp          bigint;
        v_idinst        bigint;
        v_inst          varchar(16);
        v_tax           double precision;
        v_collection    double precision;
        v_penalty       double precision;
        v_newpenalty    double precision;
	v_curryearpenalty double precision;
        dcbrec record;
BEGIN
        --raise notice 'migrateassessmentpenalty assessmentNo, currInst, idModule, idDemand (% % % %)',assessmentNo, currInst, idModule, idDemand;
         for dcbrec in (select inst.id, inst.description, sum(dd.amount) tax, sum(dd.amt_collected) as collection
from eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst
where dd.id_demand=idDemand
and dd.id_demand_reason = dr.id
and dr.id_installment = inst.id
and dr.id_demand_reason_master in (select id from eg_demand_reason_master where module=idModule and code in ('GEN_TAX','VAC_LAND_TAX','LIB_CESS','EDU_CESS','UNAUTH_PENALTY'))
group by inst.description, inst.id)
         loop
                begin
                        v_inst := dcbrec.description;
                        v_collection := dcbrec.collection;
                        v_idinst := dcbrec.id;
                        v_tax := dcbrec.tax;
                        v_penalty := 0;
                        --raise notice 'migrateassessmentpenalty v_inst, v_collection, v_idinst (% % %)', v_inst, v_collection, v_idinst;
                        if(v_collection=0) then
                                if(v_idinst!=185 and v_idinst!=186) then
				  select d_pltyonarrs into v_penalty from pt_arrear_tbl where i_asmtno=assessmentNo::bigint and vc_dmndyear=v_inst and c_delflag='N';
				  --raise notice 'migrateassessmentpenalty v_newpenalty (%)', v_newpenalty;
				  v_newpenalty := v_penalty;
                                end if;
                                --raise notice 'migrateassessmentpenalty v_newpenalty (%)', v_newpenalty;
                                if(v_newpenalty>0) then
				  v_temp := createorupdatepenalty(idDemand, getDemandReason(v_idinst, 'PENALTY_FINES', idModule), round(v_newpenalty), now()::date);
                                end if;
				v_newpenalty := 0;
                        end if;
                EXCEPTION
                WHEN OTHERS THEN
                raise notice 'migrateassessmentpenalty, failed while adding arrears : % %', SQLERRM, SQLSTATE;
                END;
        END LOOP;
return v_temp;
END;
$BODY$ LANGUAGE plpgsql;
----------------------------------------------------------------------------------------------------------------------


--------------------------------------------------wardwise penalty----------------------------------------------------

CREATE OR REPLACE FUNCTION migrate_esuvidha_assessmentpenaltyward(in_wardid bigint)
 RETURNS void
 AS 
$BODY$
declare
  v_moduleid bigint;
  v_currinst bigint;
  v_assessmento character varying(16);
  v_demandid bigint;
  v_basicpropertyid bigint;
  v_currdmdinstid bigint;
  proprec record;
  v_temp bigint;
begin
  --raise notice 'migrate_esuvidha_assessmentpenaltyward: in_wardid (%)', in_wardid;
  select id into v_moduleid from eg_module where name='Property Tax';
  select id into v_currinst from eg_installment_master where id_module = v_moduleid and now() between start_date and end_date;
  select inst.id into v_currdmdinstid from financialyear fy, eg_installment_master inst where now() between fy.startingdate and fy.endingdate and inst.start_date = fy.startingdate and inst.id_module =v_moduleid;
  for proprec in (select bp.propertyid, bp.id from egpt_basic_property bp, egpt_propertyid pid where bp.propertyid=pid.id and pid.ward_adm_id = in_wardid)
  loop
    begin
      v_assessmento := proprec.propertyid;
      v_basicpropertyid := proprec.id;

      select d.id into v_demandid from egpt_property prop, egpt_ptdemand ptd, eg_demand d where prop.id_basic_property=v_basicpropertyid
        and prop.id=ptd.id_property and ptd.id_demand=d.id and d.is_history='N' and d.id_installment=v_currdmdinstid and prop.status in ('A', 'I');

      --raise notice 'lppcalc_migratepenaltyward: v_demandid, v_assessmento (% %)', v_demandid, v_assessmento;
      v_temp :=  migrateassessmentpenalty(v_assessmento, v_currinst, v_moduleid, v_demandid);
    END;
  end loop;
exception
  when others then
    raise notice 'migrate_esuvidha_assessmentpenaltyward % %', SQLERRM, SQLSTATE;
end;
$BODY$ LANGUAGE plpgsql;
----------------------------------------------------------------------------------------------------------------------
