------------------Start---------------------
alter table egpt_aggregate_stats add citycode varchar(16);
alter table egpt_aggregate_stats add coll_newassessment double precision;
alter table egpt_aggregate_stats add coll_reassessment double precision;
------------------End---------------------

------------------Start---------------------
update egpt_aggregate_stats set citycode='1147' where city='addanki';
update egpt_aggregate_stats set citycode='1015' where city='adoni';
update egpt_aggregate_stats set citycode='1162' where city='allagadda';
update egpt_aggregate_stats set citycode='1059' where city='amalapuram';
update egpt_aggregate_stats set citycode='1082' where city='amudalavalasa';
update egpt_aggregate_stats set citycode='1001' where city='anantapur';
update egpt_aggregate_stats set citycode='1160' where city='atmakurknl';
update egpt_aggregate_stats set citycode='1151' where city='atmakurnlr';
update egpt_aggregate_stats set citycode='1019' where city='bapatla';
update egpt_aggregate_stats set citycode='1074' where city='bhimavaram';
update egpt_aggregate_stats set citycode='1090' where city='bobbili';
update egpt_aggregate_stats set citycode='1123' where city='budwel';
update egpt_aggregate_stats set citycode='1149' where city='cheemakurthy';
update egpt_aggregate_stats set citycode='1020' where city='chilakaluripet';
update egpt_aggregate_stats set citycode='1032' where city='chirala';
update egpt_aggregate_stats set citycode='1008' where city='chittoor';
update egpt_aggregate_stats set citycode='1002' where city='dharmavaram';
update egpt_aggregate_stats set citycode='1125' where city='dhone';
update egpt_aggregate_stats set citycode='1075' where city='eluru';
update egpt_aggregate_stats set citycode='1148' where city='giddalur';
update egpt_aggregate_stats set citycode='1138' where city='gollaprolu';
update egpt_aggregate_stats set citycode='1156' where city='gooty';
update egpt_aggregate_stats set citycode='1068' where city='gudivada';
update egpt_aggregate_stats set citycode='1163' where city='gudurknl';
update egpt_aggregate_stats set citycode='1029' where city='gudurnlr';
update egpt_aggregate_stats set citycode='1003' where city='guntakal';
update egpt_aggregate_stats set citycode='1021' where city='guntur';
update egpt_aggregate_stats set citycode='1004' where city='hindupur';
update egpt_aggregate_stats set citycode='1083' where city='ichapuram';
update egpt_aggregate_stats set citycode='1069' where city='jaggaiahpet';
update egpt_aggregate_stats set citycode='1124' where city='jammalamadugu';
update egpt_aggregate_stats set citycode='1142' where city='jangareddygudem';
update egpt_aggregate_stats set citycode='1013' where city='kadapa';
update egpt_aggregate_stats set citycode='1005' where city='kadiri';
update egpt_aggregate_stats set citycode='1060' where city='kakinada';
update egpt_aggregate_stats set citycode='1158' where city='kalyanadurgam';
update egpt_aggregate_stats set citycode='1033' where city='kandukur';
update egpt_aggregate_stats set citycode='1150' where city='kanigiri';
update egpt_aggregate_stats set citycode='1030' where city='kavali';
update egpt_aggregate_stats set citycode='1076' where city='kovvur';
update egpt_aggregate_stats set citycode='1016' where city='kurnool';
update egpt_aggregate_stats set citycode='1022' where city='macherla';
update egpt_aggregate_stats set citycode='1070' where city='machilipatnam';
update egpt_aggregate_stats set citycode='1154' where city='madakasira';
update egpt_aggregate_stats set citycode='1009' where city='madanapalle';
update egpt_aggregate_stats set citycode='1061' where city='mandapet';
update egpt_aggregate_stats set citycode='1023' where city='mangalagiri';
update egpt_aggregate_stats set citycode='1034' where city='markapur';
update egpt_aggregate_stats set citycode='1139' where city='mummidivaram';
update egpt_aggregate_stats set citycode='1164' where city='mydukur';
update egpt_aggregate_stats set citycode='1118' where city='nagari';
update egpt_aggregate_stats set citycode='1153' where city='naidupet';
update egpt_aggregate_stats set citycode='1145' where city='nandigama';
update egpt_aggregate_stats set citycode='1161' where city='nandikotkur';
update egpt_aggregate_stats set citycode='1017' where city='nandyal';
update egpt_aggregate_stats set citycode='1077' where city='narasapur';
update egpt_aggregate_stats set citycode='1024' where city='narasaraopet';
update egpt_aggregate_stats set citycode='1136' where city='narsipatnam';
update egpt_aggregate_stats set citycode='1135' where city='nellimarla';
update egpt_aggregate_stats set citycode='1031' where city='nellore';
update egpt_aggregate_stats set citycode='1078' where city='nidadavole';
update egpt_aggregate_stats set citycode='1071' where city='nuzividu';
update egpt_aggregate_stats set citycode='1035' where city='ongole';
update egpt_aggregate_stats set citycode='1079' where city='palakol';
update egpt_aggregate_stats set citycode='1134' where city='palakonda';
update egpt_aggregate_stats set citycode='1117' where city='palamaner';
update egpt_aggregate_stats set citycode='1084' where city='palasakasibugga';
update egpt_aggregate_stats set citycode='1157' where city='pamidi';
update egpt_aggregate_stats set citycode='1091' where city='parvathipuram';
update egpt_aggregate_stats set citycode='1072' where city='pedana';
update egpt_aggregate_stats set citycode='1062' where city='peddapuram';
update egpt_aggregate_stats set citycode='1132' where city='piduguralla';
update egpt_aggregate_stats set citycode='1063' where city='pithapuram';
update egpt_aggregate_stats set citycode='1025' where city='ponnur';
update egpt_aggregate_stats set citycode='1014' where city='proddatur';
update egpt_aggregate_stats set citycode='1122' where city='pulivendula';
update egpt_aggregate_stats set citycode='1010' where city='punganur';
update egpt_aggregate_stats set citycode='1155' where city='puttaparthy';
update egpt_aggregate_stats set citycode='1119' where city='puttur';
update egpt_aggregate_stats set citycode='1064' where city='rajahmundry';
update egpt_aggregate_stats set citycode='1133' where city='rajam';
update egpt_aggregate_stats set citycode='1120' where city='rajampet';
update egpt_aggregate_stats set citycode='1065' where city='ramachandrapuram';
update egpt_aggregate_stats set citycode='1121' where city='rayachoty';
update egpt_aggregate_stats set citycode='1006' where city='rayadurg';
update egpt_aggregate_stats set citycode='1026' where city='repalle';
update egpt_aggregate_stats set citycode='1092' where city='saluru';
update egpt_aggregate_stats set citycode='1066' where city='samalkot';
update egpt_aggregate_stats set citycode='1027' where city='sattenapalle';
update egpt_aggregate_stats set citycode='1085' where city='srikakulam';
update egpt_aggregate_stats set citycode='1011' where city='srikalahasti';
update egpt_aggregate_stats set citycode='1152' where city='sullurpeta';
update egpt_aggregate_stats set citycode='1080' where city='tadepalligudem';
update egpt_aggregate_stats set citycode='1143' where city='tadepalli';
update egpt_aggregate_stats set citycode='1007' where city='tadipatri';
update egpt_aggregate_stats set citycode='1081' where city='tanuku';
update egpt_aggregate_stats set citycode='1028' where city='tenali';
update egpt_aggregate_stats set citycode='1012' where city='tirupati';
update egpt_aggregate_stats set citycode='1146' where city='tiruvuru';
update egpt_aggregate_stats set citycode='1067' where city='tuni';
update egpt_aggregate_stats set citycode='1127' where city='venkatagiri';
update egpt_aggregate_stats set citycode='1093' where city='vijayanagaram';
update egpt_aggregate_stats set citycode='1073' where city='vijayawada';
update egpt_aggregate_stats set citycode='1131' where city='vinukonda';
update egpt_aggregate_stats set citycode='1086' where city='visakhapatnam';
update egpt_aggregate_stats set citycode='1144' where city='vuyyuru';
update egpt_aggregate_stats set citycode='1137' where city='yelamanchili';
update egpt_aggregate_stats set citycode='1140' where city='yeleswaram';
update egpt_aggregate_stats set citycode='1018' where city='yemmiganur';
update egpt_aggregate_stats set citycode='1165' where city='yerraguntla';
------------------End---------------------

------------------Start---------------------
drop function getptistransstats();

CREATE OR REPLACE FUNCTION getptistransstats(fromdate IN varchar(16), todate IN varchar(16))
  RETURNS void AS
$BODY$
declare
	v_cityname character varying(128);
	v_countercount bigint;
	v_countercoll double precision;
	v_onlinecount bigint;
	v_onlinecoll double precision;
	v_mutationfeecount bigint;
	v_mutationfeecoll double precision;
	v_esevacount bigint;
	v_esevacoll double precision;
	v_meesevacount bigint;
	v_meesevacoll double precision;
	v_aponlinecount bigint;
	v_aponlinecoll double precision;
	v_newassessmentcoll double precision;
	v_reassessmentcoll double precision;
	v_mutationcount bigint;
	v_assessmentcount bigint;
	v_reassessmentcount bigint;
	v_fromdate date;
	v_todate date;
	cities egpt_aggregate_stats%ROWTYPE;
begin
	v_fromdate := to_date(fromdate,'dd/MM/yyyy');
	v_todate := to_date(todate,'dd/MM/yyyy');
	raise notice 'Generating report for dates : % %', v_fromdate, v_todate;
for cities in (select city from egpt_aggregate_stats)
	loop
		v_cityname := cities.city;
		v_countercount := 0;
		v_countercoll := 0;
		v_onlinecount := 0;
		v_onlinecoll := 0;
		v_mutationfeecount := 0;
		v_mutationfeecoll := 0;
		v_esevacount := 0;
		v_esevacoll := 0;
		v_meesevacount := 0;
		v_meesevacoll := 0;
		v_aponlinecount := 0;
		v_aponlinecoll := 0;
		v_mutationcount := 0;
		v_assessmentcount := 0;
		v_reassessmentcount := 0;
		raise notice 'Getting Stats for City : %', v_cityname;
		EXECUTE 'set search_path to '|| v_cityname; -- security
		update egpt_aggregate_stats set countercoll=0, onlinecoll=0, aponlinecoll=0, mutationfeecoll=0, esevacoll=0, assessments=0, addoralters=0, mutations=0,  coll_newassessment=0, coll_reassessment=0 where city=v_cityname;
		--all the data from date of live
		if(v_fromdate is not NULL and v_todate is not NULL) then
			--counter collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_countercount, v_countercoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='SYSTEM'
			and ch.collectiontype!='O'
			and ch.receiptdate>=v_fromdate
			and ch.receiptdate<=v_todate;
			--online collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_onlinecount, v_onlinecoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='SYSTEM'
			and ch.collectiontype='O'
			and ch.receiptdate>=v_fromdate
			and ch.receiptdate<=v_todate;
			--aponline collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_aponlinecount, v_aponlinecoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='APONLINE'
			and ch.receiptdate>=v_fromdate
			and ch.receiptdate<=v_todate;
			--eseva collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_esevacount, v_esevacoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='ESEVA'
			and ch.receiptdate>=v_fromdate
			and ch.receiptdate<=v_todate;
			--mutation fee collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_mutationfeecount, v_mutationfeecoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='PT Mutation Fee')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.receiptdate>=v_fromdate
			and ch.receiptdate<=v_todate;
			--new assessment collection
			select coalesce(sum(ch.totalamount), 0) into v_newassessmentcoll
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.receiptdate>=v_fromdate
			and ch.receiptdate<=v_todate
			and consumercode in (select propertyid from egpt_basic_property where source!='M');
			--re assessment collection
			select coalesce(sum(ch.totalamount), 0) into v_reassessmentcoll
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.receiptdate>=v_fromdate
			and ch.receiptdate<=v_todate
			and consumercode in (select propertyid from egpt_basic_property where id in (select id_basic_property from egpt_property_status_values where id_status in (select id from egpt_status where code='ADD_OR_ALTER')));

			select coalesce(count(*), 0) into v_assessmentcount from egpt_basic_property where source!='M' and createddate>=v_fromdate and createddate<=v_todate;
			select coalesce(count(*), 0) into v_mutationcount from egpt_property_mutation where createddate>=v_fromdate and createddate<=v_todate;
			select coalesce(count(*), 0) into v_reassessmentcount from egpt_property_status_values where id_status in (select id from egpt_status where code='ADD_OR_ALTER') and created_date>=v_fromdate and created_date<=v_todate;
		else --all the data for given dates
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_countercount, v_countercoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='SYSTEM'
			and ch.collectiontype!='O';
			--online collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_onlinecount, v_onlinecoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='SYSTEM'
			and ch.collectiontype='O';
			--aponline collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_aponlinecount, v_aponlinecoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='APONLINE';
			--eseva collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_esevacount, v_esevacoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and ch.source='ESEVA';
			--mutation fee collection
			select coalesce(count(ch.receiptnumber), 0), coalesce(sum(ch.totalamount), 0) into v_mutationfeecount, v_mutationfeecoll 
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='PT Mutation Fee')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'));
			--new assessment collection
			select coalesce(sum(ch.totalamount), 0) into v_newassessmentcoll
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and consumercode in (select propertyid from egpt_basic_property where source!='M');
			--re assessment collection
			select coalesce(sum(ch.totalamount), 0) into v_reassessmentcoll
			from egcl_collectionheader ch
			where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
			and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
			and consumercode in (select propertyid from egpt_basic_property where id in (select id_basic_property from egpt_property_status_values where id_status in (select id from egpt_status where code='ADD_OR_ALTER')));

			select coalesce(count(*), 0) into v_assessmentcount from egpt_basic_property where source!='M';
			select coalesce(count(*), 0) into v_mutationcount from egpt_property_mutation;
			select coalesce(count(*), 0) into v_reassessmentcount from egpt_property_status_values where id_status in (select id from egpt_status where code='ADD_OR_ALTER');
		end if;

		update egpt_aggregate_stats set countercoll=v_countercoll, onlinecoll=v_onlinecoll, aponlinecoll=v_aponlinecoll, mutationfeecoll=v_mutationfeecoll, esevacoll=v_esevacoll, assessments=v_assessmentcount, addoralters=v_reassessmentcount, mutations=v_mutationcount, coll_newassessment=v_newassessmentcoll, coll_reassessment=v_reassessmentcoll where city=v_cityname;

	end loop;
	set search_path to public;
end;
$BODY$
  LANGUAGE plpgsql;
------------------End---------------------
