delete from egpt_yearwise_aggregate_collection where city = 'guntur';

insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1021','guntur','Vacant Land');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1004','hindupur','Vacant Land');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1021','guntur','Private');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1004','hindupur','Private');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1021','guntur','Central Government 33.5%');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1004','hindupur','Central Government 33.5%');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1021','guntur','Central Government 50%');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1004','hindupur','Central Government 50%');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1021','guntur','Central Government 75%');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1004','hindupur','Central Government 75%');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1021','guntur','State Government');
insert into egpt_yearwise_aggregate_collection (citycode, city, propertyType) values ('1004','hindupur','State Government');


------------------Start---------------------
CREATE OR REPLACE FUNCTION getptisyearwiseaggregatecollection()
  RETURNS void AS
$BODY$
declare
  v_cityname character varying(128);
  propType egpt_property_type_master%rowtype;
  v_count bigint;
  v_currentdemand double precision;
  v_arreardemand double precision;
  v_eg_currentcoll double precision;
  v_eg_arrearcoll double precision;
  v_es_currentcoll double precision;
  v_es_arrearcoll double precision;
  v_curr_currentcoll double precision;
  v_curr_arrearcoll double precision;
  v_prev_currentcoll double precision;
  v_prev_arrearcoll double precision;
  v_curr_yes_arrearcoll double precision;
  v_curr_yes_currentcoll double precision;
  v_prev_yes_currentcoll double precision;
  v_prev_yes_arrearcoll double precision;
  cities record;
begin
for cities in (select distinct city from egpt_yearwise_aggregate_collection order by city)
  loop
    v_cityname := cities.city;
    v_count := 0;
    v_currentdemand := 0;
    v_arreardemand := 0;
    v_eg_currentcoll := 0;
    v_eg_arrearcoll := 0;
    v_es_currentcoll := 0;
    v_es_arrearcoll := 0;
    v_curr_currentcoll := 0;
    v_curr_arrearcoll := 0;
    v_prev_currentcoll := 0;
    v_prev_arrearcoll := 0;
    v_curr_yes_arrearcoll := 0;
    v_curr_yes_currentcoll := 0;
    v_prev_yes_currentcoll := 0;
    v_prev_yes_arrearcoll := 0;
    raise notice 'Getting CDMA report for City : %', v_cityname;
    EXECUTE 'set search_path to '|| v_cityname; -- security
    for propType in (select * from egpt_property_type_master order by id)
    loop
      update egpt_yearwise_aggregate_collection set
      noofAssessments=0,curryearCurrDemand=0,curryearArrearDemand=0,curryearArrearCollection=0,curryearCurrCollection=0,curryearYesArrearCollection=0,
      curryearYesCurrCollection=0,prevyearArrearCollection=0,prevyearCurrCollection=0,prevyearYesArrearCollection=0,prevyearYesCurrCollection=0 
      where city=v_cityname and propertytype = (select property_type from egpt_property_type_master where id = propType.id);
    
      select count(*), sum(aggregate_current_demand), sum(aggregate_arrear_demand) into v_count, v_currentdemand, v_arreardemand 
      from egpt_mv_propertyinfo mv where proptymaster = propType.id;
      
      select sum(cd.cramount) into v_eg_currentcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (current_date - 1)::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))and cd.description like concat('%',currentFinancialYear(),'%')
      and proptymaster = propType.id;
      
      select sum(cd.cramount) into v_eg_arrearcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and ch.receiptdate::date between currFinYearDate(current_date)::date 
      and (current_date - 1)::date and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax') 
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
      and cd.description not like concat('%',currentFinancialYear(),'%') and mv.proptymaster = propType.id;

      select sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_pltyoncrn), sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_pltyonarr) into v_es_currentcoll, v_es_arrearcoll 
      from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv 
      where rcpt.i_asmtno::text = mv.upicno and rcpt.dt_etrydt between currFinYearDate(current_date)::date and (current_date - 1)::date 
      and mv.proptymaster = propType.id;

      v_curr_arrearcoll := v_eg_arrearcoll + v_es_arrearcoll;
      v_curr_currentcoll := v_eg_currentcoll + v_es_currentcoll; 
      
      select sum(cd.cramount) into v_curr_yes_currentcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and mv.proptymaster = propType.id and ch.receiptdate::date = (current_date - 1)::date 
      and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
      and cd.description like concat('%',currentFinancialYear(),'%');

      select sum(cd.cramount) into v_curr_yes_arrearcoll from egcl_collectionheader ch, egcl_collectiondetails cd, egpt_mv_propertyinfo mv
      where mv.upicno=ch.consumercode and ch.id=cd.collectionheader and mv.proptymaster=propType.id and ch.receiptdate::date = (current_date - 1)::date 
      and ch.servicedetails = (select id from EGCL_SERVICEDETAILS where name = 'Property Tax')
      and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
      and cd.description not like concat('%',currentFinancialYear(),'%');

      select sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_pltyoncrn), sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_pltyonarr) 
      into v_prev_currentcoll, v_prev_arrearcoll from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv
      where rcpt.i_asmtno::text = mv.upicno and mv.proptymaster = propType.id and rcpt.dt_etrydt between lastFinYearDate(current_date)::date 
      and concat(extract(year from current_date) - 1, '-', lpad(extract(month from current_date)::text, 2, '0'), '-' ,extract(day from current_date) - 1)::date;

      select sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_pltyoncrn), sum(d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_pltyonarr)
      into v_prev_yes_currentcoll, v_prev_yes_arrearcoll from pt_asmtrcpt_tbl rcpt, egpt_mv_propertyinfo mv
      where rcpt.i_asmtno::text = mv.upicno and mv.proptymaster = propType.id 
      and rcpt.dt_etrydt::date = concat(extract(year from current_date) - 1, '-', lpad(extract(month from current_date)::text, 2, '0'), '-' ,extract(day from current_date) - 1)::date;

      update egpt_yearwise_aggregate_collection set
      noofAssessments=v_count,curryearCurrDemand=v_currentdemand,curryearArrearDemand=v_arreardemand,curryearArrearCollection=v_curr_arrearcoll,
      curryearCurrCollection=v_curr_currentcoll,curryearYesArrearCollection=v_curr_yes_arrearcoll, curryearYesCurrCollection=v_curr_yes_currentcoll,
      prevyearArrearCollection=v_prev_arrearcoll,prevyearCurrCollection=v_prev_currentcoll,prevyearYesArrearCollection=v_prev_yes_arrearcoll,
      prevyearYesCurrCollection=v_prev_yes_currentcoll where city=v_cityname and propertytype = (select property_type from egpt_property_type_master where id = propType.id);
      
  end loop;    
end loop;
set search_path to public;
end;
$BODY$
  LANGUAGE plpgsql;
------------------End---------------------




