------------------Start---------------------
create table egpt_aggregate_stats(
city varchar(128),
countercoll double precision,
onlinecoll double precision,
aponlinecoll double precision,
mutationfeecoll double precision,
esevacoll double precision,
assessments bigint,
addoralters bigint,
mutations bigint
);
------------------End---------------------

------------------Start---------------------
insert into egpt_aggregate_stats (city) values ('addanki');
insert into egpt_aggregate_stats (city) values ('adoni');
insert into egpt_aggregate_stats (city) values ('allagadda');
insert into egpt_aggregate_stats (city) values ('amalapuram');
insert into egpt_aggregate_stats (city) values ('amudalavalasa');
insert into egpt_aggregate_stats (city) values ('anantapur');
insert into egpt_aggregate_stats (city) values ('atmakurknl');
insert into egpt_aggregate_stats (city) values ('atmakurnlr');
insert into egpt_aggregate_stats (city) values ('bapatla');
insert into egpt_aggregate_stats (city) values ('bhimavaram');
insert into egpt_aggregate_stats (city) values ('bobbili');
insert into egpt_aggregate_stats (city) values ('budwel');
insert into egpt_aggregate_stats (city) values ('cheemakurthy');
insert into egpt_aggregate_stats (city) values ('chilakaluripet');
insert into egpt_aggregate_stats (city) values ('chirala');
insert into egpt_aggregate_stats (city) values ('chittoor');
insert into egpt_aggregate_stats (city) values ('dharmavaram');
insert into egpt_aggregate_stats (city) values ('dhone');
insert into egpt_aggregate_stats (city) values ('eluru');
insert into egpt_aggregate_stats (city) values ('giddalur');
insert into egpt_aggregate_stats (city) values ('gollaprolu');
insert into egpt_aggregate_stats (city) values ('gooty');
insert into egpt_aggregate_stats (city) values ('gudivada');
insert into egpt_aggregate_stats (city) values ('gudurknl');
insert into egpt_aggregate_stats (city) values ('gudurnlr');
insert into egpt_aggregate_stats (city) values ('guntakal');
insert into egpt_aggregate_stats (city) values ('guntur');
insert into egpt_aggregate_stats (city) values ('hindupur');
insert into egpt_aggregate_stats (city) values ('ichapuram');
insert into egpt_aggregate_stats (city) values ('jaggaiahpet');
insert into egpt_aggregate_stats (city) values ('jammalamadugu');
insert into egpt_aggregate_stats (city) values ('jangareddygudem');
insert into egpt_aggregate_stats (city) values ('kadapa');
insert into egpt_aggregate_stats (city) values ('kadiri');
insert into egpt_aggregate_stats (city) values ('kakinada');
insert into egpt_aggregate_stats (city) values ('kalyanadurgam');
insert into egpt_aggregate_stats (city) values ('kandukur');
insert into egpt_aggregate_stats (city) values ('kanigiri');
insert into egpt_aggregate_stats (city) values ('kavali');
insert into egpt_aggregate_stats (city) values ('kovvur');
insert into egpt_aggregate_stats (city) values ('kurnool');
insert into egpt_aggregate_stats (city) values ('macherla');
insert into egpt_aggregate_stats (city) values ('machilipatnam');
insert into egpt_aggregate_stats (city) values ('madakasira');
insert into egpt_aggregate_stats (city) values ('madanapalle');
insert into egpt_aggregate_stats (city) values ('mandapet');
insert into egpt_aggregate_stats (city) values ('mangalagiri');
insert into egpt_aggregate_stats (city) values ('markapur');
insert into egpt_aggregate_stats (city) values ('mummidivaram');
insert into egpt_aggregate_stats (city) values ('mydukur');
insert into egpt_aggregate_stats (city) values ('nagari');
insert into egpt_aggregate_stats (city) values ('naidupet');
insert into egpt_aggregate_stats (city) values ('nandigama');
insert into egpt_aggregate_stats (city) values ('nandikotkur');
insert into egpt_aggregate_stats (city) values ('nandyal');
insert into egpt_aggregate_stats (city) values ('narasapur');
insert into egpt_aggregate_stats (city) values ('narasaraopet');
insert into egpt_aggregate_stats (city) values ('narsipatnam');
insert into egpt_aggregate_stats (city) values ('nellimarla');
insert into egpt_aggregate_stats (city) values ('nellore');
insert into egpt_aggregate_stats (city) values ('nidadavole');
insert into egpt_aggregate_stats (city) values ('nuzividu');
insert into egpt_aggregate_stats (city) values ('ongole');
insert into egpt_aggregate_stats (city) values ('palakol');
insert into egpt_aggregate_stats (city) values ('palakonda');
insert into egpt_aggregate_stats (city) values ('palamaner');
insert into egpt_aggregate_stats (city) values ('palasakasibugga');
insert into egpt_aggregate_stats (city) values ('pamidi');
insert into egpt_aggregate_stats (city) values ('parvathipuram');
insert into egpt_aggregate_stats (city) values ('pedana');
insert into egpt_aggregate_stats (city) values ('peddapuram');
insert into egpt_aggregate_stats (city) values ('piduguralla');
insert into egpt_aggregate_stats (city) values ('pithapuram');
insert into egpt_aggregate_stats (city) values ('ponnur');
insert into egpt_aggregate_stats (city) values ('proddatur');
insert into egpt_aggregate_stats (city) values ('pulivendula');
insert into egpt_aggregate_stats (city) values ('punganur');
insert into egpt_aggregate_stats (city) values ('puttaparthy');
insert into egpt_aggregate_stats (city) values ('puttur');
insert into egpt_aggregate_stats (city) values ('rajahmundry');
insert into egpt_aggregate_stats (city) values ('rajam');
insert into egpt_aggregate_stats (city) values ('rajampet');
insert into egpt_aggregate_stats (city) values ('ramachandrapuram');
insert into egpt_aggregate_stats (city) values ('rayachoty');
insert into egpt_aggregate_stats (city) values ('rayadurg');
insert into egpt_aggregate_stats (city) values ('repalle');
insert into egpt_aggregate_stats (city) values ('saluru');
insert into egpt_aggregate_stats (city) values ('samalkot');
insert into egpt_aggregate_stats (city) values ('sattenapalle');
insert into egpt_aggregate_stats (city) values ('srikakulam');
insert into egpt_aggregate_stats (city) values ('srikalahasti');
insert into egpt_aggregate_stats (city) values ('sullurpeta');
insert into egpt_aggregate_stats (city) values ('tadepalli');
insert into egpt_aggregate_stats (city) values ('tadepalligudem');
insert into egpt_aggregate_stats (city) values ('tadipatri');
insert into egpt_aggregate_stats (city) values ('tanuku');
insert into egpt_aggregate_stats (city) values ('tenali');
insert into egpt_aggregate_stats (city) values ('tirupati');
insert into egpt_aggregate_stats (city) values ('tiruvuru');
insert into egpt_aggregate_stats (city) values ('tuni');
insert into egpt_aggregate_stats (city) values ('venkatagiri');
insert into egpt_aggregate_stats (city) values ('vijayanagaram');
insert into egpt_aggregate_stats (city) values ('vijayawada');
insert into egpt_aggregate_stats (city) values ('vinukonda');
insert into egpt_aggregate_stats (city) values ('visakhapatnam');
insert into egpt_aggregate_stats (city) values ('vuyyuru');
insert into egpt_aggregate_stats (city) values ('yelamanchili');
insert into egpt_aggregate_stats (city) values ('yeleswaram');
insert into egpt_aggregate_stats (city) values ('yemmiganur');
insert into egpt_aggregate_stats (city) values ('yerraguntla');
------------------End---------------------

------------------Start---------------------
CREATE OR REPLACE FUNCTION getptistransstats()
  RETURNS void AS
$BODY$
declare
	v_cityname character varying(128);
	v_countercount bigint;
	v_countercoll double precision;
	v_onlinecount bigint;
	v_onlinecoll double precision;
	v_mutationfeecount bigint;
	v_mutationfeecoll double precision;
	v_esevacount bigint;
	v_esevacoll double precision;
	v_meesevacount bigint;
	v_meesevacoll double precision;
	v_aponlinecount bigint;
	v_aponlinecoll double precision;
	v_mutationcount bigint;
	v_assessmentcount bigint;
	v_reassessmentcount bigint;
	cities egpt_aggregate_stats%ROWTYPE;
begin
for cities in (select city from egpt_aggregate_stats)
	loop
		v_cityname := cities.city;
		v_countercount := 0;
		v_countercoll := 0;
		v_onlinecount := 0;
		v_onlinecoll := 0;
		v_mutationfeecount := 0;
		v_mutationfeecoll := 0;
		v_esevacount := 0;
		v_esevacoll := 0;
		v_meesevacount := 0;
		v_meesevacoll := 0;
		v_aponlinecount := 0;
		v_aponlinecoll := 0;
		v_mutationcount := 0;
		v_assessmentcount := 0;
		v_reassessmentcount := 0;
		raise notice 'Getting Stats for City : %', v_cityname;
		EXECUTE 'set search_path to '|| v_cityname; -- security
		update egpt_aggregate_stats set countercoll=0, onlinecoll=0, aponlinecoll=0, mutationfeecoll=0, esevacoll=0, assessments=0, addoralters=0, mutations=0 where city=v_cityname;
		--counter collection
		select count(ch.receiptnumber), sum(ch.totalamount) into v_countercount, v_countercoll 
		from egcl_collectionheader ch
		where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
		and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
		and ch.source='SYSTEM'
		and ch.collectiontype!='O';
		--online collection
		select count(ch.receiptnumber), sum(ch.totalamount) into v_onlinecount, v_onlinecoll 
		from egcl_collectionheader ch
		where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
		and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
		and ch.source='SYSTEM'
		and ch.collectiontype='O';
		--aponline collection
		select count(ch.receiptnumber), sum(ch.totalamount) into v_aponlinecount, v_aponlinecoll 
		from egcl_collectionheader ch
		where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
		and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
		and ch.source='APONLINE';
		--eseva collection
		select count(ch.receiptnumber), sum(ch.totalamount) into v_esevacount, v_esevacoll 
		from egcl_collectionheader ch
		where ch.servicedetails = (select id from egcl_servicedetails where name='Property Tax')
		and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'))
		and ch.source='ESEVA';
		--mutation fee collection
		select count(ch.receiptnumber), sum(ch.totalamount) into v_mutationfeecount, v_mutationfeecoll 
		from egcl_collectionheader ch
		where ch.servicedetails = (select id from egcl_servicedetails where name='PT Mutation Fee')
		and ch.status in (select id from egw_status where moduletype='ReceiptHeader' and code in ('TO_BE_SUBMITTED','SUBMITTED','APPROVED','REMITTED'));

		select count(*) into v_assessmentcount from egpt_basic_property where source!='M';
		select count(*) into v_mutationcount from egpt_property_mutation;
		select count(*) into v_reassessmentcount from egpt_property_status_values where id_status in (select id from egpt_status where code='ADD_OR_ALTER');

		update egpt_aggregate_stats set countercoll=v_countercoll, onlinecoll=v_onlinecoll, aponlinecoll=v_aponlinecoll, mutationfeecoll=v_mutationfeecoll, esevacoll=v_esevacoll, assessments=v_assessmentcount, addoralters=v_reassessmentcount, mutations=v_mutationcount where city=v_cityname;

	end loop;
	set search_path to public;
end;
$BODY$
  LANGUAGE plpgsql;
------------------End---------------------
