create or replace FUNCTION updateOwnerNameApplicationIndexMissingData()
RETURNS void as $$
declare
v_applicationtype character varying(255);
v_modifieddate timestamp without time zone;
v_wf_status character varying(255);
v_username character varying(64);
v_name character varying(100);
v_ownername character varying(200);
v_modulename character varying(200);
v_egwstatus character varying(200);
v_state_status numeric(20);
applications record;
BEGIN
     for applications in (select id, applicationnumber, applicationtype, modulename from eg_applicationindex where modulename in ('Trade License', 'Water Charges', 'Advertisement Tax', 'Marriage Registration', 'Property Tax') and applicationnumber='00295-2017-HX' order by id)
    loop
        begin
		v_applicationtype := applications.applicationtype;
		v_modulename := applications.modulename;
		raise notice 'application numbers = % ',applications.applicationnumber;
		--raise notice 'v_applicationtype = % ',v_applicationtype;
		
	IF (v_modulename = 'Trade License') THEN
			--raise notice '----------- From Trade License ----------- ';
			select wf_states.status into v_state_status from eg_wf_states wf_states,
			egtl_license license where applications.applicationnumber=license.appl_num and 
			license.state_id= wf_states.id ;
			raise notice 'v_state_status = % ',v_state_status;
			
			if v_state_status = 2 then
				--raise notice ' closed';
				select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name  from egtl_license license, eg_wf_states state, eg_user usr, egw_status 				egwstatus where license.state_id = state.id and state.lastmodifiedby=usr.id
			and license.appl_num = applications.applicationnumber and license.egwstatusid=egwstatus.id;

			else
				--raise notice ' not closed';
			select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name from egtl_license license, eg_wf_states state, eg_user usr, 					egeis_assignment assg, egw_status egwstatus where license.state_id = state.id and 
			state.owner_pos=assg.position and (now() between assg.fromdate and assg.todate) and assg.isprimary=true and 				assg.employee=usr.id and license.appl_num = applications.applicationnumber and license.egwstatusid=egwstatus.id;
			end if;		
			
		
		if v_username is null then
			--raise notice 'Not primary';
			select state.lastmodifieddate, state.value, usr.username, usr.name, egwstatus.description into v_modifieddate, 				v_wf_status, v_username, v_name, v_egwstatus from egtl_license license, eg_wf_states state, eg_user usr, 				egeis_assignment assg, egw_status egwstatus where license.state_id = state.id and state.owner_pos=assg.position and (now() 			between assg.fromdate and assg.todate) and assg.isprimary=false and assg.employee=usr.id and license.appl_num = 			applications.applicationnumber and license.egwstatusid = egwstatus.id limit 1;
		end if;
		
	END IF;
		



	IF (v_modulename='Water Charges') THEN

			--raise notice '----------- From Water Charges ----------- ';


			select wf_states.status into v_state_status from eg_wf_states wf_states,
			egwtr_connectiondetails conn where applications.applicationnumber=conn.applicationnumber and 
			conn.state_id= wf_states.id;
			raise notice 'v_state_status = % ',v_state_status;
			
			if v_state_status = 2 then
				raise notice ' closed';
				select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name  from egwtr_connectiondetails conn, eg_wf_states state, eg_user usr, 				egw_status egwstatus where conn.state_id = state.id and state.lastmodifiedby=usr.id
			and conn.applicationnumber = applications.applicationnumber and conn.statusid=egwstatus.id;

			else
				raise notice ' not closed';
			select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name from egwtr_connectiondetails conn, eg_wf_states state, eg_user usr, 					egeis_assignment assg, egw_status egwstatus where conn.state_id = state.id and 
			state.owner_pos=assg.position and (now() between assg.fromdate and assg.todate) and assg.isprimary=true and 				assg.employee=usr.id and conn.applicationnumber = applications.applicationnumber and conn.statusid=egwstatus.id;
			end if;	

		
			--raise notice '----------- To Water Charges ----------- ';
		if v_username is null then
		--raise notice 'Not primary';
			select state.lastmodifieddate, state.value, usr.username, usr.name, egwstatus.description into v_modifieddate, 				v_wf_status, v_username, v_name, v_egwstatus from egwtr_connectiondetails conn, eg_wf_states state, eg_user usr, 				egeis_assignment assg, egw_status egwstatus where conn.state_id = state.id and state.owner_pos=assg.position and (now() 			between assg.fromdate and assg.todate) and assg.isprimary=false and assg.employee=usr.id and conn.applicationnumber = 				applications.applicationnumber and conn.statusid=egwstatus.id limit 1;
		end if;
	END IF;




	IF (v_modulename='Property Tax') THEN

		IF(v_applicationtype = 'New_Assessment' OR v_applicationtype = 'Alter_Assessment' OR v_applicationtype = 'Bifuracate_Assessment' 			OR v_applicationtype = 'Tax_Exemption' OR v_applicationtype = 'Demolition' OR v_applicationtype = 'Amalgamation') THEN
			--raise notice '----------- From property ----------- ';
		
			select state.lastmodifieddate, state.value, usr.username, usr.name into v_modifieddate, v_wf_status, v_username, v_name 		from egpt_property prop, eg_wf_states state, eg_user usr, egeis_assignment assg where prop.state_id = state.id and (CASE WHEN 			state.status=2 then state.lastmodifiedby=usr.id ELSE state.owner_pos=assg.position and (now() between assg.fromdate and 		assg.todate) and assg.isprimary=true and assg.employee=usr.id END) and prop.applicationno = applications.applicationnumber;

		--If primary assignment is not associated with owner position get secondary assignment

		if v_username is null then
		--raise notice 'Not primary';
		select state.lastmodifieddate, state.value, usr.username, usr.name into v_modifieddate, v_wf_status, v_username, v_name from 			egpt_property prop, eg_wf_states state, eg_user usr, egeis_assignment assg where prop.state_id = state.id and 				state.owner_pos=assg.position and (now() between assg.fromdate and assg.todate) and assg.isprimary=false and 			assg.employee=usr.id and prop.applicationno = applications.applicationnumber limit 1;
		end if;
		
		ELSIF(v_applicationtype = 'Revision_Petition' OR v_applicationtype = 'General_Revision_Petition') THEN
			--raise notice '----------- From objection ----------- ';
			select state.lastmodifieddate, state.value, usr.username, usr.name into v_modifieddate, v_wf_status, v_username, v_name 		from egpt_objection obj, eg_wf_states state, eg_user usr, egeis_assignment assg where obj.id_state = state.id and (CASE WHEN 			state.status=2 then state.lastmodifiedby=usr.id ELSE state.owner_pos=assg.position and (now() between assg.fromdate and 		assg.todate) and assg.isprimary=true and assg.employee=usr.id END) and obj.objection_number = applications.applicationnumber;

		--If primary assignment is not associated with owner position get secondary assignment

		if v_username is null then
		select state.lastmodifieddate, state.value, usr.username, usr.name into v_modifieddate, v_wf_status, v_username, v_name from 			egpt_objection obj, eg_wf_states state, eg_user usr, egeis_assignment assg where obj.id_state = state.id and 				state.owner_pos=assg.position and (now() between assg.fromdate and assg.todate) and assg.isprimary=false and 			assg.employee=usr.id and obj.objection_number = applications.applicationnumber limit 1;
		end if;
		
		ELSIF(v_applicationtype = 'Transfer_of_Ownership') THEN
			--raise notice '----------- From mutation ----------- ';
		select state.lastmodifieddate, state.value, usr.username, usr.name into v_modifieddate, v_wf_status, v_username, v_name from 			egpt_property_mutation mut, eg_wf_states state, eg_user usr, egeis_assignment assg where mut.state = state.id and (CASE WHEN 			state.status=2 then state.lastmodifiedby=usr.id ELSE state.owner_pos=assg.position and (now() between assg.fromdate and 		assg.todate) and assg.isprimary=true and assg.employee=usr.id END) and mut.applicationno = applications.applicationnumber;

		--If primary assignment is not associated with owner position get secondary assignment

		if v_username is null then
		select state.lastmodifieddate, state.value, usr.username, usr.name into v_modifieddate, v_wf_status, v_username, v_name from 			egpt_property_mutation mut, eg_wf_states state, eg_user usr, egeis_assignment assg where mut.state = state.id and 			state.owner_pos=assg.position and (now() between assg.fromdate and assg.todate) and assg.isprimary=false and 				assg.employee=usr.id and mut.applicationno = applications.applicationnumber limit 1;
		end if;
		END IF;
		
	END IF;


	IF (v_modulename='Advertisement Tax') THEN

			raise notice '----------- From Advt Tax ----------- ';

			select wf_states.status into v_state_status from eg_wf_states wf_states,
			egadtax_permitdetails advt where applications.applicationnumber=advt.applicationnumber and 
			advt.state_id= wf_states.id;
			raise notice 'v_state_status = % ',v_state_status;
			
			if v_state_status = 2 then
				raise notice ' closed';
				select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name  from egadtax_permitdetails advt, eg_wf_states state, eg_user usr, 			egw_status egwstatus where advt.state_id = state.id and state.lastmodifiedby=usr.id
			and advt.applicationnumber = applications.applicationnumber and advt.status=egwstatus.id;

			else
				raise notice ' not closed';
			select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name from egadtax_permitdetails advt, eg_wf_states state, eg_user usr, 					egeis_assignment assg, egw_status egwstatus where advt.state_id = state.id and 
			state.owner_pos=assg.position and (now() between assg.fromdate and assg.todate) and assg.isprimary=true and 				assg.employee=usr.id and advt.applicationnumber = applications.applicationnumber and advt.status=egwstatus.id;
			end if;


		if v_username is null then
		--raise notice 'Not primary';
			select state.lastmodifieddate, state.value, usr.username, usr.name, egwstatus.description into v_modifieddate, 				v_wf_status, v_username, v_name,  v_egwstatus from egadtax_permitdetails advt, eg_wf_states state, eg_user usr, 			egeis_assignment assg, egw_status egwstatus where advt.state_id = state.id and state.owner_pos=assg.position and (now() 			between assg.fromdate and assg.todate) and assg.isprimary=false and assg.employee=usr.id and advt.applicationnumber = 				applications.applicationnumber and advt.status=egwstatus.id limit 1;
		end if;
	
	END IF;

	IF (v_modulename='Marriage Registration') THEN

			--raise notice '----------- From Marriage Registration ----------- ';

			select wf_states.status into v_state_status from eg_wf_states wf_states,
			egmrs_registration mrs where applications.applicationnumber=mrs.applicationno and 
			mrs.state_id= wf_states.id;
			raise notice 'v_state_status = % ',v_state_status;
			
			if v_state_status = 2 then
				raise notice ' closed';
				select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name  from egmrs_registration mrs, eg_wf_states state, eg_user usr, egw_status 				egwstatus where mrs.state_id = state.id and state.lastmodifiedby=usr.id
			and mrs.applicationno = applications.applicationnumber and mrs.status=egwstatus.id;

			else
				raise notice ' not closed';
			select state.lastmodifieddate, state.value, egwstatus.description, usr.username, usr.name into v_modifieddate, 				v_wf_status, v_egwstatus, v_username, v_name from egmrs_registration mrs, eg_wf_states state, eg_user usr, 					egeis_assignment assg, egw_status egwstatus where mrs.state_id = state.id and 
			state.owner_pos=assg.position and (now() between assg.fromdate and assg.todate) and assg.isprimary=true and 				assg.employee=usr.id and mrs.applicationno = applications.applicationnumber and mrs.status=egwstatus.id;
			end if;

		if v_username is null then
		--raise notice 'Not primary';
			select state.lastmodifieddate, state.value, usr.username, usr.name, egwstatus.description into v_modifieddate, 				v_wf_status, v_username, v_name, v_egwstatus from egmrs_registration mrs, eg_wf_states state, eg_user usr, 				egeis_assignment assg, egw_status egwstatus where mrs.state_id = state.id and state.owner_pos=assg.position and (now() 				between assg.fromdate and assg.todate) and assg.isprimary=false and assg.employee=usr.id and mrs.applicationno = 				applications.applicationnumber and mrs.status=egwstatus.id limit 1;
		end if;
	END IF;

		v_ownername := v_username || '::' || v_name;
		raise notice 'v_modifieddate, v_wf_status, v_ownername, id  (% % % %) ',v_modifieddate, v_wf_status, v_ownername, 			applications.id;
		if(v_wf_status='Closed' OR v_wf_status='END') then
			raise notice '----------All Closed update--------';
			update eg_applicationindex set disposalDate = v_modifieddate, status = v_wf_status, ownername = v_ownername where id = applications.id;
		elsif (v_modulename='Property Tax') then
			raise notice '----------Property tax update--------';
			update eg_applicationindex set status = v_wf_status, ownername = v_ownername where id = applications.id;
		else
			raise notice '----------else--------';
			update eg_applicationindex set status = v_egwstatus, ownername = v_ownername where id = applications.id;
			raise notice 'status = % ',v_egwstatus;
		end if;
	EXCEPTION
	WHEN OTHERS THEN
	  --raise notice 'updateOwnerNameApplicationIndexMissingData failed : % %', SQLERRM, SQLSTATE;
	END;
    END LOOP;
END;
$$ LANGUAGE plpgsql;


