--pushes transaction info for single ward

create or replace function pushtransactions_wardwise(in_wardid bigint)
returns void as 
$$
declare
  v_assessmento character varying(16);
  proprec record;
  v_temp bigint;
begin
  --raise notice 'pushtransactions_wardwise: in_wardid (%)', in_wardid;
  
  for proprec in (select bp.propertyid as upicno from egpt_basic_property bp, egpt_propertyid ptid where bp.id_propertyid = ptid.id and ptid.ward_adm_id = in_wardid)
  loop 
    begin
      v_assessmento := proprec.upicno;
      --raise notice 'pushtransactions_wardwise: v_assessmento (% %)', v_assessmento;
      v_temp := pt_asmt_trans_pushassessment(v_assessmento);
    END;
  end loop;
exception
  when others then
    raise notice 'pushtransactions_wardwise % %', SQLERRM, SQLSTATE;
end;
$$ language plpgsql;


--pushes transaction info for single assessment

create or replace function pt_asmt_trans_pushassessment(in_assessmentno character varying)
returns bigint as 
$BODY$
declare
  props record;
  v_id_basicprop bigint;
  v_id_propertyid bigint;
  v_id_address bigint;
  v_trans_id bigint;
  v_ownersname character varying(256);
  v_doorno character varying(32);
  v_zone bigint;
  v_ward bigint;
  v_block bigint;
  v_locality bigint;
  v_street bigint;
  v_electionward bigint; 
  v_propertytype bigint;
  v_usage character varying(256);
  v_trans_date date;
  v_id_propertydetail bigint;
  v_taxeffectivedate date;
  v_trans_id_prop bigint;
  pk_id_asmt_transactions bigint;
  demands_rec record;
  vr_rec record;
  v_id_demand bigint;
  v_counter bigint;
  v_transactiontype character varying(64);
  v_module bigint;
  v_vr_trns_installment bigint;
  v_mut_trns_installment bigint;
  v_vr_trns_demand bigint;
  v_mut_trns_demand bigint;
  v_vr_trns_property bigint;
  v_mut_trns_property bigint;
  mut_rec record;
  transferee_rec record;
  v_temp bigint;
begin
  select id into v_module from eg_module where name = 'Property Tax';
  select id, id_propertyid, addressid into v_id_basicprop, v_id_propertyid, v_id_address from egpt_basic_property where propertyid = in_assessmentno;
  --raise notice 'pt_asmt_trans_pushassessment: v_id_basicprop, v_id_propertyid, v_id_address (% % %)', v_id_basicprop, v_id_propertyid, v_id_address;
  if (v_id_basicprop is not null) then
    select ownername(v_id_basicprop) into v_ownersname;
    select housenobldgapt into v_doorno from eg_address where id = v_id_address;
    select zone_num, ward_adm_id, adm1, adm2, adm3, elect_bndry into v_zone, v_ward, v_block, v_locality, v_street, v_electionward from egpt_propertyid where id = v_id_propertyid;
    --raise notice 'pt_asmt_trans_pushassessment: v_ownersname, v_doorno, v_zone, v_ward, v_block, v_locality, v_street, v_electionward (% % % % % % % %)', v_ownersname, v_doorno, v_zone, v_ward, v_block, v_locality, v_street, v_electionward;
    for props in (select * from egpt_property where id_basic_property = v_id_basicprop and status not in  ('W', 'C') order by created_date)
    loop
	  v_counter := 1;
	  for demands_rec in (select ptd.id_demand, dmd.id_installment from egpt_ptdemand ptd, eg_demand dmd where ptd.id_demand = dmd.id and ptd.id_property = props.id order by dmd.create_date)
	  loop
	    v_id_demand := demands_rec.id_demand;
	    select id into v_trans_id from egpt_assessment_transactions where basicproperty = v_id_basicprop and property = props.id and id_demand = v_id_demand;
	    if (v_trans_id is null) then
	      --In case the demand is created through rollover then use the demand created date as transaction date
	      if (v_counter > 1) then
		select create_date::date into v_trans_date from eg_demand where id = v_id_demand; 
		v_transactiontype := 'ROLLOVER';
	      else 
		--Notice generate date as transaction date
		select createddate::date into v_trans_date from eg_wf_states where id = (select state_id from egpt_property where id = props.id); 
		if (v_trans_date is null) then
		  --In case the property is created through migration then use the property created date as transaction date
		  select created_date::date into v_trans_date from egpt_property where id = props.id;
		end if;
		-- in case of demolition and tax exemption, get the reason based on the demolition/exemption reason
		if (props.demolitionreason is not null) then
		    v_transactiontype := 'DEMOLITION';
		elsif(props.tax_exempted_reason is not null) then
		    v_transactiontype := 'EXEMPTION';
		else
		    v_transactiontype := props.modify_reason;
		end if;
		v_transactiontype := props.modify_reason;
	      end if;
	      
	      select id, id_propertytypemaster, category_type into v_id_propertydetail, v_propertytype, v_usage from egpt_property_detail where id_property = props.id;
	      select min(occupancydate)::date into v_taxeffectivedate from egpt_floor_detail where id_property_detail = v_id_propertydetail;
	      --raise notice 'pt_asmt_trans_pushassessment: v_trans_date, v_transactiontype, v_id_propertydetail, v_propertytype, v_usage, v_taxeffectivedate (% % % % % %)',  v_trans_date, v_transactiontype, v_id_propertydetail, v_propertytype, v_usage, v_taxeffectivedate;
	      if (v_taxeffectivedate is null) then
		select dateofcompletion::date into v_taxeffectivedate from egpt_property_detail where id_property = props.id;
		--raise notice 'pt_asmt_trans_pushassessment: v_taxeffectivedate (%)', v_taxeffectivedate;
	      end if;
	      select nextval('seq_egpt_assessment_transactions') into pk_id_asmt_transactions;
	      
	      insert into egpt_assessment_transactions(id, basicproperty, property, id_demand, transactiontype, zone, ward, block, street, locality, electionward, ownersname, doorno, propertytype, usage, tax_effectivedate, transaction_date)
	      values (pk_id_asmt_transactions, v_id_basicprop, props.id, v_id_demand, v_transactiontype, v_zone, v_ward, v_block, v_street, v_locality, v_electionward, v_ownersname, v_doorno, v_propertytype, v_usage, v_taxeffectivedate, v_trans_date);
	      
	      select pt_asmt_trans_push_inst_demand_collection(pk_id_asmt_transactions, v_id_demand) into v_temp;
	    end if;
	    v_counter := v_counter + 1;
	  end loop;
    end loop;
    -- Vacancy remission
    for vr_rec in (select vra.approvaldate, vr.id, vr.basicproperty from egpt_vacancy_remission_approval vra, egpt_vacancy_remission vr where vra.vacancyremission = vr.id and vra.isapproved = true and vr.basicproperty = v_id_basicprop )
    loop
      select id into v_trans_id from egpt_assessment_transactions where basicproperty = vr_rec.basicproperty and vancancyremission = vr_rec.id;
      --raise notice 'pt_asmt_trans_pushassessment: v_trans_id (%)', v_trans_id;
      if (v_trans_id is null) then
	select id into v_vr_trns_installment from eg_installment_master where id_module = v_module and vr_rec.approvaldate between start_date and end_date;
	select ptd.id_demand, ptd.id_property into v_vr_trns_demand, v_vr_trns_property from egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand dmd where bp.id = v_id_basicprop and bp.id = prop.id_basic_property and prop.id = ptd.id_property and ptd.id_demand = dmd.id and dmd.id_installment = v_vr_trns_installment;
	select id into v_trans_id from egpt_assessment_transactions where basicproperty = vr_rec.basicproperty order by transaction_date desc limit 1;
	select nextval('seq_egpt_assessment_transactions') into pk_id_asmt_transactions;
	--raise notice 'pt_asmt_trans_pushassessment: v_vr_trns_installment, v_vr_trns_demand, v_vr_trns_property, v_trans_id  (% % % %)', v_vr_trns_installment, v_vr_trns_demand, v_vr_trns_property, v_trans_id;
	if (v_trans_id is not null) then
	  insert into egpt_assessment_transactions(id, basicproperty, property, vacancyremission, id_demand, transactiontype, zone, ward, block, street, locality, electionward, ownersname, doorno, propertytype, usage, tax_effectivedate, transaction_date)
	  select pk_id_asmt_transactions, basicproperty, property, vr_rec.id, v_vr_trns_demand, 'VACANCY_REMISSION', zone, ward, block, street, locality, electionward, ownersname, doorno, propertytype, usage, tax_effectivedate, vr_rec.approvaldate
	   from egpt_assessment_transactions where id = v_trans_id;
	else
	  select id, id_propertytypemaster, category_type into v_id_propertydetail, v_propertytype, v_usage from egpt_property_detail where id_property = v_vr_trns_property;
	  select min(occupancydate)::date into v_taxeffectivedate from egpt_floor_detail where id_property_detail = v_id_propertydetail;
	  --raise notice 'pt_asmt_trans_pushassessment: v_id_propertydetail, v_propertytype, v_usage, v_taxeffectivedate (% % % %)', v_id_propertydetail, v_propertytype, v_usage, v_taxeffectivedate;
	  if (v_taxeffectivedate is null) then
	    select dateofcompletion::date into v_taxeffectivedate from egpt_property_detail where id_property = props.id;
	    --raise notice 'pt_asmt_trans_pushassessment: v_taxeffectivedate (%)', v_taxeffectivedate;
	  end if;
	  insert into egpt_assessment_transactions(id, basicproperty, property, vacancyremission, id_demand, transactiontype, zone, ward, block, street, locality, electionward, ownersname, doorno, propertytype, usage, tax_effectivedate, transaction_date)
	      values (pk_id_asmt_transactions, vr_rec.basicproperty, v_vr_trns_property, vr_rec.id, v_vr_trns_demand, 'VACANCY_REMISSION', v_zone, v_ward, v_block, v_street, v_locality, v_electionward, v_ownersname, v_doorno, v_propertytype, v_usage, v_taxeffectivedate, vr_rec.approvaldate);
	end if;
	select pt_asmt_trans_push_inst_demand_collection(pk_id_asmt_transactions, v_vr_trns_demand) into v_temp;    
      end if;
    end loop;
    
    -- Mutation
    for mut_rec in (select * from egpt_property_mutation where basicproperty = v_id_basicprop and state in (select id from eg_wf_states where type = 'PropertyMutation' and status = 2))
    loop
      select id into v_trans_id from egpt_assessment_transactions where basicproperty = mut_rec.basicproperty and mutation = mut_rec.id;
      --raise notice 'pt_asmt_trans_pushassessment: v_trans_id (%)', v_trans_id;
      if (v_trans_id is null) then
	select id into v_mut_trns_installment from eg_installment_master where id_module = v_module and mut_rec.mutationdate between start_date and end_date;
	select ptd.id_demand, ptd.id_property into v_mut_trns_demand, v_mut_trns_property from egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand dmd where bp.id = v_id_basicprop and bp.id = prop.id_basic_property and prop.id = ptd.id_property and ptd.id_demand = dmd.id and dmd.id_installment = v_mut_trns_installment;
	select id into v_trans_id from egpt_assessment_transactions where basicproperty = mut_rec.basicproperty order by transaction_date desc limit 1;
	select nextval('seq_egpt_assessment_transactions') into pk_id_asmt_transactions;
	--raise notice 'pt_asmt_trans_pushassessment: v_mut_trns_installment, v_mut_trns_demand, v_mut_trns_property, v_trans_id (% % % %)', v_mut_trns_installment, v_mut_trns_demand, v_mut_trns_property, v_trans_id;
	v_ownersname := '';
	for transferee_rec in (select * from eg_user where id in (select transferee from egpt_mutation_transferee where mutation = mut_rec.id))
	loop
	  if v_ownersname <> '' then
	    v_ownersname := v_ownersname || ',' || transferee_rec.name;
	  else
	    v_ownersname := transferee_rec.name;
          end if;  
	end loop;
	--raise notice 'v_ownersname, (%)', v_ownersname;
	if (v_trans_id is not null) then
	  insert into egpt_assessment_transactions(id, basicproperty, property, mutation, id_demand, transactiontype, zone, ward, block, street, locality, electionward, ownersname, doorno, propertytype, usage, tax_effectivedate, transaction_date)
	  select pk_id_asmt_transactions, basicproperty, property, mut_rec.id, v_mut_trns_demand, mut_rec.type, zone, ward, block, street, locality, electionward, v_ownersname, doorno, propertytype, usage, tax_effectivedate, mut_rec.mutationdate
	   from egpt_assessment_transactions where id = v_trans_id;
	else
	  select id, id_propertytypemaster, category_type into v_id_propertydetail, v_propertytype, v_usage from egpt_property_detail where id_property = v_mut_trns_property;
	  select min(occupancydate)::date into v_taxeffectivedate from egpt_floor_detail where id_property_detail = v_id_propertydetail;
	  --raise notice 'pt_asmt_trans_pushassessment: v_id_propertydetail, v_propertytype, v_usage, v_taxeffectivedate (% % % %)', v_id_propertydetail, v_propertytype, v_usage, v_taxeffectivedate;
	  if (v_taxeffectivedate is null) then
	    select dateofcompletion::date into v_taxeffectivedate from egpt_property_detail where id_property = props.id;
	    --raise notice 'pt_asmt_trans_pushassessment: v_taxeffectivedate (%)', v_taxeffectivedate;
	  end if;
	  insert into egpt_assessment_transactions(id, basicproperty, property, mutation, id_demand, transactiontype, zone, ward, block, street, locality, electionward, ownersname, doorno, propertytype, usage, tax_effectivedate, transaction_date)
	      values (pk_id_asmt_transactions, mut_rec.basicproperty, v_mut_trns_property, mut_rec.id, v_mut_trns_demand, mut_rec.type, v_zone, v_ward, v_block, v_street, v_locality, v_electionward, v_ownersname, v_doorno, v_propertytype, v_usage, v_taxeffectivedate, mut_rec.mutationdate);  
	end if;
	select pt_asmt_trans_push_inst_demand_collection(pk_id_asmt_transactions, v_mut_trns_demand) into v_temp;  
      end if;
    end loop;
  end if;
  return 1;
  EXCEPTION
    WHEN OTHERS THEN
      raise notice 'pt_asmt_trans_pushassessment: : % %', SQLERRM, SQLSTATE;
end 
$BODY$ language plpgsql;

--pushes demand amd collection details for assessment transactions

create or replace function pt_asmt_trans_push_inst_demand_collection(in_id_ass_transactions bigint, in_id_demand bigint)
returns bigint as 
$BODY$
declare
  installment_rec record;
  v_advance double precision;
  v_id_demand_info bigint;
  receips_rec record;
  v_paymentmode character varying(50);
  v_amt double precision;
  v_inst_coll_id bigint;
begin
  for installment_rec in (select id_installment, coalesce(sum(amount), 0) amount, coalesce(sum(amt_collected), 0) collection from eg_demand_details dd, eg_demand_reason dr where dd.id_demand = in_id_demand and dd.id_demand_reason = dr.id 
    and dr.id_demand_reason_master <> (select id from eg_demand_reason_master where code = 'ADVANCE') group by dr.id_installment)
    loop
      select coalesce(sum(amt_collected), 0) into v_advance from eg_demand_details dd, eg_demand_reason dr where dd.id_demand = in_id_demand and dd.id_demand_reason = dr.id 
      and dr.id_demand_reason_master = (select id from eg_demand_reason_master where code = 'ADVANCE') and dr.id_installment = installment_rec.id_installment;	      
      select nextval('seq_egpt_installment_demand_info') into v_id_demand_info;
      --raise notice 'pt_asmt_trans_push_inst_demand_collection: v_id_demand_info, in_id_ass_transactions, id_installment, amount, collection, v_advance (% % % % % %)', v_id_demand_info, in_id_ass_transactions, installment_rec.id_installment, installment_rec.amount, installment_rec.collection, v_advance;
      insert into egpt_installment_demand_info(id, assessment_transactions, installment, demand, totalcollection, advance, writeoff) 
	values (v_id_demand_info, in_id_ass_transactions, installment_rec.id_installment, installment_rec.amount, installment_rec.collection, v_advance, 0);
      
      for receips_rec in (select dmcr.* from egdm_collected_receipts dmcr, eg_demand_details dd, eg_demand_reason dr where dd.id_demand = in_id_demand and dd.id_demand_reason = dr.id and dr.id_installment = installment_rec.id_installment and dmcr.id_demand_detail = dd.id)
      loop
	
	select insttype.type into v_paymentmode from egf_instrumenttype insttype, egf_instrumentheader instrhead, egcl_collectioninstrument collinstr, egcl_collectionheader ch 
	where ch.receiptnumber = receips_rec.receipt_number and ch.id = collinstr.collectionheader and collinstr.instrumentheader = instrhead.id and instrhead.instrumenttype = insttype.id;
	
	select coalesce(amount, 0), id into v_amt, v_inst_coll_id from egpt_installment_collection_info where receiptnumber = receips_rec.receipt_number and installment_demand_info = v_id_demand_info;
	
	if (v_amt > 0) then
	  update egpt_installment_collection_info set amount = amount + receips_rec.reason_amount where id = v_inst_coll_id;
	else
	  --raise notice 'pt_asmt_trans_push_inst_demand_collection: v_id_demand_info, receipt_date, receipt_number, v_paymentmode, reason_amount (% % % % %)', v_id_demand_info, receips_rec.receipt_date::date, receips_rec.receipt_number, v_paymentmode, receips_rec.reason_amount;
	  insert into egpt_installment_collection_info(id, installment_demand_info, collectiondate, receiptnumber, collectionmode, amount) values (nextval('seq_egpt_installment_collection_info'), 
	  v_id_demand_info, receips_rec.receipt_date::date, receips_rec.receipt_number, v_paymentmode, receips_rec.reason_amount);
	end if;
      end loop;
    end loop;
  return 1;
  EXCEPTION
    WHEN OTHERS THEN
      raise notice 'pt_asmt_trans_push_inst_demand_collection: : % %', SQLERRM, SQLSTATE;
end 
$BODY$ language plpgsql;
