CREATE OR REPLACE FUNCTION pt_rollovercity(in_old1st_inststartdate varchar(16), in_old2nd_inststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
wards record;

v_temp integer;
BEGIN
	for wards in (select id,name from eg_boundary where boundarytype=(select id from eg_boundary_type where name = 'Ward' and hierarchytype=(select id from eg_hierarchy_type where code='REVENUE')))
	loop 
		begin
			----raise notice 'pt_rollovercity : Started for Ward ', wards.name;
			v_temp  := pt_rolloverward(wards.id, in_old1st_inststartdate, in_old2nd_inststartdate, in_new1st_inststartdate, in_new2nd_inststartdate);
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'rolloverward : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--rolloverward
CREATE OR REPLACE FUNCTION pt_rolloverward(in_wardid bigint, in_old1st_inststartdate varchar(16), in_old2nd_inststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
props record;

v_old1st_instid bigint;
v_old2nd_instid bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_newInstId integer;
v_temp integer;
v_rollovercount integer default 0;
BEGIN
	--raise notice 'rolloverward : in_wardid, in_old1st_inststartdate, in_old2nd_inststartdate, in_new1st_inststartdate, in_new2nd_inststartdate (% % % % %)', in_wardid, in_old1st_inststartdate, in_old2nd_inststartdate, in_new1st_inststartdate, in_new2nd_inststartdate;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_old1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_old1st_inststartdate, 'dd/MM/yyyy');
	select id into v_old2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_old2nd_inststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	--raise notice 'rolloverward : v_old1st_instid, v_old2nd_instid, v_new1st_instid, v_new2nd_instid (% % % %)', v_old1st_instid, v_old2nd_instid, v_new1st_instid, v_new2nd_instid;
	
    for props in (SELECT bp.propertyid, p.id FROM egpt_basic_property bp, egpt_property p, egpt_propertyid pid
WHERE bp.id = p.id_basic_property AND p.is_default_property = 'Y' AND p.status in ('A','I','W') AND bp.id_propertyid = pid.id
AND pid.ward_adm_id = in_wardid
except
    SELECT bp.propertyid, prop.id FROM egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, egpt_propertyid pid, eg_demand dem 
WHERE bp.id = prop.id_basic_property AND prop.id = ptd.id_property AND ptd.id_demand = dem.id AND prop.is_default_property = 'Y' AND prop.status in ('A','I','W') AND bp.id_propertyid = pid.id AND pid.ward_adm_id = in_wardid AND dem.id_installment = v_new1st_instid)
    loop 
		begin
			--raise notice 'rolloverward : Started for assessmentno, idproperty (% %)', props.propertyid, props.id;
			v_temp  := pt_rollover(props.id, v_old1st_instid, v_old2nd_instid, v_new1st_instid, v_new2nd_instid);
			v_rollovercount := v_rollovercount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'rolloverward : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--rolloversingleproperty
CREATE OR REPLACE FUNCTION pt_rolloversingleproperty(in_assessmentno varchar(16), in_old1st_inststartdate varchar(16), in_old2nd_inststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
v_idproperty	integer;
v_old1st_instid bigint;
v_old2nd_instid bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc 	varchar(16);
v_moduleid 	bigint;
v_newInstId 	integer;
v_temp 		integer;
props record;
BEGIN
	--raise notice 'rolloversingleproperty : in_assessmentno, in_old1st_inststartdate, in_old2nd_inststartdate, in_new1st_inststartdate, in_new2nd_inststartdate (% % % % %)', in_assessmentno, in_old1st_inststartdate, in_old2nd_inststartdate, in_new1st_inststartdate, in_new2nd_inststartdate;

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_old1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_old1st_inststartdate, 'dd/MM/yyyy');
	select id into v_old2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_old2nd_inststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	--raise notice 'rolloversingleproperty : v_old1st_instid, v_old2nd_instid, v_new1st_instid, v_new2nd_instid (% % % %)', v_old1st_instid, v_old2nd_instid, v_new1st_instid, v_new2nd_instid;

	for props in (SELECT p.id FROM egpt_basic_property bp, egpt_property p WHERE bp.id = p.id_basic_property AND p.is_default_property = 'Y' AND p.status in ('A','I','W') AND bp.propertyid = in_assessmentno
	except
		SELECT prop.id FROM egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand dem WHERE bp.id = prop.id_basic_property AND prop.id = ptd.id_property AND ptd.id_demand = dem.id AND prop.is_default_property = 'Y' AND prop.status in ('A','I','W') and bp.propertyid = in_assessmentno AND dem.id_installment = v_new1st_instid)
	loop 
		begin
			--raise notice 'rolloversingleproperty : Started for idproperty (%)', props.id;
			v_temp  := pt_rollover(props.id, v_old1st_instid, v_old2nd_instid, v_new1st_instid, v_new2nd_instid);
		EXCEPTION
		WHEN OTHERS THEN
		  raise notice 'rolloversingleproperty : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--rollover
CREATE OR REPLACE FUNCTION pt_rollover(in_idproperty bigint, in_old1st_instid bigint, in_old2nd_instid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_olddemandid	bigint;
v_newdemandid	bigint;
v_temp 			integer;
BEGIN
	--raise notice 'rollover : in_idproperty, in_old1st_instid, in_old2nd_instid, in_new_1stinstid, in_new_2ndinstid (% % % % %)', in_idproperty, in_old1st_instid, in_old2nd_instid, in_new_1stinstid, in_new_2ndinstid;

    select d.id into v_olddemandid from eg_demand d, egpt_ptdemand pd where d.id_installment = in_old1st_instid and d.id = pd.id_demand and pd.id_property = in_idproperty;
    --raise notice 'rollover : v_olddemandid (%)', v_olddemandid;

    --select id_basic_property into idBasicProp from egpt_property where id_property=in_idproperty;
    SELECT nextval('seq_eg_demand') INTO v_newdemandid;
    --raise notice 'rollover : v_newdemandid (%)', v_newdemandid;    

	--creating new eg_demand for new installment.
    insert into eg_demand (id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected, status, min_amt_payable, amt_rebate)
	select v_newdemandid, in_new_1stinstid, base_demand, is_history, now(), now(), 0, status, null, 0 from eg_demand where id = v_olddemandid;

	--creating new egpt_demandcalculations for new installment.
	insert into egpt_demandcalculations (id, id_demand, propertytax, rate_of_tax, current_interest, arrear_interest, modified_date, created_date, created_by, modified_by, taxinfo, alv)
	select nextval('seq_egpt_demandcalculations'), v_newdemandid, propertytax, rate_of_tax, current_interest, arrear_interest, now(), now(), 1, 1, taxinfo, alv from egpt_demandcalculations where id_demand = v_olddemandid;

	--creating new EGPT_PTDEMAND for new installment.
    insert into egpt_ptdemand (id_demand, id_property) values (v_newdemandid, in_idproperty);

	--copying old demand_demand_details to new eg_demand.
	
    insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate)
    select nextval('seq_eg_demand_details'), v_newdemandid, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate from eg_demand_details where id_demand = v_olddemandid
     and id_demand_reason not in (select id from eg_demand_reason where id_demand_reason_master = (select id from eg_demand_reason_master where code = 'ADVANCE'));

	v_temp := pt_createddforannual(v_olddemandid, v_newdemandid, in_old2nd_instid, in_new_1stinstid, in_new_2ndinstid);
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--rollover
CREATE OR REPLACE FUNCTION pt_createddforannual(in_olddemandid bigint, in_newdemandid bigint, in_old2nd_instid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_temp 			integer;
BEGIN
	--raise notice 'createddforannual : in_olddemandid, in_newdemandid, in_old2nd_instid, in_new_1stinstid, in_new_2ndinstid (% % % % %)', in_olddemandid, in_newdemandid, in_old2nd_instid, in_new_1stinstid, in_new_2ndinstid;
--1st Half
    insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate)
    select nextval('seq_eg_demand_details'), in_newdemandid, dr2.id, dd.id_status, dd.file_reference_no, dd.remarks, dd.amount, now(), now(), 0, 0 from eg_demand_details dd, eg_demand_reason dr1, eg_demand_reason dr2
where dd.id_demand=in_olddemandid
and dd.amount>0
and dr1.id_demand_reason_master=dr2.id_demand_reason_master
and dd.id_demand_reason=dr1.id
and dr1.id_demand_reason_master not in (select id from eg_demand_reason_master where module=359 and code in ('CHQ_BUNC_PENALTY', 'PENALTY_FINES'))
and dr1.id_installment=in_old2nd_instid
and dr2.id_installment=in_new_1stinstid;
--raise notice '1st half created';
--2nd Half
    insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, amt_rebate)
    select nextval('seq_eg_demand_details'), in_newdemandid, dr2.id, dd.id_status, dd.file_reference_no, dd.remarks, dd.amount, now(), now(), 0, 0 from eg_demand_details dd, eg_demand_reason dr1, eg_demand_reason dr2
where dd.id_demand=in_olddemandid
and dd.amount>0
and dr1.id_demand_reason_master=dr2.id_demand_reason_master
and dd.id_demand_reason=dr1.id
and dr1.id_demand_reason_master not in (select id from eg_demand_reason_master where module=359 and code in ('CHQ_BUNC_PENALTY', 'PENALTY_FINES'))
and dr1.id_installment=in_old2nd_instid
and dr2.id_installment=in_new_2ndinstid;
--raise notice '2nd half created';
	v_temp := pt_serveadvance(in_olddemandid, in_newdemandid, in_new_2ndinstid);
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

--City wise rollover
CREATE OR REPLACE FUNCTION pt_serveadvance(in_olddemandid bigint, in_newdemandid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
demanddets record;
v_ddid 			integer;
v_tax 			double precision;
v_collection 	double precision;
v_balance 		double precision;
v_advancecoll 	double precision;
v_temp 			integer;
v_assessmentno character varying(24);
v_finyear character varying(24);
BEGIN
	--raise notice 'pt_serveadvance : in_olddemandid, in_newdemandid (% %)', in_olddemandid, in_newdemandid;
	select dd.amt_collected into v_advancecoll from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand=in_olddemandid and dd.id_demand_reason=dr.id and dr.id_demand_reason_master=drm.id and drm.code='ADVANCE';
	--raise notice 'pt_serveadvance : v_advancecoll (%)', v_advancecoll;
	if (v_advancecoll>0) then
	
	  select financial_year into v_finyear from eg_installment_master where id = in_new_2ndinstid;
	 
	  select propertyid into v_assessmentno from egpt_basic_property where id = (select id_basic_property from egpt_property where id = (select id_property from egpt_ptdemand where id_demand = in_newdemandid));
	  
	  insert into egpt_advance_adjusted(assessmentno, financialyear, amt_adjusted) values (v_assessmentno, v_finyear, v_advancecoll);
	  
	  for demanddets in (select dd.id ddid, dd.amount, dd.amt_collected from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst where dd.id_demand=in_newdemandid and dd.id_demand_reason=dr.id and dr.id_demand_reason_master=drm.id and dr.id_installment=inst.id and drm.code!='ADVANCE' and (dd.amount-dd.amt_collected)>0 order by inst.start_date, drm."order")
	    loop 
		  v_ddid := demanddets.ddid;
		  v_tax := demanddets.amount;
		  v_collection := demanddets.amt_collected;
		  v_balance := v_tax-v_collection;
		  --raise notice 'pt_serveadvance : v_ddid, v_tax, v_collection, v_balance (% % % %)', v_ddid, v_tax, v_collection, v_balance;
		  begin
			  --raise notice 'pt_serveadvance : inside loop start v_advancecoll (%)', v_advancecoll;
			  if(v_advancecoll=0)then
				  return v_temp; 
			  end if;
			  if(v_advancecoll>v_balance)then
				  update eg_demand_details set amt_collected=amt_collected+v_balance where id=v_ddid;
				  v_advancecoll := v_advancecoll - v_balance;
			  else
				  update eg_demand_details set amt_collected=amt_collected+v_advancecoll where id=v_ddid;
				  v_advancecoll := 0;
			  end if;
			  --raise notice 'pt_serveadvance : inside loop end v_advancecoll (%)', v_advancecoll;
		  EXCEPTION
		  WHEN OTHERS THEN
		  raise notice 'rolloverward : % %', SQLERRM, SQLSTATE;
		  END;
	    END LOOP;
	  if (v_advancecoll > 0) then
	    Insert into eg_demand_details (ID,ID_DEMAND,ID_DEMAND_REASON,ID_STATUS,FILE_REFERENCE_NO,REMARKS,AMOUNT,modified_date,create_date,AMT_COLLECTED,AMT_REBATE) 
	    values (nextval('seq_eg_demand_details'),in_newdemandid,(select id from eg_demand_reason where id_installment = in_new_2ndinstid
	    and id_demand_reason_master = (select id from eg_demand_reason_master where code = 'ADVANCE')),1,null,null,0,now(),now(),v_advancecoll,0);
	  end if;
	end if;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;


create or replace function pushvacancyremissionassessments(in_old2nd_inststartdate varchar(16))
returns numeric
as
$$
declare
  v_module bigint;
  v_inst_start_date timestamp without time zone;
  v_inst_end_date timestamp without time zone;
  v_finyear character varying(12);
begin
  --raise notice 'pushvacancyremissionassessments : in_old2nd_inststartdate (%)', in_old2nd_inststartdate;
  select id into v_module from eg_module where name = 'Property Tax';
  
  select start_date, end_date, financial_year into v_inst_start_date, v_inst_end_date, v_finyear  from eg_installment_master where id_module = v_module and start_date = to_date(in_old2nd_inststartdate, 'dd/MM/yyyy');

  --raise notice 'pushvacancyremissionassessments : v_inst_start_date, v_inst_end_date, v_finyear, (% % %)',  v_inst_start_date, v_inst_end_date, v_finyear;

  insert into egpt_rollover_vacany_remission(assessmentno, financialyear) 
  select bp.propertyid, v_finyear from egpt_vacancy_remission vr, egpt_basic_property bp where bp.id = vr.basicproperty and vr.status = 'APPROVED' and vr.vacancy_todate between v_inst_start_date and v_inst_end_date
    except select assessmentno, financialyear from egpt_rollover_vacany_remission;

  return 1;
end;
$$ language plpgsql;


create or replace function rebateforvacanyremissionassessments(in_old1st_inststartdate varchar(16), in_new1st_inststartdate varchar(16))
returns numeric
as
$$
declare
  v_oldfinyear character varying(50);
  rec record;
  dmdrec record;
  demanddets record;
  v_module bigint;
  v_currfirsthalf bigint;
  v_dmdid bigint;
  v_excesscoll double precision;
  v_ddid bigint;
  v_tax double precision;
  v_collection double precision;
  v_balance double precision;
  v_temp numeric;
  v_currsecondhalf bigint;
begin
  --raise notice 'rebateforvacanyremissionassessments : in_old1st_inststartdate, in_new1st_inststartdate (% %)', in_old1st_inststartdate, in_new1st_inststartdate;
  select id into v_module from eg_module where name = 'Property Tax';
  
  select id into v_currfirsthalf from eg_installment_master where id_module = v_module and start_date =  to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
  
  select financialyear into v_oldfinyear from financialyear where startingdate = to_date(in_old1st_inststartdate, 'dd/MM/yyyy');
  
  select inst.id into v_currsecondhalf from eg_installment_master inst, financialyear fin where fin.startingdate = to_date(in_new1st_inststartdate, 'dd/MM/yyyy') and fin.financialyear = inst.financial_year
    and inst.id_module = v_module and fin.endingdate between inst.start_date and inst.end_date;
  
  --raise notice 'rebateforvacanyremissionassessments : v_currfirsthalf, v_currsecondhalf, v_oldfinyear (% % %)', v_currfirsthalf, v_currsecondhalf, v_oldfinyear;
  
  for rec in (select assessmentno from egpt_rollover_vacany_remission where isrolledover = false and financialyear = v_oldfinyear)
  loop
    select d.id into v_dmdid from egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand d where bp.propertyid = rec.assessmentno and bp.id = prop.id_basic_property 
    and prop.id = ptd.id_property and ptd.id_demand = d.id and prop.is_default_property = 'Y' and prop.status = 'A' and d.id_installment = v_currfirsthalf;
    
    if (v_dmdid is null) then
      raise notice 'rebateforvacanyremissionassessments: Demand is not generated for this assessmentno: (%)', rec.assessmentno;
      continue;
    end if;
    
    --raise notice 'rebateforvacanyremissionassessments : v_dmdid (%)', v_dmdid;
    update eg_demand_details set amount = amount/2 where id_demand = v_dmdid and id_demand_reason in (select id from eg_demand_reason where id_installment = v_currfirsthalf)
     and amount is not null and amount > 0;
    
    v_excesscoll := 0;
    for dmdrec in (select id, amount, amt_collected from eg_demand_details where id_demand = v_dmdid and id_demand_reason in (select id from eg_demand_reason where id_installment = v_currfirsthalf))
    loop
      if (dmdrec.amt_collected > dmdrec.amount) then
	v_excesscoll := v_excesscoll + (dmdrec.amt_collected - dmdrec.amount);
	update eg_demand_details set amt_collected = amount where id = dmdrec.id;
      end if;
    end loop;
    --raise notice 'rebateforvacanyremissionassessments : v_excesscoll (%)', v_excesscoll;
    if (v_excesscoll > 0) then
      for demanddets in (select dd.id ddid, dd.amount, dd.amt_collected from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst where dd.id_demand=v_dmdid and dd.id_demand_reason=dr.id and dr.id_demand_reason_master=drm.id and dr.id_installment=inst.id and drm.code!='ADVANCE' and (dd.amount-dd.amt_collected)>0 order by inst.start_date, drm.code)
	loop 
		v_ddid := demanddets.ddid;
		v_tax := demanddets.amount;
		v_collection := demanddets.amt_collected;
		v_balance := v_tax-v_collection;
		--raise notice 'rebateforvacanyremissionassessments : v_ddid, v_tax, v_collection, v_balance (% % % %)', v_ddid, v_tax, v_collection, v_balance;
		begin
			--raise notice 'rebateforvacanyremissionassessments : inside loop start v_excesscoll (%)', v_excesscoll;
			if(v_excesscoll=0)then
				return v_temp; 
			end if;
			if(v_excesscoll>v_balance)then
				update eg_demand_details set amt_collected=amt_collected+v_balance where id=v_ddid;
				v_excesscoll := v_excesscoll - v_balance;
			else
				update eg_demand_details set amt_collected=amt_collected+v_excesscoll where id=v_ddid;
				v_excesscoll := 0;
			end if;
			--raise notice 'rebateforvacanyremissionassessments : inside loop end v_excesscoll (%)', v_excesscoll;
		EXCEPTION
		WHEN OTHERS THEN
		  raise notice 'rebateforvacanyremissionassessments: : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	--raise notice 'rebateforvacanyremissionassessments : v_excesscoll (%)', v_excesscoll;
	if (v_excesscoll>0) then
	  Insert into eg_demand_details (ID,ID_DEMAND,ID_DEMAND_REASON,ID_STATUS,FILE_REFERENCE_NO,REMARKS,AMOUNT,modified_date,create_date,AMT_COLLECTED,AMT_REBATE) 
	  values (nextval('seq_eg_demand_details'),v_dmdid,(select id from eg_demand_reason where id_installment = v_currsecondhalf
	  and id_demand_reason_master = (select id from eg_demand_reason_master where code = 'ADVANCE')),1,null,null,0,now(),now(),v_excesscoll,0);
	end if;
    end if;
    update egpt_rollover_vacany_remission set isrolledover = true where assessmentno = rec.assessmentno and financialyear = v_oldfinyear;
  end loop;
  return 1;
end;
$$ language plpgsql;