CREATE OR REPLACE FUNCTION wtms_WaterCharge_Demand_Bill_Rollover()
RETURNS void AS
$BODY$
DECLARE
props record;
v_temp   bigint;
v_temp1   bigint;
BEGIN
	
for props in (select id,name from eg_boundary where id in(select distinct(ward_adm_id) from egpt_propertyid where id in(select id_propertyid from egpt_basic_property where propertyid in(select propertyidentifier from egwtr_connection where id in
(select  connection from egwtr_connectiondetails conndet,egw_status status where conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' and conndet.connectiontype='NON_METERED' and conndet.connectionstatus='ACTIVE' )))))
	loop 
		begin
			v_temp  := wtms_demand_rolloverWard(props.id,'01/10/2016','01/04/2017','01/10/2017');

		EXCEPTION
		WHEN OTHERS THEN
		raise notice ' rolloverward For FULL ULB  % %',SQLERRM, SQLSTATE;
		END;
	END LOOP;
	
END;
$BODY$ LANGUAGE plpgsql;


--ward wise rollover
CREATE OR REPLACE FUNCTION wtms_demand_rolloverWard(in_wardid bigint, in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
props record;
v_oldinstid bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_newInstId integer;
v_temp integer;
v_rollovercount integer default 0;
BEGIN

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');

	for props in (SELECT distinct conn.consumercode, conndet.id FROM egwtr_connection conn,egwtr_connectiondetails conndet, egpt_basic_property bp, egpt_property p, egpt_propertyid pid,egw_status status WHERE conn.id=conndet.connection and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' and bp.id = p.id_basic_property and bp.id_propertyid = pid.id and bp.propertyid=conn.propertyidentifier AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' AND pid.ward_adm_id = in_wardid)
	loop 
		begin
			v_temp  := wtms_rolloverByConnectionDetId(props.id, v_oldinstid, v_new1st_instid, v_new2nd_instid);
			v_rollovercount := v_rollovercount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice ' rolloverward conndetId  and consumercode: % % % %',props.id,props.consumercode,SQLERRM, SQLSTATE;
		END;
	END LOOP;
	raise notice 'wtms_rolloverward completed for Ward: (%)', in_wardid;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION wtms_rolloverByConnectionDetId(in_idconndetail bigint, in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_olddemandid	bigint;
v_newdemandid	bigint;
v_newConnDemand bigint;
v_temp 	integer;
v_glcodeid bigint;
v_iddemResmaster bigint;
v_newdemand_reason bigint;
v_newdemand_reason2 bigint;
v_demandAmountfromWtRate double precision;
v_demandreasoninst1 bigint;
v_advanceAmtColl  double precision;
v_demandreasoninst2 bigint;
v_sumOfAmtCollected double precision;
v_demandexistforInstallment bigint;
BEGIN

	select d.id into v_olddemandid from eg_demand d, egwtr_demand_connection conndem where d.id = conndem.demand and  conndem.connectiondetails = in_idconndetail and d.is_history='N';
	select id into v_glcodeid from chartofaccounts where glcode='1405016';
	select id into v_iddemResmaster from eg_demand_reason_master where code='WTAXCHARGES';
	SELECT id into v_demandreasoninst1 from eg_demand_reason where id_demand_reason_master=v_iddemResmaster 
	and id_installment=in_new_1stinstid;
-- demandReason entry for installments
--1st Half
	if(v_demandreasoninst1 is null) then
	SELECT nextval('SEQ_EG_DEMAND_REASON') INTO v_newdemand_reason;
		insert into eg_demand_reason(id, id_demand_reason_master, id_installment, 
		percentage_basis, id_base_reason, create_date, modified_date, glcodeid) values
		 (v_newdemand_reason, v_iddemResmaster, in_new_1stinstid, null,null,now(),now(), v_glcodeid);
	end if;

	SELECT id into v_demandreasoninst2 from eg_demand_reason where id_demand_reason_master 
	=v_iddemResmaster and id_installment=in_new_2ndinstid;
 
	if(v_demandreasoninst2 is null) then
	SELECT nextval('SEQ_EG_DEMAND_REASON') INTO v_newdemand_reason2;
		insert into eg_demand_reason(id, id_demand_reason_master, id_installment, percentage_basis, id_base_reason, create_date, modified_date, glcodeid) values (v_newdemand_reason2, v_iddemResmaster,in_new_2ndinstid, null,null,now(),now(), v_glcodeid);
	end if;
	
	select (waterratedet.monthlyrate*6) into v_demandAmountfromWtRate from 
	egwtr_water_rates_details waterratedet where waterratedet.waterratesheader in (select wthead.id from egwtr_water_rates_header wthead, 	egwtr_connectiondetails conndet where wthead.connectiontype='NON_METERED' and wthead.connectiontype=conndet.connectiontype and wthead.usagetype=conndet.usagetype and wthead.pipesize=conndet.pipesize and wthead.watersource=conndet.watersource and wthead.active=true and conndet.id=in_idconndetail);
	
	select nextval('SEQ_EG_DEMAND') into v_newdemandid; 																																																																																	
	SELECT amt_collected into v_advanceAmtColl from eg_demand_details dd, eg_demand_reason dr, 
	eg_demand_reason_master drm where dd.id_demand=v_olddemandid and dd.id_demand_reason=dr.id and 
	dr.id_demand_reason_master=drm.id and drm.code='WTADVANCE';

	select sum(amt_collected) into v_sumOfAmtCollected from eg_demand_details where  id_demand = v_olddemandid and  id_demand_reason not in 	(select id from eg_demand_reason where id_demand_reason_master = (select id from eg_demand_reason_master where code = 'WTADVANCE'));


	 insert into eg_demand (id, id_installment, base_demand, is_history, create_date, modified_date,
	 amt_collected, status, min_amt_payable, amt_rebate) select v_newdemandid, in_new_1stinstid, 
	 base_demand, is_history, now(), now(), v_sumOfAmtCollected, status, null, 0 from eg_demand where id = v_olddemandid;
--copying old demand_demand_details to new eg_demand accept ADVANCE ENTRY.

	insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks,
	amount, modified_date, 
	create_date, amt_collected, amt_rebate) select nextval('seq_eg_demand_details'), v_newdemandid, 
	id_demand_reason, 
	id_status, file_reference_no, remarks, amount, modified_date, create_date, amt_collected, 
	amt_rebate from eg_demand_details 
	where id_demand = v_olddemandid and  id_demand_reason not in (select id from eg_demand_reason 
	where id_demand_reason_master = (select id from eg_demand_reason_master where code = 'WTADVANCE')) ;

	update eg_demand set is_history='Y' where  id=v_olddemandid;

	v_temp := wtms_DemandDetailsEntryForFinancialYear(v_demandAmountfromWtRate ,v_olddemandid,
	v_newdemandid,v_advanceAmtColl, in_oldinstid, in_new_1stinstid, in_new_2ndinstid);

 	SELECT nextval('seq_egwtr_demand_connection') INTO v_newConnDemand;
 	
        insert into egwtr_demand_connection (id,demand, connectiondetails,createdby,createddate,
        lastmodifieddate,lastmodifiedby,version) values (v_newConnDemand,v_newdemandid,in_idconndetail,1,now(),now(),1,0);

	raise notice 'demand got generated for in_idconndetail (%)',in_idconndetail;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;



CREATE OR REPLACE FUNCTION wtms_DemandDetailsEntryForFinancialYear(v_demandAmountfromWtRate double precision,in_olddemandid bigint, in_newdemandid bigint,v_advanceAmtColl  double precision,in_oldinstid bigint, in_new_1stinstid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
v_demandreason_1instalment bigint;
v_demandreason_2instalment bigint;
v_demandreason_oldinstalment bigint;
v_ddfirsthalf bigint;
v_ddsecondhalf bigint;
v_sumOfAmount double precision;
v_temp integer;
v_oldddamount double precision;
BEGIN
	select id into v_demandreason_1instalment from eg_demand_reason where id_demand_reason_master in(select id from eg_demand_reason_master 	where code='WTAXCHARGES') and id_installment=in_new_1stinstid;

	select id into v_demandreason_oldinstalment from eg_demand_reason where id_demand_reason_master in
	(select id from eg_demand_reason_master where code='WTAXCHARGES') and id_installment=in_oldinstid;

	select id into v_demandreason_2instalment from eg_demand_reason where id_demand_reason_master in(select id from eg_demand_reason_master 	where code='WTAXCHARGES') and id_installment=in_new_2ndinstid;

	raise notice 'new v_demandreason details id (% %)',v_demandreason_1instalment,v_demandreason_2instalment;

	select amount into v_oldddAmount from  eg_demand_details where id_demand=in_olddemandid 
  	and id_demand_reason=v_demandreason_oldinstalment;

	select sum(amount) into v_sumOfAmount from eg_demand_details where  id_demand = in_olddemandid and  
	id_demand_reason not in (select id from eg_demand_reason where id_demand_reason_master =  
	(select id from eg_demand_reason_master where code = 'WTADVANCE'));
	
	--1st Half
	SELECT nextval('seq_eg_demand_details') INTO v_ddfirsthalf;

	if(v_demandAmountfromWtRate is not null)then
		insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, 
		modified_date, 	create_date, amt_collected, amt_rebate) values (v_ddfirsthalf, in_newdemandid, 
		v_demandreason_1instalment, 	null, null, 	null,v_demandAmountfromWtRate, now(), now(), 0, 0);

	--2nd Half
		SELECT nextval('seq_eg_demand_details') INTO v_ddsecondhalf;
		insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, 
		modified_date, 	create_date, amt_collected, amt_rebate) values (v_ddsecondhalf, in_newdemandid, 
		v_demandreason_2instalment, null, null, 	null,v_demandAmountfromWtRate, now(), now(), 0, 0);
		raise notice ' new demand for v_demandreason_1instalment generated for demand in_newdemandid (%)',in_newdemandid;
	 	update eg_demand set base_demand= v_sumOfAmount+(2*v_demandAmountfromWtRate) where id=in_newdemandid;
		raise notice 'new demand details id (% %)',v_ddfirsthalf,v_ddsecondhalf;
	else
		insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, 
		modified_date, 	create_date, amt_collected, amt_rebate) values (v_ddfirsthalf, in_newdemandid, 
		v_demandreason_1instalment, null, null, null,v_oldddAmount, now	(), now(), 0, 0);
		SELECT nextval('seq_eg_demand_details') INTO v_ddsecondhalf;
		insert into eg_demand_details(id, id_demand, id_demand_reason, id_status, file_reference_no, remarks, amount, 
		modified_date, create_date, amt_collected, amt_rebate) values (v_ddsecondhalf, in_newdemandid, 
		v_demandreason_2instalment, null, null, null,v_oldddAmount, now(), now(), 0, 0);
		update eg_demand set base_demand=  v_sumOfAmount + (2*v_oldddAmount) where id=in_newdemandid;
	end if;
	if(v_advanceAmtColl > 0) then
	v_temp := wtms_advanceAdjustment(in_olddemandid, in_newdemandid, in_new_2ndinstid);
	else
	raise notice 'advance collection is not present';
	end if;
 	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;


--City wise rollover
CREATE OR REPLACE FUNCTION wtms_advanceAdjustment(in_olddemandid bigint, in_newdemandid bigint, in_new_2ndinstid bigint)
RETURNS numeric AS
$BODY$
DECLARE
demanddets record;
v_demanddetid 			integer;
v_amount 			double precision;
v_collection 	double precision;
v_balance 		double precision;
v_advancecoll 	double precision;
v_temp 			integer;
v_assessmentno character varying(24);
v_finyear character varying(24);
BEGIN

	select dd.amt_collected into v_advancecoll from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm where dd.id_demand=in_olddemandid and dd.id_demand_reason=dr.id and dr.id_demand_reason_master=drm.id and drm.code='WTADVANCE';

	if (v_advancecoll>0) then
	
	  for demanddets in (select dd.id ddid, dd.amount, dd.amt_collected from eg_demand_details dd, eg_demand_reason dr, 	eg_demand_reason_master drm, eg_installment_master installment where dd.id_demand=in_newdemandid and dd.id_demand_reason=dr.id and dr.id_demand_reason_master=drm.id and dr.id_installment=installment.id and drm.code!='WTADVANCE' and (dd.amount-dd.amt_collected)>0 order by installment.start_date, drm."order")
	    loop 
		  v_demanddetid := demanddets.ddid;
		  v_amount := demanddets.amount;
		  v_collection := demanddets.amt_collected;
		  v_balance := v_amount-v_collection;
		
		  begin

			  if(v_advancecoll=0)then
				  return v_temp; 
			  end if;
			  if(v_advancecoll>v_balance)then
				  update eg_demand_details set amt_collected=amt_collected+v_balance where id=v_demanddetid;
				  v_advancecoll := v_advancecoll - v_balance;
			  else
				  update eg_demand_details set amt_collected=amt_collected+v_advancecoll where id=v_demanddetid;
				  v_advancecoll := 0;
			  end if;

		  EXCEPTION
		  WHEN OTHERS THEN
		  raise notice 'rolloverward : % %', SQLERRM, SQLSTATE;
		  END;
	    END LOOP;
	  if (v_advancecoll > 0) then
	    Insert into eg_demand_details (ID,ID_DEMAND,ID_DEMAND_REASON,ID_STATUS,FILE_REFERENCE_NO,REMARKS,AMOUNT,modified_date,create_date,AMT_COLLECTED,AMT_REBATE) 
	    values (nextval('seq_eg_demand_details'),in_newdemandid,(select id from eg_demand_reason where id_installment = in_new_2ndinstid
	    and id_demand_reason_master = (select id from eg_demand_reason_master where code = 'WTADVANCE')),1,null,null,v_advancecoll,
now(),now(),0,0);
	  end if;
	end if;
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION wtms_rolloversingleconsumerCode(in_consumerNumber varchar(16), in_oldinststartdate varchar(16), in_new1st_inststartdate varchar(16), in_new2nd_inststartdate varchar(16))
RETURNS numeric AS
$BODY$
DECLARE
v_idconndetail	integer;
v_oldinstid 	bigint;
v_new1st_instid bigint;
v_new2nd_instid bigint;
v_currinstdesc 	varchar(16);
v_moduleid 		bigint;
v_newInstId 	integer;
v_temp 			integer;
BEGIN
	

	select id into v_moduleid from eg_module where name='Property Tax';
	select id into v_oldinstid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_oldinststartdate, 'dd/MM/yyyy');
	select id into v_new1st_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new1st_inststartdate, 'dd/MM/yyyy');
	select id into v_new2nd_instid from eg_installment_master where id_module=v_moduleid and start_date=to_date(in_new2nd_inststartdate, 'dd/MM/yyyy');
	raise notice 'rolloversingleconnection : v_oldinstid, v_new1st_instid, v_new2nd_instid (% % %)', v_oldinstid, v_new1st_instid, v_new2nd_instid;
	SELECT conndet.id into v_idconndetail FROM egwtr_connection conn,egwtr_connectiondetails conndet,egw_status status where   conn.id=conndet.connection and conndet.connectionstatus='ACTIVE' and conndet.connectiontype='NON_METERED' AND conndet.statusid=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' AND conn.consumercode=in_consumerNumber; 

	raise notice 'wtms_rolloversingleconsumerCode : v_idconndetail (%)', v_idconndetail;
	
		v_temp  := wtms_rolloverByConnectionDetId(v_idconndetail, v_oldinstid, v_new1st_instid, v_new2nd_instid);
	
	return v_temp;
END;
$BODY$ LANGUAGE plpgsql;
