
--Precedure for Sewerage Tax

CREATE OR REPLACE FUNCTION getSewerageTaxTotalConnectionSumofDemand(in_assessmentNumber  varchar(16),OUT v_firstInstAmount double precision,
OUT v_secondInstAmount double precision,
OUT v_advance double precision,
OUT v_arrearInstAmount double precision,
OUT consumercodearray  character varying(1000))
AS $$
DECLARE
v_curr1stinst  bigint;
v_curr2ndinst bigint;
v_moduleid  bigint;
v_swmoduleid bigint;
v_demandId bigint;
v_finyearstartdate date;
v_firstInstAmount_temp double precision;
v_secondInstAmount_temp double precision;
v_advance_temp double precision;
v_arrearInstAmount_temp double precision;
v_finyearenddate date;
rec record;
v_rollovercount integer default 0;
BEGIN
    select date(startingdate), date(endingdate) into v_finyearstartdate, v_finyearenddate from financialyear where now() between startingdate 		and endingdate;
    select id into v_swmoduleid from eg_module where name='Sewerage Tax Management';
    select id into v_curr1stinst from eg_installment_master where id_module=v_swmoduleid and date(start_date)=v_finyearstartdate;
    select id into v_curr2ndinst from eg_installment_master where id_module=v_swmoduleid and date(end_date)=v_finyearenddate;
  	v_firstInstAmount =0.0;
	v_secondInstAmount=0.0;
	v_advance=0.0;v_arrearInstAmount=0.0;
	consumercodearray='';
	for rec in (select  distinct conn.shsc_number,appdet.id,conndet.id from egswtax_connection conn,egswtax_applicationdetails appdet,
		egswtax_connectiondetail conndet,egswtax_demand_connection conndem, eg_demand demand where conn.id=appdet.connection and
		 conndet.id=appdet.connectiondetail and conndem.applicationdetail=appdet.id and demand.id=conndem.demand and demand.is_history='N' and appdet.isactive='true'
		 and conn.status='ACTIVE' and conndet.propertyidentifier=in_assessmentNumber)
loop
	begin
		if(v_rollovercount = 0)then
		consumercodearray := rec.shsc_number;
		else 
		consumercodearray := consumercodearray ||',' ||rec.shsc_number;
		end if;
		select   demand.id into v_demandId from  egswtax_demand_connection condem,eg_demand demand where condem.demand=demand.id and 		 demand.is_history='N' and condem.applicationdetail=rec.id;

		v_rollovercount := v_rollovercount +1;

      	select COALESCE(sum(COALESCE(dd.amount, 0)),0)
        into v_firstInstAmount_temp
        from eg_demand_details dd, 
		eg_demand_reason dr, 
		eg_demand_reason_master drm
        where dd.id_demand_reason=dr.id
        and dr.id_demand_reason_master=drm.id
        and drm.module=v_swmoduleid 
        and drm.code = 'SEWERAGETAX'
        and dr.id_installment=v_curr1stinst
        and dd.id_demand in(v_demandId);

		v_firstInstAmount := v_firstInstAmount + v_firstInstAmount_temp;

		select COALESCE(sum(COALESCE(dd.amount, 0)),0)
        into v_secondInstAmount_temp
        from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm
        where dd.id_demand_reason=dr.id
        and dr.id_demand_reason_master=drm.id
        and drm.module=v_swmoduleid
        and drm.code = 'SEWERAGETAX'
        and dr.id_installment=v_curr2ndinst
        and dd.id_demand in(v_demandId);
     	v_secondInstAmount := v_secondInstAmount + v_secondInstAmount_temp;

		select COALESCE(sum(COALESCE(dd.amount, 0)),0)
        into v_arrearInstAmount_temp
        from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm
        where dd.id_demand_reason=dr.id
        and dr.id_demand_reason_master=drm.id
        and drm.module=v_swmoduleid
        and drm.code = 'SEWERAGETAX'
        and dr.id_installment not in(v_curr1stinst,v_curr2ndinst)
        and dd.id_demand in(v_demandId);
     	v_arrearInstAmount := v_arrearInstAmount + v_arrearInstAmount_temp;

        select COALESCE(sum(COALESCE(dd.amt_collected, 0)),0)
        into v_advance_temp
        from eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm
        where dd.id_demand_reason=dr.id
        and dr.id_demand_reason_master=drm.id
        and drm.module=v_swmoduleid
        and drm.code = 'SEWERAGEADVANCE'
        and dr.id_installment=v_curr2ndinst
        and dd.id_demand in(v_demandId);
     	v_advance := v_advance + v_advance_temp;

	raise notice 'firstinstamount ,secondinstamount,arrearinstamount,advancecollectedamt ( % % % % )',v_firstInstAmount,v_secondInstAmount,v_arrearInstAmount,v_advance;
	EXCEPTION
		WHEN OTHERS THEN
		raise notice 'error in calculation: % %', SQLERRM, SQLSTATE;
		END;
	END LOOP; 
    END; $$
LANGUAGE plpgsql;